/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class ProcessResult {
    static final int NO_EXIT_CODE = Integer.MIN_VALUE;
    static final long NO_DURATION = Long.MIN_VALUE;
    static final String IDENT1 = "   ";
    static final String IDENT2 = "      ";
    long duration = Long.MIN_VALUE;
    String workingDir = "";
    String command = "";
    String stdOut = "";
    String errOut = "";
    Exception exception;
    int exitCode = Integer.MIN_VALUE;

    public ProcessResult() {
    }

    public ProcessResult(ProcessResult processResult) {
        this.workingDir = processResult.getWorkingDir();
        this.command = processResult.getCommand();
        this.duration = processResult.getDuration();
        this.exception = processResult.getException();
        this.exitCode = processResult.getExitCode();
        this.stdOut = processResult.getStdOut();
        this.errOut = processResult.getErrOut();
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getCommand() {
        return this.command;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getStdOut() {
        return this.stdOut;
    }

    public String getErrOut() {
        return this.errOut;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    List<Pair<String, String>> getProperties() {
        ArrayList<Pair<String, String>> props = new ArrayList<Pair<String, String>>();
        props.add(Tuples.pair((Object)"workingDir", (Object)this.workingDir));
        props.add(Tuples.pair((Object)"command", (Object)this.command));
        props.add(Tuples.pair((Object)"exit code", (Object)(this.exitCode == Integer.MIN_VALUE ? "-" : String.valueOf(this.exitCode))));
        props.add(Tuples.pair((Object)"duration", (Object)(this.duration == Long.MIN_VALUE ? "-" : String.valueOf(this.duration) + "ms")));
        props.add(Tuples.pair((Object)"exception", (Object)(this.exception == null ? "" : this.exception.toString())));
        props.add(Tuples.pair((Object)"std out", (Object)""));
        if (this.stdOut != null && !this.stdOut.isBlank()) {
            props.add((Pair<String, String>)Tuples.pair(null, (Object)(">>>>\n" + this.stdOut + "\n<<<<")));
        }
        props.add(Tuples.pair((Object)"err out", (Object)""));
        if (this.errOut != null && !this.errOut.isBlank()) {
            props.add((Pair<String, String>)Tuples.pair(null, (Object)(">>>>\n" + this.errOut + "\n<<<<")));
        }
        return props;
    }

    public String toString() {
        String s = "Result:\n";
        for (Pair<String, String> prop : this.getProperties()) {
            String first = (String)prop.getFirst();
            String second = (String)prop.getSecond();
            s = first == null ? String.valueOf(s) + second + "\n" : String.valueOf(s) + String.format("%s%-12s:   %s\n", IDENT1, first, second);
        }
        s = String.valueOf(s) + "Result End.\n";
        return s;
    }
}

