/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xpect.ui.XpectPluginActivator;
import org.eclipse.xpect.util.IBundleInfo;
import org.eclipse.xpect.util.ResourceAccess;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class UIBundleInfoRegistry
implements IBundleInfo.Registry {
    public Collection<String> getAllBundleNames() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        Bundle[] bundleArray = XpectPluginActivator.getInstance().getBundle().getBundleContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            result.add(bundle.getSymbolicName());
            ++n2;
        }
        return result;
    }

    public IBundleInfo getBundle(Class<?> clazz) {
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        if (bundle == null) {
            return null;
        }
        URI locationURI = this.getBundleLocationURI(bundle);
        Bundle[] fragments = Platform.getFragments((Bundle)bundle);
        if (fragments == null || fragments.length == 0) {
            return new UIBundleInfo(locationURI, bundle);
        }
        String classURI = this.getClassURI(clazz).toString();
        if (classURI.startsWith(locationURI.toString())) {
            return new UIBundleInfo(locationURI, bundle);
        }
        Bundle[] bundleArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle fragment = bundleArray[n2];
            URI fragmentURI = this.getBundleLocationURI(fragment);
            if (classURI.startsWith(fragmentURI.toString())) {
                return new UIBundleInfo(fragmentURI, fragment);
            }
            ++n2;
        }
        return null;
    }

    public IBundleInfo getBundle(String symbolicName) {
        Bundle bundle = Platform.getBundle((String)symbolicName);
        return bundle != null ? new UIBundleInfo(this.getBundleLocationURI(bundle), bundle) : null;
    }

    public IBundleInfo getBundle(URI uri) {
        return new IBundleInfo.BundleInfo(null, uri);
    }

    private URI getBundleLocationURI(Bundle bundle) {
        try {
            URI uri = URI.createURI((String)FileLocator.resolve((URL)bundle.getEntry("/")).toString());
            if (uri.isArchive()) {
                return uri;
            }
            File current = new File(uri.toFileString());
            while (current != null) {
                if (!new File(current, "META-INF").isDirectory()) continue;
                return URI.createFileURI((String)current.toString()).appendSegment("");
            }
            return uri;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private URI getClassURI(Class<?> clazz) {
        try {
            URL resource = clazz.getClassLoader().getResource("/" + clazz.getName().replace('.', '/') + ".class");
            URL url = FileLocator.resolve((URL)resource);
            return URI.createURI((String)url.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class UIBundleInfo
    implements IBundleInfo {
        private final Bundle bundle;
        private final URI locationURI;

        public UIBundleInfo(URI locationURI, Bundle bundle) {
            this.locationURI = locationURI;
            this.bundle = bundle;
        }

        public List<URI> find(IBundleInfo.Context context) {
            return this.getInfo().find(context);
        }

        public URI find(IBundleInfo.Context context, String fileName) {
            return this.getInfo().find(context, fileName);
        }

        public List<URI> find(IBundleInfo.Context context, String path, Predicate<String> matcher, String ... fileExtensions) {
            return this.getInfo().find(context, path, matcher, fileExtensions);
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        private ResourceAccess.ResourceInfo getInfo() {
            return ResourceAccess.create((URI)this.getRootURI());
        }

        public URI getRootURI() {
            return this.locationURI;
        }

        public String getSymbolicName() {
            return this.bundle.getSymbolicName();
        }

        public String toString() {
            String type = Platform.isFragment((Bundle)this.bundle) ? "fragment" : "bundle";
            return String.valueOf(type) + " '" + this.getSymbolicName() + "' locationURI:" + this.getRootURI();
        }
    }
}

