/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.expectation.impl;

import com.google.common.base.Function;
import org.eclipse.xpect.expectation.impl.StringCollection;
import org.eclipse.xpect.expectation.impl.TargetSyntaxSupport;
import org.eclipse.xpect.util.ReflectionUtil;

public class ActualCollection
extends StringCollection<ActualItem> {
    private Function<Object, String> itemFormatter;
    private TargetSyntaxSupport.TargetLiteralSupport targetLiteralSupport;

    public Function<Object, String> getItemFormatter() {
        return this.itemFormatter;
    }

    public TargetSyntaxSupport.TargetLiteralSupport getTargetLiteralSupport() {
        return this.targetLiteralSupport;
    }

    public void init(Iterable<?> actual) {
        this.items = this.createCollection();
        for (Object obj : actual) {
            String string = (String)this.itemFormatter.apply(obj);
            String escaped = this.targetLiteralSupport.escape(string);
            this.items.add(new ActualItem(escaped));
        }
    }

    @Deprecated
    public void init(Iterable<?> actual, Class<? extends Function<Object, String>> functionClass) {
        this.setItemFormatter(ReflectionUtil.newInstanceUnchecked(functionClass));
        this.init(actual);
    }

    public void init(String ... actual) {
        this.items = this.createCollection();
        String[] stringArray = actual;
        int n = actual.length;
        int n2 = 0;
        while (n2 < n) {
            String obj = stringArray[n2];
            this.items.add(new ActualItem(obj));
            ++n2;
        }
    }

    public void setItemFormatter(Function<Object, String> itemFormatter) {
        this.itemFormatter = itemFormatter;
    }

    public void setTargetLiteralSupport(TargetSyntaxSupport.TargetLiteralSupport targetLiteralSupport) {
        this.targetLiteralSupport = targetLiteralSupport;
    }

    public class ActualItem
    extends StringCollection.Item {
        public ActualItem(String pure) {
            super(ActualCollection.this, pure);
        }
    }

    public static class ToString
    implements Function<Object, String> {
        public String apply(Object from) {
            return from == null ? "null" : from.toString();
        }
    }
}

