/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.naming;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.ts.scoping.N4TSQualifiedNameProvider;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.xtext.naming.QualifiedName;

public class N4JSQualifiedNameProvider
extends N4TSQualifiedNameProvider {
    public static final String PACKAGE_JSON_SEGMENT = "!package_json";

    public QualifiedName getFullyQualifiedName(EObject it) {
        QualifiedName _fullyQualifiedName;
        String _name;
        boolean _tripleNotEquals;
        QualifiedName _xifexpression;
        QualifiedName _switchResult = null;
        boolean _matched = false;
        if (it instanceof Script) {
            _matched = true;
            _switchResult = this.getFullyQualifiedName((EObject)((Script)it).getModule());
        }
        if (!_matched && it instanceof TModule) {
            _matched = true;
            _xifexpression = null;
            String _qualifiedName = ((TModule)it).getQualifiedName();
            boolean bl = _tripleNotEquals = _qualifiedName != null;
            if (_tripleNotEquals) {
                _xifexpression = this.fqnTModule((TModule)it);
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && it instanceof N4TypeDeclaration) {
            _matched = true;
            _xifexpression = null;
            _name = ((N4TypeDeclaration)it).getName();
            boolean bl = _tripleNotEquals = _name != null;
            if (_tripleNotEquals) {
                _xifexpression = this.fqnTypeDeclaration((N4TypeDeclaration)it);
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && it instanceof FunctionDeclaration) {
            _matched = true;
            _xifexpression = null;
            if (((FunctionDeclaration)it).getName() != null && ((FunctionDeclaration)it).eContainer() instanceof ExportDeclaration) {
                _fullyQualifiedName = this.getFullyQualifiedName(EcoreUtil.getRootContainer((EObject)it));
                QualifiedName _append = null;
                if (_fullyQualifiedName != null) {
                    _append = _fullyQualifiedName.append(((FunctionDeclaration)it).getName());
                }
                _xifexpression = _append;
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && it instanceof VariableDeclaration) {
            _matched = true;
            _xifexpression = null;
            if (((VariableDeclaration)it).getName() != null && ((VariableDeclaration)it).eContainer() instanceof ExportDeclaration) {
                _fullyQualifiedName = this.getFullyQualifiedName(EcoreUtil.getRootContainer((EObject)it));
                QualifiedName _append = null;
                if (_fullyQualifiedName != null) {
                    _append = _fullyQualifiedName.append(((VariableDeclaration)it).getName());
                }
                _xifexpression = _append;
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && it instanceof TClass) {
            boolean _tripleNotEquals2;
            _matched = true;
            _xifexpression = null;
            _name = ((TClass)it).getName();
            boolean bl = _tripleNotEquals2 = _name != null;
            if (_tripleNotEquals2) {
                _xifexpression = this.fqnTClassifier((TClassifier)it);
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && it instanceof TInterface) {
            boolean _tripleNotEquals3;
            _matched = true;
            _xifexpression = null;
            _name = ((TInterface)it).getName();
            boolean bl = _tripleNotEquals3 = _name != null;
            if (_tripleNotEquals3) {
                _xifexpression = this.fqnTClassifier((TClassifier)it);
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && it instanceof TEnum) {
            boolean _tripleNotEquals4;
            _matched = true;
            _xifexpression = null;
            _name = ((TEnum)it).getName();
            boolean bl = _tripleNotEquals4 = _name != null;
            if (_tripleNotEquals4) {
                QualifiedName _fullyQualifiedName2 = this.getFullyQualifiedName(EcoreUtil.getRootContainer((EObject)it));
                QualifiedName _append = null;
                if (_fullyQualifiedName2 != null) {
                    String _name_1;
                    String _elvis = null;
                    String _exportedName = ((TEnum)it).getExportedName();
                    _elvis = _exportedName != null ? _exportedName : (_name_1 = ((TEnum)it).getName());
                    _append = _fullyQualifiedName2.append(_elvis);
                }
                _xifexpression = _append;
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && it instanceof TFunction) {
            _matched = true;
            _xifexpression = null;
            if (((TFunction)it).getName() != null && ((TFunction)it).isExported()) {
                _fullyQualifiedName = this.getFullyQualifiedName(EcoreUtil.getRootContainer((EObject)it));
                QualifiedName _append = null;
                if (_fullyQualifiedName != null) {
                    _append = _fullyQualifiedName.append(((TFunction)it).getExportedName());
                }
                _xifexpression = _append;
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && it instanceof TVariable) {
            _matched = true;
            _xifexpression = null;
            if (((TVariable)it).getName() != null && ((TVariable)it).isExported()) {
                _fullyQualifiedName = this.getFullyQualifiedName(EcoreUtil.getRootContainer((EObject)it));
                QualifiedName _append = null;
                if (_fullyQualifiedName != null) {
                    _append = _fullyQualifiedName.append(((TVariable)it).getExportedName());
                }
                _xifexpression = _append;
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && it instanceof ExportDeclaration) {
            _matched = true;
            ExportableElement _exportedElement = ((ExportDeclaration)it).getExportedElement();
            _fullyQualifiedName = null;
            if (_exportedElement != null) {
                _fullyQualifiedName = this.getFullyQualifiedName((EObject)_exportedElement);
            }
            _switchResult = _fullyQualifiedName;
        }
        if (!_matched && it instanceof TypeVariable) {
            _matched = true;
            _switchResult = null;
        }
        if (!_matched && it instanceof Type) {
            boolean _tripleNotEquals5;
            _matched = true;
            _xifexpression = null;
            _name = ((Type)it).getName();
            boolean bl = _tripleNotEquals5 = _name != null;
            if (_tripleNotEquals5) {
                _xifexpression = QualifiedName.create((String)((Type)it).getName());
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && it instanceof TMember) {
            _matched = true;
            _switchResult = null;
        }
        if (!_matched && it instanceof IdentifiableElement) {
            _matched = true;
            _switchResult = null;
        }
        if (!_matched && it instanceof JSONDocument) {
            _matched = true;
            _switchResult = this.fqnJSONDocument((JSONDocument)it);
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    private QualifiedName fqnTModule(TModule module) {
        if (module.getQualifiedName().length() != 0 && !AnnotationDefinition.GLOBAL.hasAnnotation((TAnnotableElement)module)) {
            QualifiedName plainQN = this.converter.toQualifiedName(module.getQualifiedName());
            boolean _isStaticPolyfillModule = module.isStaticPolyfillModule();
            if (_isStaticPolyfillModule) {
                return N4TSQualifiedNameProvider.prepend((String)N4TSQualifiedNameProvider.MODULE_POLYFILL_SEGMENT, (QualifiedName)plainQN);
            }
            return plainQN;
        }
        return QualifiedName.create((String)N4TSQualifiedNameProvider.GLOBAL_NAMESPACE_SEGMENT);
    }

    private QualifiedName fqnTypeDeclaration(N4TypeDeclaration typeDecl) {
        String _name;
        QualifiedName prefix = this.getFullyQualifiedName(EcoreUtil.getRootContainer((EObject)typeDecl));
        if (N4JSLanguageUtils.isPolyfill((AnnotableElement)typeDecl) || N4JSLanguageUtils.isStaticPolyfill((AnnotableElement)typeDecl)) {
            prefix = N4TSQualifiedNameProvider.append((QualifiedName)prefix, (String)N4TSQualifiedNameProvider.POLYFILL_SEGMENT);
        }
        String _elvis = null;
        String _exportedName = typeDecl.getExportedName();
        _elvis = _exportedName != null ? _exportedName : (_name = typeDecl.getName());
        QualifiedName fqn = N4TSQualifiedNameProvider.append((QualifiedName)prefix, (String)_elvis);
        return fqn;
    }

    private QualifiedName fqnTClassifier(TClassifier tClassifier) {
        String _name;
        QualifiedName prefix = this.getFullyQualifiedName(EcoreUtil.getRootContainer((EObject)tClassifier));
        boolean _isPolyfill = tClassifier.isPolyfill();
        if (_isPolyfill) {
            prefix = N4TSQualifiedNameProvider.append((QualifiedName)prefix, (String)N4TSQualifiedNameProvider.POLYFILL_SEGMENT);
        }
        String _elvis = null;
        String _exportedName = tClassifier.getExportedName();
        _elvis = _exportedName != null ? _exportedName : (_name = tClassifier.getName());
        QualifiedName fqn = N4TSQualifiedNameProvider.append((QualifiedName)prefix, (String)_elvis);
        return fqn;
    }

    private QualifiedName fqnJSONDocument(JSONDocument document) {
        QualifiedName fqnBase;
        URI uri;
        Resource res = document.eResource();
        URI _uRI = null;
        if (res != null) {
            _uRI = res.getURI();
        }
        if ((uri = _uRI) == null || !Objects.equal((Object)uri.lastSegment(), (Object)"package.json")) {
            return null;
        }
        String projectName = null;
        JSONValue content = document.getContent();
        if (content instanceof JSONObject) {
            JSONValue value = JSONModelUtils.getProperty((JSONObject)((JSONObject)content), (String)PackageJsonProperties.NAME.name).orElse(null);
            String _xifexpression = null;
            _xifexpression = value instanceof JSONStringLiteral ? ((JSONStringLiteral)value).getValue() : null;
            projectName = _xifexpression;
        }
        if (projectName == null) {
            projectName = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI(uri.trimSegments(1));
        }
        if (projectName != null && !projectName.isEmpty() && (fqnBase = this.converter.toQualifiedName(projectName)) != null) {
            return fqnBase.append(PACKAGE_JSON_SEGMENT);
        }
        return null;
    }
}

