/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableDeclarationOrBinding;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.n4JS.VariableStatementKeyword;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.Result;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class N4JSStatementValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private N4JSTypeSystem typeSystem;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkVariableStatement(VariableStatement variableStatement) {
        if (variableStatement.getVarStmtKeyword() == VariableStatementKeyword.CONST) {
            variableStatement.getVarDecl().stream().forEach(varDecl -> {
                boolean bl = this.holdsConstHasInitializer((VariableDeclaration)varDecl);
            });
        }
    }

    private boolean holdsConstHasInitializer(VariableDeclaration varDecl) {
        if (!this.jsVariantHelper.constantHasInitializer((EObject)varDecl)) {
            return true;
        }
        return varDecl.getExpression() != null;
    }

    @Check
    public void checkVariableStatement(Statement statement) {
        EObject con = statement.eContainer();
        if (con instanceof Script) {
            Script script = (Script)con;
            if (!N4JSLanguageUtils.isContainedInStaticPolyfillModule((AnnotableElement)script)) {
                return;
            }
            if (statement instanceof FunctionDeclaration) {
                return;
            }
            this.addIssue(IssueCodes.getMessageForPOLY_STATIC_POLYFILL_MODULE_ONLY_FILLING_CLASSES(), (EObject)statement, "POLY_STATIC_POLYFILL_MODULE_ONLY_FILLING_CLASSES");
        }
    }

    @Check
    public void checkForInLoop(ForStatement forStatement) {
        if (forStatement.isForIn()) {
            Object res;
            Object loopVarType = null;
            Expression location = null;
            RuleEnvironment G = (RuleEnvironment)this.getContext().get(RuleEnvironment.class);
            if (G == null) {
                return;
            }
            if (!forStatement.getVarDeclsOrBindings().isEmpty()) {
                VariableDeclarationOrBinding varDeclOrBinding = (VariableDeclarationOrBinding)forStatement.getVarDeclsOrBindings().iterator().next();
                location = varDeclOrBinding;
                if (varDeclOrBinding instanceof VariableDeclaration) {
                    loopVarType = ((VariableDeclaration)varDeclOrBinding).getDeclaredTypeRef();
                } else {
                    VariableBinding varBinding = (VariableBinding)varDeclOrBinding;
                    TypeRef res2 = this.typeSystem.type(G, (TypableElement)varBinding.getExpression());
                    if (!(res2 instanceof UnknownTypeRef)) {
                        loopVarType = res2;
                    }
                }
            } else if (forStatement.getInitExpr() != null) {
                location = forStatement.getInitExpr();
                res = this.typeSystem.type(G, (TypableElement)forStatement.getInitExpr());
                if (!(res instanceof UnknownTypeRef)) {
                    loopVarType = res;
                }
            }
            if (loopVarType != null && !((Result)(res = this.typeSystem.subtype(G, (TypeArgument)RuleEnvironmentExtensions.stringTypeRef(G), (TypeArgument)loopVarType))).isSuccess()) {
                this.addIssue(IssueCodes.getMessageForTYS_FOR_IN_VAR_STRING(loopVarType.getTypeRefAsString()), (EObject)location, "TYS_FOR_IN_VAR_STRING");
            }
        }
    }
}

