/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.SWTWalk;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;

class GitHistoryWalk
extends SWTWalk {
    private boolean initialized = false;
    private final AnyObjectId headId;
    private final ObjectId toShow;

    GitHistoryWalk(Repository repository, AnyObjectId headId, ObjectId toShow) {
        super(repository);
        this.headId = headId;
        this.toShow = toShow;
    }

    public RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (!this.initialized) {
            this.initialize();
        }
        return super.next();
    }

    protected void reset(int retainFlags) {
        super.reset(retainFlags);
        this.initialized = false;
    }

    private void initialize() throws IOException {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        RefDatabase db = this.getRepository().getRefDatabase();
        try {
            if (store.getBoolean("resourcehistory_show_all_branches")) {
                this.markStartAllRefs(db, "refs/heads/");
                this.markStartAllRefs(db, "refs/remotes/");
                this.markStartAllRefs(db, "refs/tags/");
            }
            if (store.getBoolean("resourcehistory_show_additionalrefs")) {
                this.markStartAdditionalRefs(db);
            }
            if (store.getBoolean("resourcehistory_show_notes")) {
                this.markStartAllRefs(db, "refs/notes/");
            } else {
                this.markUninteresting(db, "refs/notes/");
            }
            this.markStart(this.parseCommit(this.headId));
            if (this.toShow != null) {
                this.markStart(this.toShow);
            }
        }
        catch (IOException e) {
            throw new IOException(MessageFormat.format(UIText.GitHistoryPage_errorSettingStartPoints, Activator.getDefault().getRepositoryUtil().getRepositoryName(this.getRepository())), e);
        }
        this.initialized = true;
    }

    private void markStartAllRefs(RefDatabase db, String prefix) throws IOException, IncorrectObjectTypeException {
        for (Ref ref : db.getRefsByPrefix(prefix)) {
            if (ref.isSymbolic()) continue;
            this.markStartRef(ref);
        }
    }

    private void markStartAdditionalRefs(RefDatabase db) throws IOException, IncorrectObjectTypeException {
        for (Ref ref : db.getAdditionalRefs()) {
            this.markStartRef(ref);
        }
    }

    private void markStart(ObjectId id) throws IOException, IncorrectObjectTypeException {
        try {
            RevObject peeled = this.peel(this.parseAny((AnyObjectId)id));
            if (peeled instanceof RevCommit) {
                this.markStart((RevCommit)peeled);
            }
        }
        catch (MissingObjectException missingObjectException) {
            // empty catch block
        }
    }

    private void markStartRef(Ref ref) throws IOException, IncorrectObjectTypeException {
        this.markStart(ref.getLeaf().getObjectId());
    }

    private void markUninteresting(RefDatabase db, String prefix) throws IOException, IncorrectObjectTypeException {
        for (Ref ref : db.getRefsByPrefix(prefix)) {
            if (ref.isSymbolic()) continue;
            try {
                RevObject refTarget = this.parseAny((AnyObjectId)ref.getLeaf().getObjectId());
                if (!(refTarget instanceof RevCommit)) continue;
                this.markUninteresting((RevCommit)refTarget);
            }
            catch (MissingObjectException missingObjectException) {
                // empty catch block
            }
        }
    }
}

