/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TEnumLiteral;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class EnumAccessTransformation
extends Transformation {
    private final Map<TEnum, VariableDeclaration> literalsConstants = CollectionLiterals.newHashMap();
    private TMember member_StringBasedEnum_literals;

    public void assertPreConditions() {
        this.assertNotNull("member of built-in type not found: StringBasedEnum#literals", this.member_StringBasedEnum_literals);
    }

    public void assertPostConditions() {
    }

    public void analyze() {
        this.member_StringBasedEnum_literals = RuleEnvironmentExtensions.n4StringBasedEnumType((RuleEnvironment)this.getState().G).findOwnedMember("literals", false, true);
    }

    public void transform() {
        Consumer<ParameterizedPropertyAccessExpression_IM> _function = it -> this.transformEnumAccess((ParameterizedPropertyAccessExpression_IM)it);
        this.collectNodes((EObject)this.getState().im, ParameterizedPropertyAccessExpression_IM.class, true).forEach(_function);
    }

    private void transformEnumAccess(ParameterizedPropertyAccessExpression_IM expr) {
        SymbolTableEntry propSTE = expr.getProperty_IM();
        IdentifiableElement _xifexpression = null;
        if (propSTE instanceof SymbolTableEntryOriginal) {
            _xifexpression = ((SymbolTableEntryOriginal)propSTE).getOriginalTarget();
        }
        IdentifiableElement prop = _xifexpression;
        boolean _matched = false;
        if (prop instanceof TEnumLiteral) {
            _matched = true;
            this.transformEnumLiteralAccess(this.resolveOriginalStringBasedEnum(expr), expr, (TEnumLiteral)prop);
        }
        if (!_matched && prop == this.member_StringBasedEnum_literals) {
            _matched = true;
            this.transformEnumLiteralsConstantAccess(this.resolveOriginalStringBasedEnum(expr), expr);
        }
    }

    private void transformEnumLiteralAccess(TEnum originalEnum, ParameterizedPropertyAccessExpression_IM expr, TEnumLiteral prop) {
        if (originalEnum != null && expr != null && prop != null) {
            this.replace((Expression)expr, (Expression)this.enumLiteralToStringLiteral(prop));
        }
    }

    private void transformEnumLiteralsConstantAccess(TEnum originalEnum, ParameterizedPropertyAccessExpression_IM expr) {
        if (originalEnum != null && expr != null) {
            this.replace((Expression)expr, (Expression)this.getReferenceToLiteralsConstant(originalEnum));
        }
    }

    private TEnum resolveOriginalStringBasedEnum(ParameterizedPropertyAccessExpression_IM pex) {
        boolean _isStringBased;
        IdentifiableElement orginal;
        SymbolTableEntry targetEnumSTE = this.resolveOriginalExpressionTarget(pex.getTarget());
        if (targetEnumSTE instanceof SymbolTableEntryOriginal && (orginal = ((SymbolTableEntryOriginal)targetEnumSTE).getOriginalTarget()) instanceof TEnum && (_isStringBased = this.isStringBased((TEnum)orginal))) {
            return (TEnum)orginal;
        }
        return null;
    }

    private SymbolTableEntry resolveOriginalExpressionTarget(Expression ex) {
        SymbolTableEntry _switchResult = null;
        boolean _matched = false;
        if (ex instanceof IdentifierRef_IM) {
            _matched = true;
            _switchResult = ((IdentifierRef_IM)ex).getRewiredTarget();
        }
        if (!_matched && ex instanceof ParameterizedPropertyAccessExpression_IM) {
            _matched = true;
            _switchResult = ((ParameterizedPropertyAccessExpression_IM)ex).getProperty_IM();
        }
        if (!_matched && ex instanceof ParenExpression) {
            _matched = true;
            _switchResult = this.resolveOriginalExpressionTarget(((ParenExpression)ex).getExpression());
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    private IdentifierRef_IM getReferenceToLiteralsConstant(TEnum tEnum) {
        VariableDeclaration vdecl = this.literalsConstants.get(tEnum);
        if (vdecl == null) {
            vdecl = this.createLiteralsConstant(tEnum);
            this.literalsConstants.put(tEnum, vdecl);
        }
        return TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.findSymbolTableEntryForElement((NamedElement)vdecl, false));
    }

    private VariableDeclaration createLiteralsConstant(TEnum tEnum) {
        String name = this.findUniqueNameForLiteralsConstant(tEnum);
        Functions.Function1 _function = it -> this.enumLiteralToStringLiteral((TEnumLiteral)it);
        VariableDeclaration vdecl = TranspilerBuilderBlocks._VariableDeclaration((String)name, (Expression)TranspilerBuilderBlocks._ArrLit((Expression[])((Expression[])Conversions.unwrapArray((Object)ListExtensions.map((List)tEnum.getLiterals(), (Functions.Function1)_function), Expression.class))));
        VariableStatement vstmnt = TranspilerBuilderBlocks._VariableStatement((VariableDeclaration[])new VariableDeclaration[]{vdecl});
        ImportDeclaration lastImport = (ImportDeclaration)IterableExtensions.last((Iterable)Iterables.filter((Iterable)this.getState().im.getScriptElements(), ImportDeclaration.class));
        if (lastImport != null) {
            this.insertAfter((EObject)lastImport, new EObject[]{vstmnt});
        } else {
            boolean _not;
            boolean _isEmpty = this.getState().im.getScriptElements().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                this.insertBefore((EObject)IterableExtensions.head((Iterable)this.getState().im.getScriptElements()), new EObject[]{vstmnt});
            } else {
                this.getState().im.getScriptElements().add((Object)vstmnt);
            }
        }
        this.createSymbolTableEntryIMOnly((NamedElement)vdecl);
        return vdecl;
    }

    private String findUniqueNameForLiteralsConstant(TEnum tEnum) {
        String newName;
        boolean _contains;
        Functions.Function1 _function = it -> it.getName();
        Set names = IterableExtensions.toSet((Iterable)IterableExtensions.map(this.literalsConstants.values(), (Functions.Function1)_function));
        String _elvis = null;
        String _name = null;
        if (tEnum != null) {
            _name = tEnum.getName();
        }
        if (_contains = names.contains(newName = "$enumLiteralsOf" + (_elvis = _name != null ? _name : "Unnamed"))) {
            int cnt = 1;
            while (names.contains(String.valueOf(newName) + Integer.valueOf(cnt))) {
                ++cnt;
            }
            newName = String.valueOf(newName) + Integer.valueOf(cnt);
        }
        return newName;
    }

    private boolean isStringBased(TEnum tEnum) {
        return AnnotationDefinition.STRING_BASED.hasAnnotation((TAnnotableElement)tEnum);
    }

    private StringLiteral enumLiteralToStringLiteral(TEnumLiteral enumLiteral) {
        String _name;
        String _elvis = null;
        String _value = null;
        if (enumLiteral != null) {
            _value = enumLiteral.getValue();
        }
        _elvis = _value != null ? _value : (_name = enumLiteral.getName());
        return TranspilerBuilderBlocks._StringLiteral((String)_elvis);
    }
}

