/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.labeling.helper;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.resource.N4JSCache;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TypeAccessModifier;
import org.eclipse.n4js.ui.labeling.N4JSLabelProvider;
import org.eclipse.n4js.ui.labeling.helper.N4JSDecoratorRow;
import org.eclipse.n4js.ui.labeling.helper.N4JSImageDescriptionLibrary;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ImageDescriptionHelper {
    private static String PLUGIN_ID = "org.eclipse.n4js.ui";
    @Inject
    private N4JSCache cache;
    @Inject
    private FileExtensionProvider fileExtensionProvider;
    @Inject
    private IResourceValidator resourceValidator;
    @Inject
    @Extension
    private N4JSImageDescriptionLibrary n4jsImageDescriptionLibrary;
    private N4JSLabelProvider labelProvider;

    public void setLabelProvider(N4JSLabelProvider provider) {
        this.labelProvider = provider;
        this.n4jsImageDescriptionLibrary.setImageDescriptionHelper(this);
    }

    public N4JSImageDescriptionLibrary getImageDescriptionLibrary() {
        return this.n4jsImageDescriptionLibrary;
    }

    public ImageDescriptor createValidationAwareImageDescriptor(EObject eo, String imageFileName) {
        boolean _tripleNotEquals;
        CancelIndicator mon;
        Optional<Severity> optSeverity;
        boolean _isPresent;
        ImageDescriptor _xblockexpression = null;
        ImageDescriptor mainImageDescriptor = this.createSimpleImageDescriptor(imageFileName);
        CancelIndicator _xifexpression = null;
        CancelIndicator _cancelIndicator = null;
        if (this.labelProvider != null) {
            _cancelIndicator = this.labelProvider.cancelIndicator;
        }
        if (_isPresent = (optSeverity = this.getMaxSeverityAtOrBelow(eo, mon = (_xifexpression = (_tripleNotEquals = _cancelIndicator != null) ? this.labelProvider.cancelIndicator : CancelIndicator.NullImpl))).isPresent()) {
            Severity _get = optSeverity.get();
            boolean _equals = Objects.equal((Object)_get, (Object)Severity.ERROR);
            if (_equals) {
                ImageDescriptor decorator = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR");
                return this.createDecorationOverlayIcon(mainImageDescriptor, decorator, 2);
            }
            Severity _get_1 = optSeverity.get();
            boolean _equals_1 = Objects.equal((Object)_get_1, (Object)Severity.WARNING);
            if (_equals_1) {
                ImageDescriptor decorator_1 = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_WARNING");
                return this.createDecorationOverlayIcon(mainImageDescriptor, decorator_1, 2);
            }
        }
        _xblockexpression = mainImageDescriptor;
        return _xblockexpression;
    }

    public ImageDescriptor createDecorationOverlayIcon(ImageDescriptor main, ImageDescriptor decorator, int quadrant) {
        return new N4JSDecoratorRow(main, quadrant, decorator);
    }

    public ImageDescriptor createDecorationComposite(ImageDescriptor main, ImageDescriptor ... decorators) {
        return new N4JSDecoratorRow(main, 1, (List)Conversions.doWrapArray((Object)decorators));
    }

    private Optional<Severity> getMaxSeverityAtOrBelow(EObject eo, CancelIndicator cancelIndicator) {
        if (!this.isN4Resource(eo.eResource()) || !ImageDescriptionHelper.isCompletelyLoaded((N4JSResource)eo.eResource())) {
            return Optional.empty();
        }
        IssueSummary summary = this.getOrElseUpdateSummary(eo, cancelIndicator);
        return summary.getMaxSeverityAtOrBelow(eo);
    }

    private IssueSummary getOrElseUpdateSummary(EObject eo, CancelIndicator cancelIndicator) {
        Resource res = eo.eResource();
        Provider _function = () -> {
            List issues = this.resourceValidator.validate(res, CheckMode.ALL, cancelIndicator);
            if (issues == null || cancelIndicator.isCanceled()) {
                return IssueSummary.EMPTY_SUMMARY;
            }
            return IssueSummary.create(issues);
        };
        IssueSummary summary = (IssueSummary)this.cache.get((Object)"ImageDescriptionHelper-IssueSummary", res, _function);
        return summary;
    }

    private static boolean isCompletelyLoaded(N4JSResource res) {
        Script scr;
        Script _script = null;
        if (res != null) {
            _script = res.getScript();
        }
        return (scr = _script) != null && !scr.eIsProxy();
    }

    private boolean isN4Resource(Resource res) {
        boolean _contains;
        Set _fileExtensions = this.fileExtensionProvider.getFileExtensions();
        URI _uRI = null;
        if (res != null) {
            _uRI = res.getURI();
        }
        String _fileExtension = null;
        if (_uRI != null) {
            _fileExtension = _uRI.fileExtension();
        }
        if (_contains = _fileExtensions.contains(_fileExtension)) {
            return res instanceof N4JSResource;
        }
        return false;
    }

    public ImageDescriptor addAccessibiltyImageDecorator(ImageDescriptor main, TypeAccessModifier typeAccessModifier) {
        ImageDescriptor _switchResult = null;
        if (typeAccessModifier != null) {
            switch (typeAccessModifier) {
                case PUBLIC: {
                    _switchResult = main;
                    break;
                }
                default: {
                    ImageDescriptor _xblockexpression = null;
                    ImageDescriptor _switchResult_1 = null;
                    if (typeAccessModifier != null) {
                        switch (typeAccessModifier) {
                            case PUBLIC_INTERNAL: {
                                _switchResult_1 = this.n4jsImageDescriptionLibrary.createPublicInternalVisibleImageDecorator();
                                break;
                            }
                            case PROJECT: {
                                _switchResult_1 = this.n4jsImageDescriptionLibrary.createProjectVisibleImageDecorator();
                                break;
                            }
                            case PRIVATE: {
                                _switchResult_1 = this.n4jsImageDescriptionLibrary.createPrivateVisibleImageDecorator();
                                break;
                            }
                            default: {
                                _switchResult_1 = this.n4jsImageDescriptionLibrary.createProjectVisibleImageDecorator();
                                break;
                            }
                        }
                    } else {
                        _switchResult_1 = this.n4jsImageDescriptionLibrary.createProjectVisibleImageDecorator();
                    }
                    ImageDescriptor decorator = _switchResult_1;
                    _switchResult = _xblockexpression = this.createDecorationOverlayIcon(main, decorator, 3);
                    break;
                }
            }
        } else {
            ImageDescriptor _xblockexpression = null;
            ImageDescriptor _switchResult_1 = null;
            if (typeAccessModifier != null) {
                switch (typeAccessModifier) {
                    case PUBLIC_INTERNAL: {
                        _switchResult_1 = this.n4jsImageDescriptionLibrary.createPublicInternalVisibleImageDecorator();
                        break;
                    }
                    case PROJECT: {
                        _switchResult_1 = this.n4jsImageDescriptionLibrary.createProjectVisibleImageDecorator();
                        break;
                    }
                    case PRIVATE: {
                        _switchResult_1 = this.n4jsImageDescriptionLibrary.createPrivateVisibleImageDecorator();
                        break;
                    }
                    default: {
                        _switchResult_1 = this.n4jsImageDescriptionLibrary.createProjectVisibleImageDecorator();
                        break;
                    }
                }
            } else {
                _switchResult_1 = this.n4jsImageDescriptionLibrary.createProjectVisibleImageDecorator();
            }
            ImageDescriptor decorator = _switchResult_1;
            _switchResult = _xblockexpression = this.createDecorationOverlayIcon(main, decorator, 3);
        }
        return _switchResult;
    }

    public ImageDescriptor createSimpleImageDescriptor(String imageFileName) {
        ImageDescriptor _xifexpression = null;
        if (imageFileName != null) {
            ImageDescriptor _orElse;
            ImageDescriptor _xblockexpression = null;
            ImageDescriptor existingImageDescriptor = this.labelProvider.asImageDescriptor(imageFileName);
            ImageDescriptor _elvis = null;
            _elvis = existingImageDescriptor != null ? existingImageDescriptor : (_orElse = (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)PLUGIN_ID, (String)("icons/" + imageFileName)).orElse(null));
            _xifexpression = _xblockexpression = _elvis;
        } else {
            _xifexpression = N4JSLabelProvider.getDefaultImageDescriptor();
        }
        return _xifexpression;
    }

    public static final class IssueSummary {
        public static final IssueSummary EMPTY_SUMMARY = new IssueSummary(null, null);
        private final String[] errors;
        private final String[] warnings;
        private static final char FORWARD_SLASH = '/';

        public static IssueSummary create(List<Issue> issues) {
            if (issues == null || issues.isEmpty()) {
                return EMPTY_SUMMARY;
            }
            Set<String> errors = IssueSummary.deduplicated(issues, Severity.ERROR);
            Set<String> warnings = IssueSummary.deduplicated(issues, Severity.WARNING);
            warnings.removeAll(errors);
            if (errors.isEmpty() && warnings.isEmpty()) {
                return EMPTY_SUMMARY;
            }
            String[] _asCondensedArray = IssueSummary.asCondensedArray(errors);
            String[] _asCondensedArray_1 = IssueSummary.asCondensedArray(warnings);
            return new IssueSummary(_asCondensedArray, _asCondensedArray_1);
        }

        private static Set<String> deduplicated(List<Issue> issues, Severity severityOfInterest) {
            Functions.Function1 _function = i -> i.getSeverity() == severityOfInterest && i.getUriToProblem() != null;
            Iterable chosenIssues = IterableExtensions.filter(issues, (Functions.Function1)_function);
            Functions.Function1 _function_1 = i -> IssueSummary.minusBody(i.getUriToProblem().toString());
            Iterable collapsed = IterableExtensions.map((Iterable)chosenIssues, (Functions.Function1)_function_1);
            return IterableExtensions.toSet((Iterable)collapsed);
        }

        private static String minusBody(String uri) {
            int idx = uri.lastIndexOf("/@body");
            if (idx != -1) {
                return uri.substring(0, idx);
            }
            return uri;
        }

        private static String[] asCondensedArray(Set<String> uris) {
            boolean _isEmpty = uris.isEmpty();
            if (_isEmpty) {
                return null;
            }
            String[] result = new String[uris.size()];
            Procedures.Procedure2 _function = (uri, idx) -> {
                stringArray[idx.intValue()] = uri;
            };
            IterableExtensions.forEach(uris, (Procedures.Procedure2)_function);
            return result;
        }

        public IssueSummary(String[] errors, String[] warnings) {
            this.errors = errors;
            this.warnings = warnings;
        }

        private boolean isEmpty() {
            return this.errors == null && this.warnings == null;
        }

        private Optional<Severity> getMaxSeverityAtOrBelow(EObject eo) {
            boolean _isEmpty = this.isEmpty();
            if (_isEmpty) {
                return Optional.empty();
            }
            EObject _xifexpression = null;
            _xifexpression = eo instanceof SyntaxRelatedTElement ? ((SyntaxRelatedTElement)eo).getAstElement() : eo;
            EObject astElem = _xifexpression;
            if (astElem == null) {
                return Optional.empty();
            }
            URI uri = EcoreUtil2.getURI((EObject)astElem);
            String currentURI = uri.toString();
            boolean _enclosesAnyOf = this.enclosesAnyOf(currentURI, this.errors);
            if (_enclosesAnyOf) {
                return Optional.of(Severity.ERROR);
            }
            boolean _enclosesAnyOf_1 = this.enclosesAnyOf(currentURI, this.warnings);
            if (_enclosesAnyOf_1) {
                return Optional.of(Severity.WARNING);
            }
            return Optional.empty();
        }

        private boolean enclosesAnyOf(String candidate, String[] problems) {
            if (problems != null) {
                int idx = 0;
                while (idx < problems.length) {
                    String problem = problems[idx];
                    boolean _startsWith = problem.startsWith(candidate);
                    if (_startsWith) {
                        boolean _tripleEquals_1;
                        boolean _tripleEquals;
                        int clen = candidate.length();
                        int _length = problem.length();
                        boolean bl = _tripleEquals = _length == clen;
                        if (_tripleEquals) {
                            return true;
                        }
                        char _charAt = problem.charAt(clen);
                        boolean bl2 = _tripleEquals_1 = _charAt == '/';
                        if (_tripleEquals_1) {
                            return true;
                        }
                    }
                    ++idx;
                }
            }
            return false;
        }
    }
}

