/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.proposals.imports;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.MembersInjector;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.n4js.n4JS.DefaultImportSpecifier;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.N4JSFactory;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.resource.AccessibleSerializer;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ui.organize.imports.ImportsRegionHelper;
import org.eclipse.n4js.ui.proposals.imports.AliasLocation;
import org.eclipse.n4js.ui.proposals.imports.AliasLocationAwareBuffer;
import org.eclipse.n4js.ui.proposals.imports.NameAndAlias;
import org.eclipse.n4js.ui.utils.ImportSpacerUserPreferenceHelper;
import org.eclipse.n4js.utils.Lazy;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.util.Strings;

public class ImportRewriter {
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IValueConverterService valueConverters;
    @Inject
    private N4JSGrammarAccess grammarAccess;
    @Inject
    private AccessibleSerializer serializer;
    @Inject
    private ImportSpacerUserPreferenceHelper spacerPreference;
    @Inject
    private ImportsRegionHelper importsRegionHelper;
    private final String lineDelimiter;
    private final Script script;
    private final Set<NameAndAlias> requestedImports;
    private final List<ImportDeclaration> existingImports;
    private final Lazy<String> lazySpacer;

    private ImportRewriter(IDocument document, Resource resource) {
        this.lineDelimiter = document instanceof IDocumentExtension4 ? ((IDocumentExtension4)document).getDefaultLineDelimiter() : Strings.newLine();
        this.script = (Script)resource.getContents().get(0);
        this.existingImports = Lists.newArrayList();
        for (ScriptElement element : this.script.getScriptElements()) {
            if (!(element instanceof ImportDeclaration)) continue;
            this.existingImports.add((ImportDeclaration)element);
        }
        this.requestedImports = Sets.newLinkedHashSet();
        this.lazySpacer = new Lazy(() -> this.spacerPreference.getSpacingPreference(resource));
    }

    public void addImport(QualifiedName qualifiedName) {
        this.requestedImports.add(new NameAndAlias(qualifiedName, null));
    }

    public void addImport(QualifiedName qualifiedName, String alias) {
        this.requestedImports.add(new NameAndAlias(qualifiedName, alias));
    }

    public void addSingleImport(QualifiedName qualifiedName, MultiTextEdit result) {
        this.toTextEdit(qualifiedName, null, this.findInsertionOffset(), result);
    }

    public AliasLocation addSingleImport(QualifiedName qualifiedName, String alias, MultiTextEdit result) {
        return this.toTextEdit(qualifiedName, alias, this.findInsertionOffset(), result);
    }

    public void toTextEdits(MultiTextEdit result) {
        int insertionOffset = this.findInsertionOffset();
        for (NameAndAlias requested : this.requestedImports) {
            this.toTextEdit(requested.getName(), requested.getAlias(), insertionOffset, result);
        }
    }

    private AliasLocation toTextEdit(QualifiedName qualifiedName, String optionalAlias, int insertionOffset, MultiTextEdit result) {
        QualifiedName moduleName = qualifiedName.skipLast(1);
        return this.addNewImportDeclaration(moduleName, qualifiedName, optionalAlias, insertionOffset, result);
    }

    private String unquoted(String syntacticModuleName) {
        if (syntacticModuleName == null || syntacticModuleName.length() < 2) {
            return syntacticModuleName;
        }
        if (syntacticModuleName.charAt(0) == '\"' && syntacticModuleName.charAt(syntacticModuleName.length() - 1) == '\"') {
            return syntacticModuleName.substring(1, syntacticModuleName.length() - 1);
        }
        return syntacticModuleName;
    }

    private AliasLocation addNewImportDeclaration(QualifiedName moduleName, QualifiedName qualifiedName, String optionalAlias, int insertionOffset, MultiTextEdit result) {
        String spacer = (String)this.lazySpacer.get();
        String syntacticModuleName = this.syntacticModuleName(moduleName);
        AliasLocation aliasLocation = null;
        String importSpec = String.valueOf(insertionOffset != 0 ? this.lineDelimiter : "") + "import ";
        if (!N4JSLanguageUtils.isDefaultExport((QualifiedName)qualifiedName)) {
            importSpec = String.valueOf(importSpec) + "{" + spacer + qualifiedName.getLastSegment();
            if (optionalAlias != null) {
                importSpec = String.valueOf(importSpec) + " as ";
                aliasLocation = new AliasLocation(insertionOffset, importSpec.length(), optionalAlias);
                importSpec = String.valueOf(importSpec) + optionalAlias;
            }
            importSpec = String.valueOf(importSpec) + spacer + "}";
        } else if (optionalAlias == null) {
            importSpec = String.valueOf(importSpec) + N4JSLanguageUtils.lastSegmentOrDefaultHost((QualifiedName)qualifiedName);
        } else {
            aliasLocation = new AliasLocation(insertionOffset, importSpec.length(), optionalAlias);
            importSpec = String.valueOf(importSpec) + optionalAlias;
        }
        result.addChild((TextEdit)new InsertEdit(insertionOffset, String.valueOf(importSpec) + " from " + syntacticModuleName + ";" + (insertionOffset != 0 ? "" : this.lineDelimiter)));
        return aliasLocation;
    }

    private String syntacticModuleName(QualifiedName moduleName) {
        String syntacticModuleName = this.valueConverters.toString((Object)this.qualifiedNameConverter.toString(moduleName), this.grammarAccess.getModuleSpecifierRule().getName());
        return syntacticModuleName;
    }

    private AliasLocation enhanceExistingImportDeclaration(ImportDeclaration importDeclaration, QualifiedName qualifiedName, String optionalAlias, MultiTextEdit result) {
        this.addImportSpecifier(importDeclaration, qualifiedName, optionalAlias);
        ICompositeNode replaceMe = NodeModelUtils.getNode((EObject)importDeclaration);
        int offset = replaceMe.getOffset();
        AliasLocationAwareBuffer observableBuffer = new AliasLocationAwareBuffer(optionalAlias, offset, this.grammarAccess);
        try {
            this.serializer.serialize((EObject)importDeclaration, (ITokenStream)observableBuffer, SaveOptions.newBuilder().noValidation().getOptions());
        }
        catch (IOException e) {
            throw new RuntimeException("Should never happen since we write into memory", e);
        }
        result.addChild((TextEdit)new ReplaceEdit(offset, replaceMe.getLength(), observableBuffer.toString()));
        return observableBuffer.getAliasLocation();
    }

    private void addImportSpecifier(ImportDeclaration importDeclaration, QualifiedName qualifiedName, String optionalAlias) {
        boolean isDefaultExport = N4JSLanguageUtils.isDefaultExport((QualifiedName)qualifiedName);
        DefaultImportSpecifier specifier = null;
        specifier = isDefaultExport ? N4JSFactory.eINSTANCE.createDefaultImportSpecifier() : N4JSFactory.eINSTANCE.createNamedImportSpecifier();
        Iterable topLevelTypes = Iterables.concat((Iterable)importDeclaration.getModule().getTopLevelTypes(), (Iterable)importDeclaration.getModule().getVariables());
        for (TExportableElement t : topLevelTypes) {
            if (!t.getExportedName().equals(qualifiedName.getLastSegment())) continue;
            specifier.setImportedElement(t);
            specifier.setAlias(optionalAlias);
            if (optionalAlias != null || !isDefaultExport) break;
            specifier.setAlias(qualifiedName.getSegment(qualifiedName.getSegmentCount() - 2));
            break;
        }
        if (isDefaultExport) {
            importDeclaration.getImportSpecifiers().add(0, (Object)specifier);
        } else {
            importDeclaration.getImportSpecifiers().add((Object)specifier);
        }
    }

    private int findInsertionOffset() {
        int result = 0;
        EList scriptElements = this.script.getScriptElements();
        int i = 0;
        int size = scriptElements.size();
        while (i < size) {
            ScriptElement element = (ScriptElement)scriptElements.get(i);
            if (!(element instanceof ImportDeclaration)) break;
            ICompositeNode importNode = NodeModelUtils.findActualNodeFor((EObject)element);
            if (importNode != null) {
                result = importNode.getTotalOffset() + this.getLengthWithoutAutomaticSemicolon((INode)importNode);
            }
            ++i;
        }
        if (result != 0) {
            return result;
        }
        return this.importsRegionHelper.getImportOffset(this.script);
    }

    private int getLengthWithoutAutomaticSemicolon(INode node) {
        if (node instanceof ILeafNode) {
            return node.getLength();
        }
        int length = 0;
        for (INode leafNode : ((ICompositeNode)node).getLeafNodes()) {
            if (UtilN4.isIgnoredSyntaxErrorNode((INode)leafNode, (String[])new String[]{"InternalSemicolonInjectingParser.ASI"})) continue;
            length += leafNode.getLength();
        }
        return length;
    }

    public static class Factory {
        @Inject
        private MembersInjector<ImportRewriter> injector;

        public ImportRewriter create(IDocument document, Resource resource) {
            ImportRewriter result = new ImportRewriter(document, resource);
            this.injector.injectMembers((Object)result);
            return result;
        }
    }
}

