/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.doctools;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.eclipse.n4js.doctools.EclipseHelpTOCGenerator;

public class IndexTocGenerator
extends EclipseHelpTOCGenerator {
    public static void main(String[] args) {
        if (args.length % 2 != 1) {
            IndexTocGenerator.printHelp();
            System.exit(1);
        }
        String in = null;
        String tocName = "toc.xml";
        String linkPrefix = "";
        int f = 0;
        while (f < args.length - 1) {
            String flag = args[f];
            String value = args[f + 1];
            switch (flag) {
                case "-t": {
                    tocName = value;
                    break;
                }
                case "-p": {
                    linkPrefix = value;
                    break;
                }
                default: {
                    System.out.println("Flag " + flag + " not recognized.");
                    IndexTocGenerator.printHelp();
                    System.exit(2);
                }
            }
            f += 2;
        }
        in = args[args.length - 1];
        File f2 = new File(in);
        try {
            IndexTocGenerator handler = new IndexTocGenerator();
            String toc = handler.generateTOC(f2, linkPrefix);
            Files.write(Paths.get(tocName, new String[0]), toc.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(2);
        }
        System.exit(0);
    }

    private static void printHelp() {
        System.out.println("etoc [-t tocfilename] [p link prefix] inputfile\n-t string   The tocfile to create (incl. xml). Existing file will be overwritten. Default is 'toc.html'\n-p path     Path to prepend to all links in the tocfile. Default is empty string.");
    }

    IndexTocGenerator() {
    }

    @Override
    public String computeBasedir(File file, String linkPrefix) {
        return String.valueOf(linkPrefix) + ".";
    }

    @Override
    protected String getResult() {
        StringBuilder out = new StringBuilder();
        out.append("<ol>\n");
        for (EclipseHelpTOCGenerator.Topic topic : this.maintopics) {
            this.appendTopic(out, "\t", topic, this.getFilename(topic.label));
        }
        if (!this.appendix.isEmpty()) {
            out.append("<li>Appendix\n<ol>\n");
            char appendixNo = 'A';
            for (EclipseHelpTOCGenerator.Topic topic : this.appendix) {
                this.appendTopic(out, "\t", topic, this.getFilename("Appendix " + appendixNo + ": " + topic.label));
                appendixNo = (char)(appendixNo + '\u0001');
            }
            out.append("</ol></li>\n");
        }
        out.append("\n</ol>");
        return out.toString();
    }

    @Override
    protected void appendTopic(StringBuilder out, String indent, EclipseHelpTOCGenerator.Topic topic, String fileName) {
        out.append("\n" + indent);
        String href = String.valueOf(this.dir) + "/" + fileName + "#" + topic.id;
        out.append("<li><a href=\"" + href + "\">" + topic.label + "</a>");
        if (!topic.subtopics.isEmpty()) {
            out.append("\n" + indent);
        }
        out.append("</li>");
    }
}

