/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.registry;

import com.google.inject.Provider;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xpect.registry.IEmfFileExtensionInfo;
import org.eclipse.xpect.registry.ILanguageInfo;
import org.eclipse.xpect.registry.LazyClass;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public class FileExtensionRegistrar {
    public static void register(IEmfFileExtensionInfo info) {
        ResourceFactoryDescr rf = new ResourceFactoryDescr(info);
        ServiceProvider spp = info instanceof IEmfFileExtensionInfo.IXtextFileExtensionInfo ? new ServiceProvider((IEmfFileExtensionInfo.IXtextFileExtensionInfo)info) : null;
        for (String ext : info.getFileExtensions()) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(ext, rf);
            if (spp == null) continue;
            IResourceServiceProvider.Registry.INSTANCE.getExtensionToFactoryMap().put(ext, spp);
        }
    }

    protected static abstract class AbstractDesrc<T extends IEmfFileExtensionInfo> {
        protected final T info;

        public AbstractDesrc(T info) {
            this.info = info;
        }

        public T getInfo() {
            return this.info;
        }

        protected <X> X newInstance(LazyClass<X> clazz) {
            Class<X> loaded = clazz.load();
            if (this.info instanceof IEmfFileExtensionInfo.IXtextFileExtensionInfo) {
                IEmfFileExtensionInfo.IXtextFileExtensionInfo xtextInfo = (IEmfFileExtensionInfo.IXtextFileExtensionInfo)this.info;
                ILanguageInfo languageInfo = ILanguageInfo.Registry.INSTANCE.getLanguageByName(xtextInfo.getLanguageID());
                return (X)languageInfo.getInjector().getInstance(loaded);
            }
            try {
                return loaded.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static class ResourceFactoryDescr
    extends AbstractDesrc<IEmfFileExtensionInfo>
    implements Resource.Factory.Descriptor {
        private Resource.Factory factory;

        public ResourceFactoryDescr(IEmfFileExtensionInfo info) {
            super(info);
        }

        public Resource.Factory createFactory() {
            if (this.factory == null) {
                this.factory = this.newInstance(this.info.getResourceFactory());
            }
            return this.factory;
        }
    }

    protected static class ServiceProvider
    extends AbstractDesrc<IEmfFileExtensionInfo.IXtextFileExtensionInfo>
    implements Provider<IResourceServiceProvider> {
        private IResourceServiceProvider provider;

        public ServiceProvider(IEmfFileExtensionInfo.IXtextFileExtensionInfo info) {
            super(info);
        }

        public IResourceServiceProvider get() {
            if (this.provider == null) {
                this.provider = this.newInstance(((IEmfFileExtensionInfo.IXtextFileExtensionInfo)this.info).getResourceServiceProvider());
            }
            return this.provider;
        }
    }
}

