/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.ColoringParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolCapabilities;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.ExecuteCommandCapabilities;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameCapabilities;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SemanticHighlightingServerCapabilities;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethodProvider;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageClientExtensions;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.eclipse.n4js.ide.server.HeadlessExtensionRegistrationHelper;
import org.eclipse.n4js.ide.xtext.server.BufferedCancelIndicator;
import org.eclipse.n4js.ide.xtext.server.IssueAcceptor;
import org.eclipse.n4js.ide.xtext.server.XBuildManager;
import org.eclipse.n4js.ide.xtext.server.XDocument;
import org.eclipse.n4js.ide.xtext.server.XProjectManager;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;
import org.eclipse.n4js.ide.xtext.server.build.XIndexState;
import org.eclipse.n4js.ide.xtext.server.concurrent.XRequestManager;
import org.eclipse.n4js.ide.xtext.server.contentassist.XContentAssistService;
import org.eclipse.n4js.ide.xtext.server.findReferences.XWorkspaceResourceAccess;
import org.eclipse.n4js.ide.xtext.server.rename.XIRenameService;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ICapabilitiesContributor;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.ILanguageServerExtension;
import org.eclipse.xtext.ide.server.ILanguageServerShutdownAndExitHandler;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;
import org.eclipse.xtext.ide.server.codelens.ICodeLensResolver;
import org.eclipse.xtext.ide.server.codelens.ICodeLensService;
import org.eclipse.xtext.ide.server.coloring.IColoringService;
import org.eclipse.xtext.ide.server.commands.ExecutableCommandRegistry;
import org.eclipse.xtext.ide.server.formatting.FormattingService;
import org.eclipse.xtext.ide.server.hover.IHoverService;
import org.eclipse.xtext.ide.server.occurrences.IDocumentHighlightService;
import org.eclipse.xtext.ide.server.rename.IRenameService;
import org.eclipse.xtext.ide.server.rename.IRenameService2;
import org.eclipse.xtext.ide.server.semanticHighlight.SemanticHighlightingRegistry;
import org.eclipse.xtext.ide.server.signatureHelp.ISignatureHelpService;
import org.eclipse.xtext.ide.server.symbol.DocumentSymbolService;
import org.eclipse.xtext.ide.server.symbol.HierarchicalDocumentSymbolService;
import org.eclipse.xtext.ide.server.symbol.IDocumentSymbolService;
import org.eclipse.xtext.ide.server.symbol.WorkspaceSymbolService;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class XLanguageServerImpl
implements LanguageServer,
WorkspaceService,
TextDocumentService,
LanguageClientAware,
Endpoint,
JsonRpcMethodProvider,
ILanguageServerAccess.IBuildListener {
    private static final Logger LOG = Logger.getLogger(XLanguageServerImpl.class);
    @Inject
    private XRequestManager requestManager;
    @Inject
    private WorkspaceSymbolService workspaceSymbolService;
    @Inject
    private UriExtensions uriExtensions;
    @Inject
    private IResourceServiceProvider.Registry languagesRegistry;
    @Inject
    private ExecutableCommandRegistry commandRegistry;
    @Inject
    private SemanticHighlightingRegistry semanticHighlightingRegistry;
    @Inject
    private ILanguageServerShutdownAndExitHandler shutdownAndExitHandler;
    @Inject
    private IssueAcceptor issueAcceptor;
    private XWorkspaceManager workspaceManager;
    private InitializeParams initializeParams;
    private InitializeResult initializeResult;
    private final CompletableFuture<InitializedParams> clientInitialized = new CompletableFuture();
    private XWorkspaceResourceAccess resourceAccess;
    private LanguageClient client;
    private Map<String, JsonRpcMethod> supportedMethods = null;
    private final Multimap<String, Endpoint> extensionProviders = LinkedListMultimap.create();
    private final ILanguageServerAccess access = new ILanguageServerAccess(){

        public <T> CompletableFuture<T> doRead(String uriStr, Function<ILanguageServerAccess.Context, T> function) {
            URI uri = XLanguageServerImpl.this.uriExtensions.toUri(uriStr);
            XtextResource res = XLanguageServerImpl.this.workspaceManager.getResource(uri);
            XDocument doc = XLanguageServerImpl.this.workspaceManager.getDocument(res);
            return XLanguageServerImpl.this.requestManager.runRead("doRead", cancelIndicator -> function.apply(new ILanguageServerAccess.Context((Resource)res, (Document)doc, XLanguageServerImpl.this.workspaceManager.isDocumentOpen(res.getURI()), cancelIndicator)));
        }

        public void addBuildListener(ILanguageServerAccess.IBuildListener listener) {
            XLanguageServerImpl.this.workspaceManager.addBuildListener(listener);
        }

        public LanguageClient getLanguageClient() {
            return XLanguageServerImpl.this.client;
        }

        public ResourceSet newLiveScopeResourceSet(URI uri) {
            XProjectManager projectManager = XLanguageServerImpl.this.workspaceManager.getProjectManager(uri);
            XIndexState indexState = projectManager.getProjectStateHolder().getIndexState();
            XtextResourceSet resourceSet = projectManager.createNewResourceSet(indexState.getResourceDescriptions());
            resourceSet.getLoadOptions().put("org.eclipse.xtext.scoping.LIVE_SCOPE", true);
            return resourceSet;
        }

        public InitializeParams getInitializeParams() {
            return XLanguageServerImpl.this.initializeParams;
        }

        public <T> CompletableFuture<T> doReadIndex(Function<? super ILanguageServerAccess.IndexContext, ? extends T> function) {
            return XLanguageServerImpl.this.requestManager.runRead("doReadIndex", cancelIndicator -> function.apply(new ILanguageServerAccess.IndexContext(XLanguageServerImpl.this.workspaceManager.getIndex(), cancelIndicator)));
        }

        public InitializeResult getInitializeResult() {
            return XLanguageServerImpl.this.initializeResult;
        }
    };

    @Inject
    public void registerExtensions(HeadlessExtensionRegistrationHelper helper) {
        helper.unregisterExtensions();
        helper.registerExtensions();
    }

    @Inject
    public void setWorkspaceManager(XWorkspaceManager manager) {
        this.workspaceManager = manager;
        this.resourceAccess = new XWorkspaceResourceAccess(this.workspaceManager);
    }

    private Set<? extends IResourceServiceProvider> getAllLanguages() {
        TreeMap<String, IResourceServiceProvider> sorted = new TreeMap<String, IResourceServiceProvider>();
        for (String ext : this.languagesRegistry.getExtensionToFactoryMap().keySet()) {
            sorted.put(ext, this.languagesRegistry.getResourceServiceProvider(URI.createURI((String)("synth:///file." + ext))));
        }
        return ImmutableSet.copyOf(sorted.values());
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        if (this.initializeParams != null) {
            throw new IllegalStateException("This language server has already been initialized.");
        }
        URI baseDir = this.getBaseDir(params);
        if (this.languagesRegistry.getExtensionToFactoryMap().isEmpty()) {
            throw new IllegalStateException("No Xtext languages have been registered. Please make sure you have added the languages's setup class in '/META-INF/services/org.eclipse.xtext.ISetup'");
        }
        this.initializeParams = params;
        this.access.addBuildListener((ILanguageServerAccess.IBuildListener)this);
        Stopwatch sw = Stopwatch.createStarted();
        LOG.info((Object)("Start server initialization in workspace directory " + baseDir));
        this.workspaceManager.initialize(baseDir);
        this.workspaceManager.refreshWorkspaceConfig();
        LOG.info((Object)("Server initialization done after " + sw));
        this.initializeResult = new InitializeResult();
        this.initializeResult.setCapabilities(this.createServerCapabilities(params));
        return CompletableFuture.completedFuture(this.initializeResult);
    }

    protected ServerCapabilities createServerCapabilities(InitializeParams params) {
        boolean clientPrepareSupport;
        boolean supportsCodeActions;
        ServerCapabilities serverCapabilities = new ServerCapabilities();
        serverCapabilities.setHoverProvider(Boolean.valueOf(true));
        serverCapabilities.setDefinitionProvider(Boolean.valueOf(true));
        serverCapabilities.setReferencesProvider(Boolean.valueOf(true));
        serverCapabilities.setDocumentSymbolProvider(Boolean.valueOf(true));
        serverCapabilities.setWorkspaceSymbolProvider(Boolean.valueOf(true));
        Set<? extends IResourceServiceProvider> allLanguages = this.getAllLanguages();
        if (allLanguages.stream().anyMatch(serviceProvider -> serviceProvider.get(ICodeLensService.class) != null)) {
            CodeLensOptions codeLensOptions = new CodeLensOptions();
            codeLensOptions.setResolveProvider(allLanguages.stream().anyMatch(serviceProvider -> serviceProvider.get(ICodeLensResolver.class) != null));
            serverCapabilities.setCodeLensProvider(codeLensOptions);
        }
        if (supportsCodeActions = allLanguages.stream().anyMatch(serviceProvider -> serviceProvider.get(ICodeActionService.class) != null || serviceProvider.get(ICodeActionService2.class) != null)) {
            Optional<List<String>> supportedKinds = this.getSupportedCodeActionKinds();
            if (supportedKinds.isPresent()) {
                serverCapabilities.setCodeActionProvider(new CodeActionOptions((List)supportedKinds.get()));
            } else {
                serverCapabilities.setCodeActionProvider(Boolean.valueOf(true));
            }
        } else {
            serverCapabilities.setCodeActionProvider(Boolean.valueOf(false));
        }
        serverCapabilities.setSignatureHelpProvider(new SignatureHelpOptions((List)ImmutableList.of((Object)"(", (Object)",")));
        serverCapabilities.setTextDocumentSync(TextDocumentSyncKind.Incremental);
        CompletionOptions completionOptions = new CompletionOptions();
        completionOptions.setResolveProvider(Boolean.valueOf(false));
        completionOptions.setTriggerCharacters((List)ImmutableList.of((Object)"."));
        serverCapabilities.setCompletionProvider(completionOptions);
        serverCapabilities.setDocumentFormattingProvider(Boolean.valueOf(true));
        serverCapabilities.setDocumentRangeFormattingProvider(Boolean.valueOf(true));
        serverCapabilities.setDocumentHighlightProvider(Boolean.valueOf(true));
        ClientCapabilities clientCapabilities = null;
        if (params != null) {
            clientCapabilities = params.getCapabilities();
        }
        TextDocumentClientCapabilities textDocument = null;
        if (clientCapabilities != null) {
            textDocument = clientCapabilities.getTextDocument();
        }
        RenameCapabilities rename = null;
        if (textDocument != null) {
            rename = textDocument.getRename();
        }
        Boolean prepareSupport = null;
        if (rename != null) {
            prepareSupport = rename.getPrepareSupport();
        }
        if ((clientPrepareSupport = Objects.equal((Object)Boolean.TRUE, (Object)prepareSupport)) && allLanguages.stream().anyMatch(serviceProvider -> serviceProvider.get(IRenameService2.class) != null)) {
            RenameOptions renameOptions = new RenameOptions();
            renameOptions.setPrepareProvider(Boolean.valueOf(true));
            serverCapabilities.setRenameProvider(Either.forRight((Object)renameOptions));
        } else {
            serverCapabilities.setRenameProvider(Either.forLeft((Object)allLanguages.stream().anyMatch(serviceProvider -> serviceProvider.get(IRenameService.class) != null || serviceProvider.get(IRenameService2.class) != null)));
        }
        WorkspaceClientCapabilities workspace = null;
        if (clientCapabilities != null) {
            workspace = clientCapabilities.getWorkspace();
        }
        ExecuteCommandCapabilities executeCommand = null;
        if (workspace != null) {
            executeCommand = workspace.getExecuteCommand();
        }
        if (executeCommand != null) {
            this.commandRegistry.initialize(allLanguages, clientCapabilities, this.client);
            ExecuteCommandOptions executeCommandOptions = new ExecuteCommandOptions();
            executeCommandOptions.setCommands(this.commandRegistry.getCommands());
            serverCapabilities.setExecuteCommandProvider(executeCommandOptions);
        }
        this.semanticHighlightingRegistry.initialize(allLanguages, clientCapabilities, this.client);
        serverCapabilities.setSemanticHighlighting(new SemanticHighlightingServerCapabilities(this.semanticHighlightingRegistry.getAllScopes()));
        for (IResourceServiceProvider iResourceServiceProvider : allLanguages) {
            ICapabilitiesContributor capabilitiesContributor = (ICapabilitiesContributor)iResourceServiceProvider.get(ICapabilitiesContributor.class);
            if (capabilitiesContributor == null) continue;
            capabilitiesContributor.contribute(serverCapabilities, params);
        }
        return serverCapabilities;
    }

    protected Optional<List<String>> getSupportedCodeActionKinds() {
        return Optional.absent();
    }

    public void initialized(InitializedParams params) {
        this.requestManager.runWrite("initialized", () -> this.initialBuild(), (cancelIndicator, it) -> it);
        this.clientInitialized.complete(params);
    }

    private Void initialBuild() {
        Stopwatch sw = Stopwatch.createStarted();
        try {
            try {
                LOG.info((Object)"Start initial build ...");
                this.workspaceManager.doInitialBuild(CancelIndicator.NullImpl);
            }
            catch (Throwable t) {
                LOG.error((Object)t.getMessage(), t);
                throw t;
            }
        }
        finally {
            LOG.info((Object)("Initial build done after " + sw));
        }
        return null;
    }

    @Deprecated
    private URI deprecatedToBaseDir(InitializeParams params) {
        String rootPath = params.getRootPath();
        if (rootPath != null) {
            return this.uriExtensions.toUri(this.uriExtensions.toUriString(URI.createFileURI((String)rootPath)));
        }
        return null;
    }

    protected URI getBaseDir(InitializeParams params) {
        String rootUri = params.getRootUri();
        if (rootUri != null) {
            return this.uriExtensions.toUri(rootUri);
        }
        return this.deprecatedToBaseDir(params);
    }

    public void connect(LanguageClient client) {
        this.client = client;
        this.issueAcceptor.connect(client);
    }

    public void disconnect() {
        this.issueAcceptor.disconnect();
        this.client = null;
    }

    public void exit() {
        LOG.info((Object)"Received exit notification");
        this.joinJobs();
        this.shutdownAndExitHandler.exit();
    }

    public CompletableFuture<Object> shutdown() {
        LOG.info((Object)"Start shutdown");
        this.disconnect();
        return this.runBuildable("shutdown", () -> {
            XBuildManager.XBuildable buildable = this.workspaceManager.closeAll();
            return cancelIndicator -> {
                List<IResourceDescription.Delta> result = buildable.build(cancelIndicator);
                this.workspaceManager.persistProjectState(CancelIndicator.NullImpl);
                this.shutdownAndExitHandler.shutdown();
                LOG.info((Object)"Shutdown done");
                return result;
            };
        }).thenApply(any -> new Object());
    }

    public TextDocumentService getTextDocumentService() {
        return this;
    }

    public WorkspaceService getWorkspaceService() {
        return this;
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        this.runBuildable("didOpen", () -> this.toBuildable(params));
    }

    protected XBuildManager.XBuildable toBuildable(DidOpenTextDocumentParams params) {
        TextDocumentItem textDocument = params.getTextDocument();
        return this.workspaceManager.didOpen(this.getURI(textDocument), textDocument.getVersion(), textDocument.getText());
    }

    public void didChange(DidChangeTextDocumentParams params) {
        if (this.isSourceFileOrOpen(this.uriExtensions.toUri(params.getTextDocument().getUri()))) {
            this.runBuildable("didChange", () -> this.toBuildable(params));
        }
    }

    private boolean isSourceFileOrOpen(URI uri) {
        if (this.workspaceManager.isDocumentOpen(uri)) {
            return true;
        }
        return this.isSourceFile(uri);
    }

    private boolean isSourceFile(URI uri) {
        ISourceFolder sourceFolder;
        IProjectConfig projectConfig = this.workspaceManager.getWorkspaceConfig().findProjectContaining(uri);
        return projectConfig != null && (sourceFolder = projectConfig.findSourceFolderContaining(uri)) != null;
    }

    protected XBuildManager.XBuildable toBuildable(DidChangeTextDocumentParams params) {
        VersionedTextDocumentIdentifier textDocument = params.getTextDocument();
        return this.workspaceManager.didChangeTextDocumentContent(this.getURI((TextDocumentIdentifier)textDocument), textDocument.getVersion(), params.getContentChanges());
    }

    public void didClose(DidCloseTextDocumentParams params) {
        this.runBuildable("didClose", () -> this.toBuildable(params));
    }

    protected XBuildManager.XBuildable toBuildable(DidCloseTextDocumentParams params) {
        return this.workspaceManager.didClose(this.getURI(params.getTextDocument()));
    }

    public void didSave(DidSaveTextDocumentParams params) {
        this.runBuildable("didSave", () -> this.toBuildable(params));
    }

    protected XBuildManager.XBuildable toBuildable(DidSaveTextDocumentParams params) {
        return this.workspaceManager.didSave(this.getURI(params.getTextDocument()));
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        ArrayList<URI> dirtyFiles = new ArrayList<URI>();
        ArrayList<URI> deletedFiles = new ArrayList<URI>();
        for (FileEvent fileEvent : params.getChanges()) {
            boolean skipFile;
            URI uri = this.uriExtensions.toUri(fileEvent.getUri());
            String fileName = uri.lastSegment();
            boolean bl = skipFile = fileName.equals(".n4js.projectstate") || this.workspaceManager.isDocumentOpen(uri);
            if (skipFile || !this.isSourceFile(uri)) continue;
            FileChangeType changeType = fileEvent.getType();
            if (changeType == FileChangeType.Deleted) {
                deletedFiles.add(uri);
                continue;
            }
            dirtyFiles.add(uri);
        }
        if (!dirtyFiles.isEmpty() || !deletedFiles.isEmpty()) {
            this.runBuildable("didChangeWatchedFiles", () -> this.workspaceManager.didChangeFiles(dirtyFiles, deletedFiles));
        }
    }

    public CompletableFuture<Void> clean() {
        return this.requestManager.runWrite("clean", () -> {
            this.workspaceManager.clean(CancelIndicator.NullImpl);
            return null;
        }, (a, b) -> null);
    }

    protected CompletableFuture<List<IResourceDescription.Delta>> runBuildable(String description, Supplier<? extends XBuildManager.XBuildable> newBuildable) {
        return this.requestManager.runWrite(description, newBuildable::get, (cancelIndicator, buildable) -> buildable.build((CancelIndicator)cancelIndicator));
    }

    private void joinJobs() {
        this.runBuildable("joinJobs", () -> cancelIndicator -> Collections.emptyList());
    }

    public CompletableFuture<Void> reinitWorkspace() {
        return this.requestManager.runWrite("didChangeConfiguration", () -> {
            this.workspaceManager.refreshWorkspaceConfig();
            this.workspaceManager.doInitialBuild(CancelIndicator.NullImpl);
            return null;
        }, (a, b) -> null);
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.reinitWorkspace();
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        return this.requestManager.runRead("completion", cancelIndicator -> this.completion((CancelIndicator)cancelIndicator, params));
    }

    protected Either<List<CompletionItem>, CompletionList> completion(CancelIndicator originalCancelIndicator, CompletionParams params) {
        URI uri = this.getURI((TextDocumentPositionParams)params);
        XContentAssistService contentAssistService = this.getService(uri, XContentAssistService.class);
        if (contentAssistService == null) {
            return Either.forRight((Object)new CompletionList());
        }
        BufferedCancelIndicator cancelIndicator = new BufferedCancelIndicator(originalCancelIndicator, Duration.ofMillis(750L));
        XtextResource res = this.workspaceManager.getResource(uri);
        XDocument doc = this.workspaceManager.getDocument(res);
        return Either.forRight((Object)contentAssistService.createCompletionList(doc, res, (TextDocumentPositionParams)params, cancelIndicator));
    }

    protected URI getURI(TextDocumentPositionParams params) {
        return this.getURI(params.getTextDocument());
    }

    protected URI getURI(TextDocumentIdentifier documentIdentifier) {
        return this.uriExtensions.toUri(documentIdentifier.getUri());
    }

    protected URI getURI(TextDocumentItem documentItem) {
        return this.uriExtensions.toUri(documentItem.getUri());
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(TextDocumentPositionParams params) {
        return this.requestManager.runRead("definition", cancelIndicator -> this.definition(params, (CancelIndicator)cancelIndicator));
    }

    protected Either<List<? extends Location>, List<? extends LocationLink>> definition(TextDocumentPositionParams params, CancelIndicator cancelIndicator) {
        return Either.forLeft(this.definition(cancelIndicator, params));
    }

    protected List<? extends Location> definition(CancelIndicator cancelIndicator, TextDocumentPositionParams params) {
        URI uri = this.getURI(params);
        DocumentSymbolService documentSymbolService = this.getService(uri, DocumentSymbolService.class);
        if (documentSymbolService == null) {
            return Collections.emptyList();
        }
        XtextResource res = this.workspaceManager.getResource(uri);
        XDocument doc = this.workspaceManager.getDocument(res);
        return documentSymbolService.getDefinitions((Document)doc, res, params, (IReferenceFinder.IResourceAccess)this.resourceAccess, cancelIndicator);
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        return this.requestManager.runRead("references", cancelIndicator -> this.references(params, (CancelIndicator)cancelIndicator));
    }

    protected List<? extends Location> references(ReferenceParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI((TextDocumentPositionParams)params);
        DocumentSymbolService documentSymbolService = this.getService(uri, DocumentSymbolService.class);
        if (documentSymbolService == null) {
            return Collections.emptyList();
        }
        XtextResource res = this.workspaceManager.getResource(uri);
        XDocument doc = this.workspaceManager.getDocument(res);
        return documentSymbolService.getReferences((Document)doc, res, params, (IReferenceFinder.IResourceAccess)this.resourceAccess, this.workspaceManager.getIndex(), cancelIndicator);
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        return this.requestManager.runRead("documentSymbol", cancelIndicator -> this.documentSymbol(params, (CancelIndicator)cancelIndicator));
    }

    protected List<Either<SymbolInformation, DocumentSymbol>> documentSymbol(DocumentSymbolParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(params.getTextDocument());
        IDocumentSymbolService documentSymbolService = this.getIDocumentSymbolService(this.getResourceServiceProvider(uri));
        if (documentSymbolService == null) {
            return Collections.emptyList();
        }
        XtextResource res = this.workspaceManager.getResource(uri);
        XDocument doc = this.workspaceManager.getDocument(res);
        return documentSymbolService.getSymbols((Document)doc, res, params, cancelIndicator);
    }

    protected IDocumentSymbolService getIDocumentSymbolService(IResourceServiceProvider serviceProvider) {
        if (serviceProvider == null) {
            return null;
        }
        if (this.isHierarchicalDocumentSymbolSupport()) {
            return (IDocumentSymbolService)serviceProvider.get(HierarchicalDocumentSymbolService.class);
        }
        return (IDocumentSymbolService)serviceProvider.get(DocumentSymbolService.class);
    }

    protected boolean isHierarchicalDocumentSymbolSupport() {
        Boolean hierarchicalDocumentSymbolSupport;
        DocumentSymbolCapabilities documentSymbol;
        TextDocumentClientCapabilities textDocument;
        ClientCapabilities capabilities = this.initializeParams.getCapabilities();
        if (capabilities != null && (textDocument = capabilities.getTextDocument()) != null && (documentSymbol = textDocument.getDocumentSymbol()) != null && (hierarchicalDocumentSymbolSupport = documentSymbol.getHierarchicalDocumentSymbolSupport()) != null) {
            return hierarchicalDocumentSymbolSupport;
        }
        return false;
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        return this.requestManager.runRead("symbol", cancelIndicator -> this.symbol(params, (CancelIndicator)cancelIndicator));
    }

    protected List<? extends SymbolInformation> symbol(WorkspaceSymbolParams params, CancelIndicator cancelIndicator) {
        return this.workspaceSymbolService.getSymbols(params.getQuery(), (IReferenceFinder.IResourceAccess)this.resourceAccess, this.workspaceManager.getIndex(), cancelIndicator);
    }

    public CompletableFuture<Hover> hover(TextDocumentPositionParams params) {
        return this.requestManager.runRead("hover", cancelIndicator -> this.hover(params, (CancelIndicator)cancelIndicator));
    }

    protected Hover hover(TextDocumentPositionParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(params);
        IHoverService hoverService = this.getService(uri, IHoverService.class);
        if (hoverService == null) {
            return IHoverService.EMPTY_HOVER;
        }
        XtextResource res = this.workspaceManager.getResource(uri);
        XDocument doc = this.workspaceManager.getDocument(res);
        return hoverService.hover((Document)doc, res, params, cancelIndicator);
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<SignatureHelp> signatureHelp(TextDocumentPositionParams params) {
        return this.requestManager.runRead("signatureHelp", cancelIndicator -> this.signatureHelp(params, (CancelIndicator)cancelIndicator));
    }

    protected SignatureHelp signatureHelp(TextDocumentPositionParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(params);
        ISignatureHelpService helper = this.getService(uri, ISignatureHelpService.class);
        if (helper == null) {
            return ISignatureHelpService.EMPTY;
        }
        XtextResource res = this.workspaceManager.getResource(uri);
        XDocument doc = this.workspaceManager.getDocument(res);
        return helper.getSignatureHelp((Document)doc, res, params, cancelIndicator);
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(TextDocumentPositionParams params) {
        return this.requestManager.runRead("documentHighlight", cancelIndicator -> this.documentHighlight(params, (CancelIndicator)cancelIndicator));
    }

    protected List<? extends DocumentHighlight> documentHighlight(TextDocumentPositionParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(params);
        IDocumentHighlightService service = this.getService(uri, IDocumentHighlightService.class);
        if (service == null) {
            return Collections.emptyList();
        }
        XtextResource res = this.workspaceManager.getResource(uri);
        XDocument doc = this.workspaceManager.getDocument(res);
        return service.getDocumentHighlights((Document)doc, res, params, cancelIndicator);
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        return this.requestManager.runRead("codeAction", cancelIndicator -> this.codeAction(params, (CancelIndicator)cancelIndicator));
    }

    protected List<Either<Command, CodeAction>> codeAction(CodeActionParams params, CancelIndicator cancelIndicator) {
        ICodeActionService2.Options options;
        List actions;
        List actions2;
        URI uri = this.getURI(params.getTextDocument());
        IResourceServiceProvider serviceProvider = this.getResourceServiceProvider(uri);
        ICodeActionService service = this.getService(serviceProvider, ICodeActionService.class);
        ICodeActionService2 service2 = this.getService(serviceProvider, ICodeActionService2.class);
        if (service == null && service2 == null) {
            return Collections.emptyList();
        }
        XtextResource res = this.workspaceManager.getResource(uri);
        XDocument doc = this.workspaceManager.getDocument(res);
        ArrayList<Either<Command, CodeAction>> result = new ArrayList<Either<Command, CodeAction>>();
        if (service != null && (actions2 = service.getCodeActions((Document)doc, res, params, cancelIndicator)) != null) {
            result.addAll(actions2);
        }
        if (service2 != null && (actions = service2.getCodeActions(options = this.toOptions(params, doc, res, cancelIndicator))) != null) {
            result.addAll(actions);
        }
        return result;
    }

    public ICodeActionService2.Options toOptions(CodeActionParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(params.getTextDocument());
        XtextResource res = this.workspaceManager.getResource(uri);
        XDocument doc = this.workspaceManager.getDocument(res);
        return this.toOptions(params, doc, res, cancelIndicator);
    }

    public ICodeActionService2.Options toOptions(CodeActionParams params, XDocument doc, XtextResource res, CancelIndicator cancelIndicator) {
        ICodeActionService2.Options options = new ICodeActionService2.Options();
        options.setDocument((Document)doc);
        options.setResource(res);
        options.setLanguageServerAccess(this.access);
        options.setCodeActionParams(params);
        options.setCancelIndicator(cancelIndicator);
        return options;
    }

    protected void installURI(List<? extends CodeLens> codeLenses, String uri) {
        for (CodeLens codeLens : codeLenses) {
            Object data = codeLens.getData();
            if (data != null) {
                codeLens.setData(Arrays.asList(uri, codeLens.getData()));
                continue;
            }
            codeLens.setData((Object)uri);
        }
    }

    protected URI uninstallURI(CodeLens lens) {
        URI result = null;
        Object data = lens.getData();
        if (data instanceof String) {
            result = URI.createURI((String)data.toString());
            lens.setData(null);
        } else if (data instanceof List) {
            List l = (List)data;
            result = URI.createURI((String)l.get(0).toString());
            lens.setData(l.get(1));
        }
        return result;
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        return this.requestManager.runRead("codeLens", cancelIndicator -> this.codeLens(params, (CancelIndicator)cancelIndicator));
    }

    protected List<? extends CodeLens> codeLens(CodeLensParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(params.getTextDocument());
        ICodeLensService codeLensService = this.getService(uri, ICodeLensService.class);
        if (codeLensService == null) {
            return Collections.emptyList();
        }
        XtextResource res = this.workspaceManager.getResource(uri);
        XDocument doc = this.workspaceManager.getDocument(res);
        List result = codeLensService.computeCodeLenses((Document)doc, res, params, cancelIndicator);
        this.installURI(result, uri.toString());
        return result;
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        URI uri = this.uninstallURI(unresolved);
        if (uri == null) {
            return CompletableFuture.completedFuture(unresolved);
        }
        return this.requestManager.runRead("resolveCodeLens", cancelIndicator -> this.resolveCodeLens(uri, unresolved, (CancelIndicator)cancelIndicator));
    }

    protected CodeLens resolveCodeLens(URI uri, CodeLens unresolved, CancelIndicator cancelIndicator) {
        ICodeLensResolver resolver = this.getService(uri, ICodeLensResolver.class);
        if (resolver == null) {
            return unresolved;
        }
        XtextResource res = this.workspaceManager.getResource(uri);
        XDocument doc = this.workspaceManager.getDocument(res);
        return resolver.resolveCodeLens((Document)doc, res, unresolved, cancelIndicator);
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return this.requestManager.runRead("formatting", cancelIndicator -> this.formatting(params, (CancelIndicator)cancelIndicator));
    }

    protected List<? extends TextEdit> formatting(DocumentFormattingParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(params.getTextDocument());
        FormattingService formatterService = this.getService(uri, FormattingService.class);
        if (formatterService == null) {
            return Collections.emptyList();
        }
        XtextResource res = this.workspaceManager.getResource(uri);
        XDocument doc = this.workspaceManager.getDocument(res);
        return formatterService.format((Document)doc, res, params, cancelIndicator);
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        return this.requestManager.runRead("rangeFormatting", cancelIndicator -> this.rangeFormatting(params, (CancelIndicator)cancelIndicator));
    }

    protected List<? extends TextEdit> rangeFormatting(DocumentRangeFormattingParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(params.getTextDocument());
        FormattingService formatterService = this.getService(uri, FormattingService.class);
        if (formatterService == null) {
            return Collections.emptyList();
        }
        XtextResource res = this.workspaceManager.getResource(uri);
        XDocument doc = this.workspaceManager.getDocument(res);
        return formatterService.format((Document)doc, res, params, cancelIndicator);
    }

    protected <Service> Service getService(URI uri, Class<Service> type) {
        return this.getService(this.getResourceServiceProvider(uri), type);
    }

    protected <Service> Service getService(IResourceServiceProvider resourceServiceProvider, Class<Service> type) {
        if (resourceServiceProvider == null) {
            return null;
        }
        return (Service)resourceServiceProvider.get(type);
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        return this.requestManager.runRead("executeCommand", cancelIndicator -> this.executeCommand(params, (CancelIndicator)cancelIndicator));
    }

    protected Object executeCommand(ExecuteCommandParams params, CancelIndicator cancelIndicator) {
        return this.commandRegistry.executeCommand(params, this.access, cancelIndicator);
    }

    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams renameParams) {
        return this.requestManager.runRead("rename", cancelIndicator -> this.rename(renameParams, (CancelIndicator)cancelIndicator));
    }

    protected WorkspaceEdit rename(RenameParams renameParams, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(renameParams.getTextDocument());
        IResourceServiceProvider resourceServiceProvider = this.getResourceServiceProvider(uri);
        XIRenameService renameServiceOld = this.getService(resourceServiceProvider, XIRenameService.class);
        if (renameServiceOld != null) {
            return renameServiceOld.rename(this.workspaceManager, renameParams, cancelIndicator);
        }
        IRenameService2 renameService2 = this.getService(resourceServiceProvider, IRenameService2.class);
        if (renameService2 != null) {
            IRenameService2.Options options = new IRenameService2.Options();
            options.setLanguageServerAccess(this.access);
            options.setRenameParams(renameParams);
            options.setCancelIndicator(cancelIndicator);
            return renameService2.rename(options);
        }
        return new WorkspaceEdit();
    }

    protected IResourceServiceProvider getResourceServiceProvider(URI uri) {
        return this.languagesRegistry.getResourceServiceProvider(uri);
    }

    public CompletableFuture<Either<Range, PrepareRenameResult>> prepareRename(TextDocumentPositionParams params) {
        return this.requestManager.runRead("prepareRename", cancelIndicator -> this.prepareRename(params, (CancelIndicator)cancelIndicator));
    }

    protected Either<Range, PrepareRenameResult> prepareRename(TextDocumentPositionParams params, CancelIndicator cancelIndicator) {
        URI uri = this.getURI(params);
        IRenameService2 renameService = this.getService(uri, IRenameService2.class);
        if (renameService == null) {
            throw new UnsupportedOperationException();
        }
        IRenameService2.PrepareRenameOptions options = new IRenameService2.PrepareRenameOptions();
        options.setLanguageServerAccess(this.access);
        options.setParams(params);
        options.setCancelIndicator(cancelIndicator);
        return renameService.prepareRename(options);
    }

    public void notify(String method, Object parameter) {
        for (Endpoint endpoint : this.extensionProviders.get((Object)method)) {
            try {
                endpoint.notify(method, parameter);
            }
            catch (UnsupportedOperationException e) {
                if (e == ILanguageServerExtension.NOT_HANDLED_EXCEPTION) continue;
                throw e;
            }
        }
    }

    public CompletableFuture<?> request(String method, Object parameter) {
        if (!this.extensionProviders.containsKey((Object)method)) {
            throw new UnsupportedOperationException("The json request '" + method + "' is unknown.");
        }
        for (Endpoint endpoint : this.extensionProviders.get((Object)method)) {
            try {
                return endpoint.request(method, parameter);
            }
            catch (UnsupportedOperationException e) {
                if (e == ILanguageServerExtension.NOT_HANDLED_EXCEPTION) continue;
                throw e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, JsonRpcMethod> supportedMethods() {
        if (this.supportedMethods != null) {
            return this.supportedMethods;
        }
        Multimap<String, Endpoint> multimap = this.extensionProviders;
        synchronized (multimap) {
            LinkedHashMap<String, JsonRpcMethod> supportedMethods = new LinkedHashMap<String, JsonRpcMethod>();
            supportedMethods.putAll(ServiceEndpoints.getSupportedMethods(this.getClass()));
            LinkedHashMap<String, JsonRpcMethod> extensions = new LinkedHashMap<String, JsonRpcMethod>();
            for (IResourceServiceProvider iResourceServiceProvider : this.getAllLanguages()) {
                ILanguageServerExtension ext = (ILanguageServerExtension)iResourceServiceProvider.get(ILanguageServerExtension.class);
                if (ext == null) continue;
                ext.initialize(this.access);
                Map supportedExtensions = ext instanceof JsonRpcMethodProvider ? ((JsonRpcMethodProvider)ext).supportedMethods() : ServiceEndpoints.getSupportedMethods(ext.getClass());
                for (Map.Entry entry : supportedExtensions.entrySet()) {
                    if (supportedMethods.containsKey(entry.getKey())) {
                        LOG.error((Object)("The json rpc method '" + (String)entry.getKey() + "' can not be an extension as it is already defined in the LSP standard."));
                        continue;
                    }
                    JsonRpcMethod existing = extensions.put((String)entry.getKey(), (JsonRpcMethod)entry.getValue());
                    if (existing != null && !Objects.equal((Object)existing, entry.getValue())) {
                        LOG.error((Object)("An incompatible LSP extension '" + (String)entry.getKey() + "' has already been registered. Using 1 ignoring 2. \n1 : " + existing + " \n2 : " + entry.getValue()));
                        extensions.put((String)entry.getKey(), existing);
                        continue;
                    }
                    Endpoint endpoint = ServiceEndpoints.toEndpoint((Object)ext);
                    this.extensionProviders.put((Object)((String)entry.getKey()), (Object)endpoint);
                    supportedMethods.put((String)entry.getKey(), (JsonRpcMethod)entry.getValue());
                }
            }
            this.supportedMethods = supportedMethods;
            return supportedMethods;
        }
    }

    public void afterBuild(List<IResourceDescription.Delta> deltas) {
        for (IResourceDescription.Delta delta : deltas) {
            if (delta.getNew() == null || !this.workspaceManager.isDocumentOpen(delta.getUri())) continue;
            String uriStr = delta.getUri().toString();
            this.access.doRead(uriStr, ctx -> {
                if (ctx.isDocumentOpen() && ctx.getResource() instanceof XtextResource && this.client instanceof LanguageClientExtensions) {
                    Document doc;
                    List colInfos;
                    LanguageClientExtensions clientExtensions = (LanguageClientExtensions)this.client;
                    XtextResource resource = (XtextResource)ctx.getResource();
                    IResourceServiceProvider resourceServiceProvider = resource.getResourceServiceProvider();
                    IColoringService coloringService = (IColoringService)resourceServiceProvider.get(IColoringService.class);
                    if (coloringService != null && !IterableExtensions.isNullOrEmpty((Iterable)(colInfos = coloringService.getColoring(resource, doc = ctx.getDocument())))) {
                        String uri = resource.getURI().toString();
                        ColoringParams colParams = new ColoringParams(uri, colInfos);
                        clientExtensions.updateColoring(colParams);
                    }
                }
                this.semanticHighlightingRegistry.update(ctx);
                return null;
            });
        }
    }

    protected ILanguageServerAccess getLanguageServerAccess() {
        return this.access;
    }

    public LanguageClient getLanguageClient() {
        return this.client;
    }

    protected ExecutableCommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    protected Multimap<String, Endpoint> getExtensionProviders() {
        return ImmutableMultimap.copyOf(this.extensionProviders);
    }

    protected Map<String, JsonRpcMethod> getSupportedMethods() {
        return ImmutableMap.copyOf(this.supportedMethods);
    }

    protected IResourceServiceProvider.Registry getLanguagesRegistry() {
        return this.languagesRegistry;
    }

    protected IReferenceFinder.IResourceAccess getWorkspaceResourceAccess() {
        return this.resourceAccess;
    }

    protected XWorkspaceManager getWorkspaceManager() {
        return this.workspaceManager;
    }

    protected WorkspaceSymbolService getWorkspaceSymbolService() {
        return this.workspaceSymbolService;
    }

    public XRequestManager getRequestManager() {
        return this.requestManager;
    }

    public void joinClientInitialized() {
        this.clientInitialized.join();
    }

    public void joinServerRequests() {
        CompletableFuture<Void> future = this.getRequestManager().allRequests();
        future.join();
    }

    static /* synthetic */ XWorkspaceManager access$0(XLanguageServerImpl xLanguageServerImpl) {
        return xLanguageServerImpl.workspaceManager;
    }
}

