/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.labeling.helper;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ui.labeling.EObjectWithContext;
import org.eclipse.n4js.ui.labeling.N4JSLabelProvider;
import org.eclipse.n4js.ui.labeling.N4JSStylers;
import org.eclipse.n4js.ui.labeling.helper.LabelCalculationHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class StyledTextCalculationHelper {
    private static final int OUTLINE_TYPE_REF_LENGTH_THRESHOLD = 30;
    private N4JSLabelProvider labelProvider;
    @Inject
    private LabelCalculationHelper labelCalculationHelper;

    public N4JSLabelProvider setLabelProvider(N4JSLabelProvider provider) {
        this.labelProvider = provider;
        return this.labelProvider;
    }

    public N4JSLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    protected StyledString _dispatchGetStyledText(Void _null) {
        return new StyledString("*error*");
    }

    protected StyledString _dispatchGetStyledText(Object element) {
        return this.getLabelProvider().getSuperStyledText(element);
    }

    protected StyledString _dispatchGetStyledText(EObjectWithContext objectWithContext) {
        StyledString styledText = this.dispatchGetStyledText(objectWithContext.obj);
        if (styledText == null) {
            return this.unknown();
        }
        TMember _xifexpression = null;
        if (objectWithContext.obj instanceof N4MemberDeclaration) {
            _xifexpression = ((N4MemberDeclaration)objectWithContext.obj).getDefinedTypeElement();
        } else {
            TMember _xifexpression_1 = null;
            _xifexpression_1 = objectWithContext.obj instanceof TMember ? (TMember)objectWithContext.obj : null;
            _xifexpression = _xifexpression_1;
        }
        TMember member = _xifexpression;
        if (member != null && member.getContainingType() != null && !Objects.equal((Object)member.getContainingType(), (Object)objectWithContext.context)) {
            String _dispatchDoGetText = this.labelCalculationHelper.dispatchDoGetText(member.getContainingType());
            String orgDest = " from " + _dispatchDoGetText;
            boolean _isPolyfilled = member.isPolyfilled();
            if (_isPolyfilled) {
                styledText.append(" - polyfilled" + orgDest, N4JSStylers.POLYFILLED_MEMBERS_STYLER);
            } else if (member.getContainingType() instanceof TInterface && objectWithContext.context instanceof TClass) {
                styledText.append(" - consumed" + orgDest, N4JSStylers.CONSUMED_MEMBERS_STYLER);
            } else {
                styledText.append(" - inherited" + orgDest, N4JSStylers.INHERITED_MEMBERS_STYLER);
            }
        }
        return styledText;
    }

    protected StyledString _dispatchGetStyledText(FunctionDefinition functionDefinition) {
        StyledString _xblockexpression = null;
        Type definedType = functionDefinition.getDefinedType();
        if (definedType instanceof TFunction) {
            return this.dispatchGetStyledText(definedType);
        }
        _xblockexpression = this.getLabelProvider().getSuperStyledText(functionDefinition);
        return _xblockexpression;
    }

    protected StyledString _dispatchGetStyledText(TFunction tfunction) {
        boolean _not;
        StyledString styledText = this.getLabelProvider().getSuperStyledText(tfunction);
        if (styledText == null) {
            return this.unknown();
        }
        boolean _isConstructor = tfunction.isConstructor();
        if (_isConstructor) {
            styledText.setStyle(0, styledText.length(), N4JSStylers.CONSTRUCTOR_STYLER);
        }
        styledText = this.appendStyledTextForFormalParameters(styledText, tfunction);
        boolean _isEmpty = tfunction.getTypeVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Functions.Function1 _function = it -> it.getName();
            styledText.append(IterableExtensions.join((Iterable)tfunction.getTypeVars(), (CharSequence)"<", (CharSequence)", ", (CharSequence)">", (Functions.Function1)_function));
        }
        if (!tfunction.isConstructor() && tfunction.getReturnTypeRef() != null) {
            styledText.append(": ");
            styledText.append(this.getTypeRefDescription(tfunction.getReturnTypeRef()));
        }
        return styledText;
    }

    protected StyledString _dispatchGetStyledText(N4GetterDeclaration n4GetterDeclaration) {
        boolean _tripleNotEquals;
        TGetter _definedGetter = n4GetterDeclaration.getDefinedGetter();
        boolean bl = _tripleNotEquals = _definedGetter != null;
        if (_tripleNotEquals) {
            return this.dispatchGetStyledText(n4GetterDeclaration.getDefinedGetter());
        }
        return this.getLabelProvider().getSuperStyledText(n4GetterDeclaration);
    }

    protected StyledString _dispatchGetStyledText(TGetter tgetter) {
        TypeRef _declaredTypeRef;
        boolean _tripleNotEquals;
        StyledString styledText = this.getLabelProvider().getSuperStyledText(tgetter);
        if (styledText == null) {
            return this.unknown();
        }
        styledText.setStyle(0, styledText.length(), N4JSStylers.FIELD_OR_VAR_STYLER);
        boolean _isOptional = tgetter.isOptional();
        if (_isOptional) {
            styledText.append("?");
        }
        boolean bl = _tripleNotEquals = (_declaredTypeRef = tgetter.getDeclaredTypeRef()) != null;
        if (_tripleNotEquals) {
            styledText.append(": ");
            styledText.append(this.getTypeRefDescription(tgetter.getDeclaredTypeRef()));
        }
        return styledText;
    }

    protected StyledString _dispatchGetStyledText(N4SetterDeclaration n4SetterDeclaration) {
        boolean _tripleNotEquals;
        TSetter _definedSetter = n4SetterDeclaration.getDefinedSetter();
        boolean bl = _tripleNotEquals = _definedSetter != null;
        if (_tripleNotEquals) {
            return this.dispatchGetStyledText(n4SetterDeclaration.getDefinedSetter());
        }
        return this.getLabelProvider().getSuperStyledText(n4SetterDeclaration);
    }

    protected StyledString _dispatchGetStyledText(TSetter tsetter) {
        boolean _tripleNotEquals;
        StyledString _xblockexpression = null;
        StyledString styledText = this.getLabelProvider().getSuperStyledText(tsetter);
        if (styledText == null) {
            return this.unknown();
        }
        styledText.setStyle(0, styledText.length(), N4JSStylers.FIELD_OR_VAR_STYLER);
        boolean _isOptional = tsetter.isOptional();
        if (_isOptional) {
            styledText.append("?");
        }
        StyledString _xifexpression = null;
        TFormalParameter _fpar = tsetter.getFpar();
        boolean bl = _tripleNotEquals = _fpar != null;
        if (_tripleNotEquals) {
            _xifexpression = styledText.append(": ").append(this.getStyledTextForFormalParameter(tsetter.getFpar()));
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected StyledString _dispatchGetStyledText(N4FieldDeclaration n4FieldDeclaration) {
        boolean _tripleNotEquals;
        TField _definedField = n4FieldDeclaration.getDefinedField();
        boolean bl = _tripleNotEquals = _definedField != null;
        if (_tripleNotEquals) {
            return this.dispatchGetStyledText(n4FieldDeclaration.getDefinedField());
        }
        return this.getLabelProvider().getSuperStyledText(n4FieldDeclaration);
    }

    protected StyledString _dispatchGetStyledText(TField tfield) {
        TypeRef _typeRef;
        boolean _tripleNotEquals;
        StyledString styledText = this.getLabelProvider().getSuperStyledText(tfield);
        if (styledText == null) {
            return this.unknown();
        }
        styledText.setStyle(0, styledText.length(), N4JSStylers.FIELD_OR_VAR_STYLER);
        boolean _isOptional = tfield.isOptional();
        if (_isOptional) {
            styledText.append("?");
        }
        boolean bl = _tripleNotEquals = (_typeRef = tfield.getTypeRef()) != null;
        if (_tripleNotEquals) {
            styledText.append(": ");
            styledText.append(this.getTypeRefDescription(tfield.getTypeRef()));
        }
        return styledText;
    }

    protected StyledString _dispatchGetStyledText(ExportedVariableDeclaration variableDeclaration) {
        boolean _tripleNotEquals;
        StyledString styledText = this.getLabelProvider().getSuperStyledText(variableDeclaration);
        if (styledText == null) {
            return this.unknown();
        }
        styledText.setStyle(0, styledText.length(), N4JSStylers.FIELD_OR_VAR_STYLER);
        TVariable definedVariable = variableDeclaration.getDefinedVariable();
        TypeRef _typeRef = null;
        if (definedVariable != null) {
            _typeRef = definedVariable.getTypeRef();
        }
        boolean bl = _tripleNotEquals = _typeRef != null;
        if (_tripleNotEquals) {
            styledText.append(": ");
            styledText.append(this.getTypeRefDescription(definedVariable.getTypeRef()));
        }
        return styledText;
    }

    private StyledString appendStyledTextForFormalParameters(StyledString styledText, TFunction tFunction) {
        boolean _not;
        StyledString _xblockexpression = null;
        styledText.append("(");
        boolean _isEmpty = tFunction.getFpars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Functions.Function1 _function = it -> this.getStyledTextForFormalParameter((TFormalParameter)it);
            Functions.Function2 _function_1 = (l, r) -> {
                StyledString _xifexpression = null;
                if (l != null) {
                    _xifexpression = l.append(", ").append(r);
                } else {
                    StyledString _xifexpression_1 = null;
                    _xifexpression_1 = r != null ? r : new StyledString();
                    _xifexpression = _xifexpression_1;
                }
                return _xifexpression;
            };
            styledText.append((StyledString)IterableExtensions.reduce((Iterable)ListExtensions.map((List)tFunction.getFpars(), (Functions.Function1)_function), (Functions.Function2)_function_1));
        }
        _xblockexpression = styledText.append(")");
        return _xblockexpression;
    }

    private StyledString getStyledTextForFormalParameter(TFormalParameter tFormalParameter) {
        boolean _isHasInitializerAssignment;
        StyledString styledText = this.getTypeRefDescription(tFormalParameter.getTypeRef());
        boolean _isVariadic = tFormalParameter.isVariadic();
        if (_isVariadic) {
            styledText = new StyledString("\u2026").append(styledText);
        }
        if (_isHasInitializerAssignment = tFormalParameter.isHasInitializerAssignment()) {
            styledText.append("=");
        }
        return styledText;
    }

    private StyledString getTypeRefDescription(TypeRef ref) {
        String _compressedTypeRefDescription = this.getCompressedTypeRefDescription(ref, 0);
        StyledString typeRefDescription = new StyledString(_compressedTypeRefDescription, N4JSStylers.TYPEREF_STYLER);
        return typeRefDescription;
    }

    private String getCompressedTypeRefDescription(TypeRef typeRef, int currentLength) {
        if (currentLength > 30) {
            return "...";
        }
        if (typeRef != null) {
            return this.getTypeRefDescriptionString((TypeArgument)typeRef);
        }
        return "<unknown>";
    }

    private String _getTypeRefDescriptionString(TypeArgument ref) {
        String name = ref.getTypeRefAsString();
        if (name == null) {
            return "<unknown>";
        }
        return name;
    }

    private String _getTypeRefDescriptionString(TypeRef ref) {
        String name;
        Type _declaredType = ref.getDeclaredType();
        String _name = null;
        if (_declaredType != null) {
            _name = _declaredType.getName();
        }
        if ((name = _name) == null) {
            return "<unknown>";
        }
        return name;
    }

    private String _getTypeRefDescriptionString(ParameterizedTypeRef ref) {
        String name;
        Type _declaredType = ref.getDeclaredType();
        String _name = null;
        if (_declaredType != null) {
            _name = _declaredType.getName();
        }
        if ((name = _name) == null) {
            return "<unknown>";
        }
        if (ref.getTypingStrategy() != null && !Objects.equal((Object)ref.getTypingStrategy(), (Object)TypingStrategy.DEFAULT)) {
            String _plus;
            TypingStrategy _typingStrategy = ref.getTypingStrategy();
            name = _plus = _typingStrategy + name;
        }
        if (name.equals("Array") && ref.getDeclaredType().isArrayLike()) {
            String _plus_2;
            Functions.Function1 _function = arg -> this.getTypeRefDescriptionString((TypeArgument)arg);
            String _join = IterableExtensions.join((Iterable)ref.getTypeArgs(), (CharSequence)",", (Functions.Function1)_function);
            String _plus_1 = "[" + _join;
            name = _plus_2 = String.valueOf(_plus_1) + "]";
        } else {
            String _name_1 = name;
            Functions.Function1 _function_1 = arg -> this.getTypeRefDescriptionString((TypeArgument)arg);
            String _join_1 = IterableExtensions.join((Iterable)ref.getTypeArgs(), (CharSequence)"<", (CharSequence)",", (CharSequence)">", (Functions.Function1)_function_1);
            name = String.valueOf(_name_1) + _join_1;
        }
        return name;
    }

    private String _getTypeRefDescriptionString(ThisTypeRef ref) {
        if (ref.getTypingStrategy() != null && !Objects.equal((Object)ref.getTypingStrategy(), (Object)TypingStrategy.DEFAULT)) {
            TypingStrategy _typingStrategy = ref.getTypingStrategy();
            return _typingStrategy + "this";
        }
        return "this";
    }

    private String _getTypeRefDescriptionString(FunctionTypeExpression ref) {
        boolean _tripleNotEquals;
        StringBuilder result = new StringBuilder();
        result.append("(");
        StyledString parameterString = new StyledString();
        Functions.Function1 _function = it -> it.getTypeRef();
        this.appendCommaSeparatedTypeRefList(ListExtensions.map((List)ref.getFpars(), (Functions.Function1)_function), parameterString, true, ", ");
        result.append((CharSequence)parameterString).toString();
        result.append(")=>");
        TypeRef _returnTypeRef = ref.getReturnTypeRef();
        boolean bl = _tripleNotEquals = _returnTypeRef != null;
        if (_tripleNotEquals) {
            result.append(this.getCompressedTypeRefDescription(ref.getReturnTypeRef(), 0));
        } else {
            result.append("void");
        }
        return result.toString();
    }

    private String _getTypeRefDescriptionString(TypeTypeRef ref) {
        String _switchResult = null;
        TypeArgument _typeArg = ref.getTypeArg();
        boolean _matched = false;
        if (_typeArg instanceof ThisTypeRef) {
            _matched = true;
            _switchResult = "this";
        }
        if (!_matched) {
            _switchResult = this.nominalTypeNameOrWildCard(ref);
        }
        String typeName = _switchResult;
        boolean _isConstructorRef = ref.isConstructorRef();
        if (_isConstructorRef) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("constructor{");
            _builder.append(typeName);
            _builder.append("}");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("type{");
        _builder_1.append(typeName);
        _builder_1.append("}");
        return _builder_1.toString();
    }

    private String _getTypeRefDescriptionString(ComposedTypeRef ref) {
        boolean needsParens;
        StyledString result = new StyledString();
        EStructuralFeature cf = ref.eContainingFeature();
        boolean bl = needsParens = ref.eContainer() instanceof ComposedTypeRef || (Objects.equal((Object)cf, (Object)TypesPackage.Literals.TFUNCTION__RETURN_TYPE_REF) || Objects.equal((Object)cf, (Object)TypeRefsPackage.Literals.FUNCTION_TYPE_EXPR_OR_REF___GET_RETURN_TYPE_REF) || Objects.equal((Object)cf, (Object)TypeRefsPackage.Literals.FUNCTION_TYPE_EXPRESSION__RETURN_TYPE_REF)) && ref.eContainer().eContainer() instanceof ComposedTypeRef;
        if (needsParens) {
            result.append("(");
        }
        String _xifexpression = null;
        _xifexpression = ref instanceof UnionTypeExpression ? " | " : " & ";
        String separator = _xifexpression;
        this.appendCommaSeparatedTypeRefList((Iterable<TypeRef>)ref.getTypeRefs(), result, true, separator);
        if (needsParens) {
            result.append(")");
        }
        return result.toString();
    }

    private void appendCommaSeparatedTypeRefList(Iterable<TypeRef> refs, StyledString styledString, boolean first, String separator) {
        boolean _greaterThan;
        boolean _not;
        boolean _hasNext = refs.iterator().hasNext();
        boolean bl = _not = !_hasNext;
        if (_not) {
            return;
        }
        int _length = styledString.length();
        boolean bl2 = _greaterThan = 30 > _length;
        if (_greaterThan) {
            if (!first) {
                styledString.append(separator);
            }
            styledString.append(this.getCompressedTypeRefDescription(refs.iterator().next(), styledString.length()));
            this.appendCommaSeparatedTypeRefList(IterableExtensions.drop(refs, (int)1), styledString, false, separator);
        } else if (!first) {
            styledString.append(String.valueOf(separator) + "\u2026");
        } else {
            styledString.append("\u2026");
        }
    }

    private String getWildcardDescription(Wildcard wildcard) {
        boolean _tripleNotEquals;
        StyledString string = new StyledString();
        string.append("?");
        TypeRef _declaredLowerBound = wildcard.getDeclaredLowerBound();
        boolean bl = _tripleNotEquals = _declaredLowerBound != null;
        if (_tripleNotEquals) {
            string.append(" super ");
            string.append(this.getCompressedTypeRefDescription(wildcard.getDeclaredLowerBound(), string.length()));
        } else {
            string.append(" extends ");
            string.append(this.getCompressedTypeRefDescription(wildcard.getDeclaredUpperBound(), string.length()));
        }
        return string.getString();
    }

    private String nominalTypeNameOrWildCard(TypeTypeRef ref) {
        TypeArgument _typeArg_1;
        String _switchResult = null;
        TypeArgument _typeArg = ref.getTypeArg();
        boolean _matched = false;
        if (_typeArg instanceof TypeRef) {
            _matched = true;
            _typeArg_1 = ref.getTypeArg();
            Type _declaredType = ((TypeRef)_typeArg_1).getDeclaredType();
            String _name = null;
            if (_declaredType != null) {
                _name = _declaredType.getName();
            }
            _switchResult = _name;
        }
        if (!_matched && _typeArg instanceof Wildcard) {
            _matched = true;
            _typeArg_1 = ref.getTypeArg();
            _switchResult = this.getWildcardDescription((Wildcard)_typeArg_1);
        }
        if (!_matched) {
            _switchResult = "";
        }
        return _switchResult;
    }

    private StyledString unknown() {
        return new StyledString("<unknown>");
    }

    public StyledString dispatchGetStyledText(Object tfunction) {
        if (tfunction instanceof TFunction) {
            return this._dispatchGetStyledText((TFunction)tfunction);
        }
        if (tfunction instanceof TGetter) {
            return this._dispatchGetStyledText((TGetter)tfunction);
        }
        if (tfunction instanceof TSetter) {
            return this._dispatchGetStyledText((TSetter)tfunction);
        }
        if (tfunction instanceof ExportedVariableDeclaration) {
            return this._dispatchGetStyledText((ExportedVariableDeclaration)tfunction);
        }
        if (tfunction instanceof N4GetterDeclaration) {
            return this._dispatchGetStyledText((N4GetterDeclaration)tfunction);
        }
        if (tfunction instanceof N4SetterDeclaration) {
            return this._dispatchGetStyledText((N4SetterDeclaration)tfunction);
        }
        if (tfunction instanceof TField) {
            return this._dispatchGetStyledText((TField)tfunction);
        }
        if (tfunction instanceof N4FieldDeclaration) {
            return this._dispatchGetStyledText((N4FieldDeclaration)tfunction);
        }
        if (tfunction instanceof FunctionDefinition) {
            return this._dispatchGetStyledText((FunctionDefinition)tfunction);
        }
        if (tfunction == null) {
            return this._dispatchGetStyledText((Void)null);
        }
        if (tfunction instanceof EObjectWithContext) {
            return this._dispatchGetStyledText((EObjectWithContext)tfunction);
        }
        if (tfunction != null) {
            return this._dispatchGetStyledText(tfunction);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(tfunction).toString());
    }

    private String getTypeRefDescriptionString(TypeArgument ref) {
        if (ref instanceof FunctionTypeExpression) {
            return this._getTypeRefDescriptionString((FunctionTypeExpression)ref);
        }
        if (ref instanceof ParameterizedTypeRef) {
            return this._getTypeRefDescriptionString((ParameterizedTypeRef)ref);
        }
        if (ref instanceof ThisTypeRef) {
            return this._getTypeRefDescriptionString((ThisTypeRef)ref);
        }
        if (ref instanceof TypeTypeRef) {
            return this._getTypeRefDescriptionString((TypeTypeRef)ref);
        }
        if (ref instanceof ComposedTypeRef) {
            return this._getTypeRefDescriptionString((ComposedTypeRef)ref);
        }
        if (ref instanceof TypeRef) {
            return this._getTypeRefDescriptionString((TypeRef)ref);
        }
        if (ref != null) {
            return this._getTypeRefDescriptionString(ref);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ref).toString());
    }
}

