/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.xcore2java;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xtext.ISetup;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.containers.IAllContainersState;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;

public class XcoreReader
extends AbstractWorkflowComponent2 {
    private static final String XCORE_FILE_EXT = "xcore";
    private static final Logger LOGGER = Logger.getLogger(XcoreReader.class);
    private final List<String> pathes = Lists.newArrayList();
    private String slot;
    private final List<Injector> injectors = Lists.newArrayList();

    public void addPath(String path) {
        this.pathes.add(path);
    }

    public List<String> getPathes() {
        return this.pathes;
    }

    public String getSlot() {
        return this.slot;
    }

    public void setSlot(String slot) {
        this.slot = slot;
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        ResourceSet resourceSet = this.getResourceSet();
        IAllContainersState allContainerState = (IAllContainersState)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), IAllContainersState.class);
        allContainerState.isEmpty("");
        Multimap uris = this.getPathTraverser().resolvePathes(this.pathes, (Predicate)new Predicate<URI>(){

            public boolean apply(URI input) {
                return input.fileExtension().equals(XcoreReader.XCORE_FILE_EXT);
            }
        });
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (URI uri : uris.values()) {
            LOGGER.info((Object)uri);
            try {
                resources.add(this.parse(uri, resourceSet));
            }
            catch (Exception e) {
                LOGGER.error((Object)("Problem during loading of resource @ " + uri), (Throwable)e);
            }
        }
        this.installIndex(resourceSet);
        for (Resource r : resources) {
            EcoreUtil.resolveAll((Resource)r);
            for (Resource.Diagnostic x : r.getErrors()) {
                issues.addError(x.getMessage(), (Object)x);
            }
        }
        ctx.set(this.slot, resources);
    }

    private void installIndex(ResourceSet resourceSet) {
        ResourceDescriptionsData index = new ResourceDescriptionsData((Iterable)Lists.newArrayList());
        ArrayList resources = Lists.newArrayList((Iterable)resourceSet.getResources());
        for (Resource resource : resources) {
            this.index(resource, resource.getURI(), index);
        }
        ResourceDescriptionsData.ResourceSetAdapter.installResourceDescriptionsData((ResourceSet)resourceSet, (ResourceDescriptionsData)index);
    }

    private void index(Resource resource, URI uri, ResourceDescriptionsData index) {
        IResourceDescription resourceDescription;
        IResourceServiceProvider serviceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(uri);
        if (serviceProvider != null && (resourceDescription = serviceProvider.getResourceDescriptionManager().getResourceDescription(resource)) != null) {
            index.addDescription(uri, resourceDescription);
        }
    }

    private Resource parse(URI uriToUse, ResourceSet resourceSet) {
        return resourceSet.getResource(uriToUse, true);
    }

    private PathTraverser getPathTraverser() {
        return new PathTraverser();
    }

    private ResourceSet getResourceSet() {
        if (!this.injectors.isEmpty()) {
            ResourceSet instance = (ResourceSet)this.injectors.get(0).getInstance(ResourceSet.class);
            return instance;
        }
        return new ResourceSetImpl();
    }

    public void addRegister(ISetup setup) {
        this.injectors.add(setup.createInjectorAndDoEMFRegistration());
    }
}

