/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.text;

import com.google.common.base.Strings;
import org.eclipse.xpect.util.IDifferencer;

public class StringEndsSimilarityFunction
implements IDifferencer.ISimilarityFunction<String> {
    private final float TRESHOLD;

    public StringEndsSimilarityFunction(float treshold) {
        this.TRESHOLD = treshold;
    }

    public StringEndsSimilarityFunction() {
        this(0.4f);
    }

    @Override
    public float similarity(String s1, String s2) {
        int maxChars;
        if (Strings.isNullOrEmpty((String)s1) || Strings.isNullOrEmpty((String)s2)) {
            return 1.0f;
        }
        if (s1.equals(s2)) {
            return 0.0f;
        }
        int minChars = Math.min(s1.length(), s2.length());
        if ((float)(minChars / (maxChars = Math.max(s1.length(), s2.length()))) < this.TRESHOLD) {
            return 1.0f;
        }
        int charsInCommon = 0;
        int i = 0;
        while (i < minChars) {
            if (s1.charAt(i) != s2.charAt(i)) break;
            ++charsInCommon;
            ++i;
        }
        minChars -= charsInCommon;
        i = 1;
        while (i <= minChars) {
            if (s1.charAt(s1.length() - i) != s2.charAt(s2.length() - i)) break;
            ++charsInCommon;
            ++i;
        }
        if (charsInCommon == 0) {
            return 1.0f;
        }
        float ratio = 1.0f - (float)charsInCommon / (float)maxChars;
        return Math.min(ratio * (1.0f / this.TRESHOLD), 1.0f);
    }
}

