/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

public abstract class JavaLaunchTab
extends AbstractLaunchConfigurationTab {
    private ILaunchConfiguration fLaunchConfig;

    protected IJavaElement getContext() {
        IWorkbenchPage page = JDIDebugUIPlugin.getActivePage();
        if (page != null) {
            IEditorPart part;
            IStructuredSelection ss;
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
                Object obj = ss.getFirstElement();
                if (obj instanceof IJavaElement) {
                    return (IJavaElement)obj;
                }
                if (obj instanceof IResource) {
                    IJavaElement je = JavaCore.create((IResource)((IResource)obj));
                    if (je == null) {
                        IProject pro = ((IResource)obj).getProject();
                        je = JavaCore.create((IProject)pro);
                    }
                    if (je != null) {
                        return je;
                    }
                }
            }
            if ((part = page.getActiveEditor()) != null) {
                IEditorInput input = part.getEditorInput();
                return (IJavaElement)input.getAdapter(IJavaElement.class);
            }
        }
        return null;
    }

    protected ILaunchConfiguration getCurrentLaunchConfiguration() {
        return this.fLaunchConfig;
    }

    private void setCurrentLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfig = config;
    }

    protected void initializeJavaProject(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        IJavaProject javaProject = javaElement.getJavaProject();
        String name = null;
        if (javaProject != null && javaProject.exists()) {
            name = javaProject.getElementName();
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, name);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setCurrentLaunchConfiguration(config);
    }

    protected void initializeAttributes() {
        this.getAttributesLabelsForPrototype().put(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, LauncherMessages.JavaLauncherTab_AttributeLabel_ProjectName);
    }
}

