/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal.lsp;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.lsp.N4JSSourceFolder;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.lsp.IN4JSSourceFolder;
import org.eclipse.xtext.util.IFileSystemScanner;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;

public class N4JSProjectConfig
implements IProjectConfig {
    private final IWorkspaceConfig workspace;
    private final IN4JSProject delegate;

    public N4JSProjectConfig(IWorkspaceConfig workspace, IN4JSProject delegate) {
        this.workspace = workspace;
        this.delegate = delegate;
    }

    public String getName() {
        return this.delegate.getProjectName().getRawName();
    }

    public IN4JSProject toProject() {
        return this.delegate;
    }

    public URI getPath() {
        return ((SafeURI)this.delegate.getLocation().withTrailingPathDelimiter()).toURI();
    }

    public Set<? extends IN4JSSourceFolder> getSourceFolders() {
        LinkedHashSet<SourceContainerForPackageJson> sourceFolders = new LinkedHashSet<SourceContainerForPackageJson>();
        this.delegate.getSourceContainers().forEach(container -> {
            boolean bl = sourceFolders.add((SourceContainerForPackageJson)((Object)new N4JSSourceFolder(this, (IN4JSSourceContainer)container)));
        });
        sourceFolders.add(new SourceContainerForPackageJson());
        return sourceFolders;
    }

    public IN4JSSourceFolder findSourceFolderContaining(URI member) {
        IN4JSSourceContainer sourceContainer = this.delegate.findSourceContainerWith(member);
        if (sourceContainer == null) {
            SourceContainerForPackageJson pckJsonSrcContainer = new SourceContainerForPackageJson();
            if (pckJsonSrcContainer.contains(member)) {
                return pckJsonSrcContainer;
            }
            return null;
        }
        return new N4JSSourceFolder(this, sourceContainer);
    }

    public List<URI> getOutputFolders() {
        return Collections.singletonList(((SafeURI)this.delegate.getLocation().appendPath(this.delegate.getOutputPath())).toURI());
    }

    public IWorkspaceConfig getWorkspaceConfig() {
        return this.workspace;
    }

    public boolean indexOnly() {
        String outputPath = this.delegate.getOutputPath();
        if (".".equals(outputPath)) {
            return true;
        }
        URI projectBase = this.getPath();
        String lastSegment = projectBase.lastSegment();
        if (lastSegment == null || lastSegment.isBlank()) {
            projectBase = projectBase.trimSegments(1);
        }
        if ((lastSegment = (projectBase = projectBase.trimSegments(1)).lastSegment()) != null && lastSegment.startsWith("@")) {
            projectBase = projectBase.trimSegments(1);
            lastSegment = projectBase.lastSegment();
        }
        return lastSegment != null && "node_modules".equals(lastSegment);
    }

    public boolean canClean() {
        return !this.indexOnly();
    }

    private class SourceContainerForPackageJson
    implements IN4JSSourceFolder {
        private final URI pckjsonURI;

        SourceContainerForPackageJson() {
            this.pckjsonURI = ((SafeURI)N4JSProjectConfig.this.delegate.getLocation().appendSegment("package.json")).toURI();
        }

        public String getName() {
            return "package.json";
        }

        public List<URI> getAllResources(IFileSystemScanner scanner) {
            return Collections.singletonList(this.pckjsonURI);
        }

        @Override
        public IProjectConfig getProject() {
            return N4JSProjectConfig.this;
        }

        public boolean contains(URI uri) {
            return this.pckjsonURI.equals(uri);
        }

        public URI getPath() {
            return N4JSProjectConfig.this.delegate.getLocation().toURI();
        }
    }
}

