/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.imports;

import java.util.Objects;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.naming.QualifiedName;

public class ImportDescriptor
implements Comparable<ImportDescriptor> {
    private final boolean isNamed;
    private final boolean isNamespace;
    private final boolean isDefault;
    private final String elementName;
    private final String alias;
    private final String moduleSpecifier;
    private final QualifiedName moduleFQN;
    private final int originalIndex;

    private ImportDescriptor(boolean isNamed, boolean isNamespace, boolean isDefault, String elementName, String alias, String moduleSpecifier, QualifiedName moduleFQN, int originalIndex) {
        if (isDefault && !isNamed) {
            throw new IllegalArgumentException("default imports must be named imports");
        }
        if (elementName != null && !isNamed) {
            throw new IllegalArgumentException("elementName may only be non-null for named imports");
        }
        Objects.requireNonNull(moduleSpecifier);
        Objects.requireNonNull(moduleFQN);
        this.isNamed = isNamed;
        this.isNamespace = isNamespace;
        this.isDefault = isDefault;
        this.elementName = isDefault ? "default" : elementName;
        this.alias = alias;
        this.moduleSpecifier = moduleSpecifier;
        this.moduleFQN = moduleFQN;
        this.originalIndex = originalIndex;
    }

    public static ImportDescriptor createBareImport(String moduleSpecifier, String targetProjectName, QualifiedName targetModule, int originalIndex) {
        boolean isNamed = false;
        boolean isNamespace = false;
        boolean isDefault = false;
        String elementName = null;
        String alias = null;
        QualifiedName moduleFQN = ImportDescriptor.getFQN(targetProjectName, targetModule);
        return new ImportDescriptor(isNamed, isNamespace, isDefault, elementName, alias, moduleSpecifier, moduleFQN, originalIndex);
    }

    public static ImportDescriptor createNamedImport(String elementName, String alias, String moduleSpecifier, String targetProjectName, QualifiedName targetModule, int originalIndex) {
        boolean isNamed = true;
        boolean isNamespace = false;
        boolean isDefault = false;
        QualifiedName moduleFQN = ImportDescriptor.getFQN(targetProjectName, targetModule);
        return new ImportDescriptor(isNamed, isNamespace, isDefault, elementName, alias, moduleSpecifier, moduleFQN, originalIndex);
    }

    public static ImportDescriptor createDefaultImport(String localName, String moduleSpecifier, String targetProjectName, QualifiedName targetModule, int originalIndex) {
        boolean isNamed = true;
        boolean isNamespace = false;
        boolean isDefault = true;
        String elementName = null;
        String alias = localName;
        QualifiedName moduleFQN = ImportDescriptor.getFQN(targetProjectName, targetModule);
        return new ImportDescriptor(isNamed, isNamespace, isDefault, elementName, alias, moduleSpecifier, moduleFQN, originalIndex);
    }

    public static ImportDescriptor createNamespaceImport(String localNamespaceName, String moduleSpecifier, String targetProjectName, QualifiedName targetModule, int originalIndex) {
        boolean isNamed = false;
        boolean isNamespace = true;
        boolean isDefault = false;
        String elementName = null;
        String alias = localNamespaceName;
        QualifiedName moduleFQN = ImportDescriptor.getFQN(targetProjectName, targetModule);
        return new ImportDescriptor(isNamed, isNamespace, isDefault, elementName, alias, moduleSpecifier, moduleFQN, originalIndex);
    }

    private static QualifiedName getFQN(String projectName, QualifiedName moduleName) {
        return QualifiedName.create((String)projectName).append(moduleName);
    }

    public boolean isBare() {
        return !this.isNamed && !this.isNamespace;
    }

    public int hashCode() {
        return Objects.hash(this.isNamed, this.isNamespace, this.isDefault, this.elementName, this.alias, this.moduleFQN);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ImportDescriptor)) {
            return false;
        }
        return this.compareTo((ImportDescriptor)other) == 0;
    }

    @Override
    public int compareTo(ImportDescriptor other) {
        int cmpBareness = Boolean.compare(this.isBare(), other.isBare()) * -1;
        if (cmpBareness != 0) {
            return cmpBareness;
        }
        if (this.isBare()) {
            if (Objects.equals(this.moduleFQN, other.moduleFQN)) {
                return 0;
            }
            return Integer.compare(this.originalIndex, other.originalIndex);
        }
        int cmpModule = this.moduleFQN.compareTo(other.moduleFQN);
        if (cmpModule != 0) {
            return cmpModule;
        }
        int cmpNamespace = Boolean.compare(this.isNamespace, other.isNamespace) * -1;
        if (cmpNamespace != 0) {
            return cmpNamespace;
        }
        if (this.isNamespace && other.isNamespace) {
            return this.alias.compareTo(other.alias);
        }
        int cmpDefault = Boolean.compare(this.isDefault, other.isDefault) * -1;
        if (cmpDefault != 0) {
            return cmpDefault;
        }
        int cmpName = this.elementName.compareTo(other.elementName);
        if (cmpName != 0) {
            return cmpName;
        }
        int cmpAlias = this.alias != null && other.alias != null ? this.alias.compareTo(other.alias) : Boolean.compare(this.alias != null, other.alias != null);
        return cmpAlias;
    }

    public String toCode(String spacing, IValueConverterService valueConverter, N4JSGrammarAccess grammarAccess) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("import ");
        if (this.isNamed) {
            if (this.isDefault) {
                sb.append(this.alias);
            } else {
                sb.append('{');
                sb.append(spacing);
                sb.append(this.elementName);
                if (this.alias != null) {
                    sb.append(" as ");
                    sb.append(this.alias);
                }
                sb.append(spacing);
                sb.append('}');
            }
            sb.append(' ');
        } else if (this.isNamespace) {
            sb.append("* as ");
            sb.append(this.alias);
            sb.append(' ');
        }
        if (!this.isBare()) {
            sb.append("from ");
        }
        if (valueConverter != null && grammarAccess != null) {
            String syntacticModuleSpecifier = valueConverter.toString((Object)this.moduleSpecifier, grammarAccess.getModuleSpecifierRule().getName());
            sb.append(syntacticModuleSpecifier);
        } else {
            sb.append('\"');
            sb.append(this.moduleSpecifier);
            sb.append('\"');
        }
        sb.append(';');
        return sb.toString();
    }
}

