/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server.codeActions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.n4js.ide.server.codeActions.ICodeActionAcceptor;
import org.eclipse.n4js.ide.server.codeActions.QuickfixContext;
import org.eclipse.n4js.ide.server.codeActions.util.CodeActionUtils;

public class CodeActionAcceptor
implements ICodeActionAcceptor {
    List<Either<Command, CodeAction>> codeActions = new ArrayList<Either<Command, CodeAction>>();

    @Override
    public void acceptQuickfixCommand(QuickfixContext context, String title, String commandID, Object ... arguments) {
        this.acceptQuickfixCommand(context, title, commandID, Arrays.asList(arguments));
    }

    public void acceptQuickfixCommand(QuickfixContext context, String title, String commandID, List<Object> arguments) {
        Command command = new Command();
        command.setTitle(title);
        command.setCommand(commandID);
        command.setArguments(arguments);
        this.acceptQuickfixCodeAction(context, title, command);
    }

    public void acceptQuickfixCodeAction(QuickfixContext context, String title, Command command) {
        this.acceptQuickfixCodeAction(context, title, null, command);
    }

    public void acceptQuickfixCodeAction(QuickfixContext context, String title, TextEdit ... textEdits) {
        if (textEdits == null) {
            return;
        }
        this.acceptQuickfixCodeAction(context, title, Arrays.asList(textEdits));
    }

    @Override
    public void acceptQuickfixCodeAction(QuickfixContext context, String title, List<TextEdit> textEdits) {
        if (textEdits == null || textEdits.isEmpty()) {
            return;
        }
        String uri = context.options.getCodeActionParams().getTextDocument().getUri();
        HashMap<String, List<TextEdit>> changes = new HashMap<String, List<TextEdit>>();
        changes.put(uri, textEdits);
        WorkspaceEdit edit = new WorkspaceEdit();
        edit.setChanges(changes);
        this.acceptQuickfixCodeAction(context, title, edit, null);
    }

    public void acceptQuickfixCodeAction(QuickfixContext context, String title, WorkspaceEdit edit) {
        this.acceptQuickfixCodeAction(context, title, edit, null);
    }

    public void acceptQuickfixCodeAction(QuickfixContext context, String title, WorkspaceEdit edit, Command command) {
        CodeActionContext cac;
        if (edit == null && command == null) {
            return;
        }
        CodeAction codeAction = new CodeAction();
        codeAction.setTitle(title);
        codeAction.setEdit(edit);
        codeAction.setCommand(command);
        codeAction.setKind("quickfix");
        if (context.options != null && context.options.getCodeActionParams() != null && (cac = context.options.getCodeActionParams().getContext()) != null && cac.getDiagnostics() != null) {
            codeAction.setDiagnostics(cac.getDiagnostics());
        }
        this.codeActions.add((Either<Command, CodeAction>)Either.forRight((Object)codeAction));
    }

    @Override
    public void acceptSourceAction(String title, String kind, String commandId, Object ... arguments) {
        if (!CodeActionUtils.isSpecialKindOf(kind, "source")) {
            throw new IllegalArgumentException("not a source action kind: " + kind);
        }
        CodeAction codeAction = new CodeAction();
        codeAction.setTitle(title);
        codeAction.setKind(kind);
        Command command = new Command(title, commandId, Arrays.asList(arguments));
        codeAction.setCommand(command);
        this.codeActions.add((Either<Command, CodeAction>)Either.forRight((Object)codeAction));
    }

    public List<Either<Command, CodeAction>> getList() {
        return this.codeActions;
    }
}

