/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.hash.Funnels;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.util.URI;

public class HashedFileContent {
    private static final HashFunction hashFunction = Hashing.murmur3_128();
    private final URI uri;
    private final long hash;

    public HashedFileContent(URI uri, File file) throws IOException {
        this.uri = uri;
        String ext = uri.fileExtension();
        if (ext == null || "ts".equals(ext) || "js".equals(ext) || "jsx".equals(ext) || "map".equals(ext) || "md".equals(ext) || "hbs".equals(ext) || "json".equals(ext) && !"package.json".equals(uri.lastSegment())) {
            this.hash = file.length();
        } else {
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileInputStream s = new FileInputStream(file);){
                Hasher hasher = hashFunction.newHasher();
                ((InputStream)s).transferTo(Funnels.asOutputStream((PrimitiveSink)hasher));
                this.hash = hasher.hash().asLong();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public HashedFileContent(URI uri, long hash) {
        this.uri = uri;
        this.hash = hash;
    }

    HashedFileContent(DataInput input) throws IOException {
        this.uri = URI.createURI((String)input.readUTF());
        this.hash = input.readLong();
    }

    void write(DataOutput out) throws IOException {
        out.writeUTF(this.uri.toString());
        out.writeLong(this.hash);
    }

    public URI getUri() {
        return this.uri;
    }

    public long getHash() {
        return this.hash;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.hash ^ this.hash >>> 32);
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashedFileContent other = (HashedFileContent)obj;
        if (this.hash != other.hash) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public String toString() {
        return this.uri + ":" + Long.toUnsignedString(this.hash);
    }
}

