/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server.concurrent;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.n4js.ide.xtext.server.concurrent.XAbstractRequest;
import org.eclipse.n4js.ide.xtext.server.concurrent.XReadRequest;
import org.eclipse.n4js.ide.xtext.server.concurrent.XWriteRequest;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Functions;

@Singleton
public class XRequestManager {
    private static final Logger LOG = Logger.getLogger(XRequestManager.class);
    @Inject
    private ExecutorService parallel;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    private final ExecutorService queue = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("XRequestManager-Queue-%d").build());
    private List<XAbstractRequest<?>> requests = new ArrayList();

    public synchronized void shutdown() {
        this.queue.shutdown();
        this.parallel.shutdown();
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.queue, (long)2500L, (TimeUnit)TimeUnit.MILLISECONDS);
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.parallel, (long)2500L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.cancel();
    }

    public synchronized <V> CompletableFuture<V> runRead(String description, Functions.Function1<? super CancelIndicator, ? extends V> cancellable) {
        return this.submit(new XReadRequest<V>(this, description, cancellable, this.parallel));
    }

    public synchronized <U, V> CompletableFuture<V> runWrite(String description, Functions.Function0<? extends U> nonCancellable, Functions.Function2<? super CancelIndicator, ? super U, ? extends V> cancellable) {
        return this.submit(new XWriteRequest<U, V>(this, description, nonCancellable, cancellable, this.cancel()));
    }

    public synchronized CompletableFuture<Void> allRequests() {
        List<XAbstractRequest<?>> localRequests = this.requests;
        CompletableFuture[] cfs = new CompletableFuture[localRequests.size()];
        int i = 0;
        int max = localRequests.size();
        while (i < max) {
            XAbstractRequest<?> request = localRequests.get(i);
            cfs[i] = request.get();
            ++i;
        }
        return CompletableFuture.allOf(cfs);
    }

    protected synchronized <V> CompletableFuture<V> submit(XAbstractRequest<V> request) {
        LOG.warn((Object)("submit: " + request));
        this.requests.add(request);
        this.queue.submit(request);
        return request.get();
    }

    protected synchronized CompletableFuture<Void> cancel() {
        List<XAbstractRequest<?>> localRequests = this.requests;
        LOG.warn((Object)("cancel: " + localRequests));
        this.requests = new ArrayList();
        CompletableFuture[] cfs = new CompletableFuture[localRequests.size()];
        int i = 0;
        int max = localRequests.size();
        while (i < max) {
            XAbstractRequest<?> request = localRequests.get(i);
            request.cancel();
            cfs[i] = request.get();
            ++i;
        }
        return CompletableFuture.allOf(cfs);
    }

    protected boolean isCancelException(Throwable t) {
        if (t == null) {
            return false;
        }
        Throwable cause = t;
        if (t instanceof CompletionException) {
            cause = ((CompletionException)t).getCause();
        }
        if (cause instanceof CancellationException) {
            return true;
        }
        return this.operationCanceledManager.isOperationCanceledException(cause);
    }
}

