/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.assistants;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.AnnotableN4MemberDeclaration;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionWithTarget;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.transpiler.TransformationAssistant;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.im.DelegatingGetterDeclaration;
import org.eclipse.n4js.transpiler.im.DelegatingMember;
import org.eclipse.n4js.transpiler.im.DelegatingMethodDeclaration;
import org.eclipse.n4js.transpiler.im.DelegatingSetterDeclaration;
import org.eclipse.n4js.transpiler.im.ImFactory;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.ReferencingElementExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.util.SuperInterfacesIterable;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.RecursionGuard;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

public class DelegationAssistant
extends TransformationAssistant {
    @Inject
    private TypeAssistant typeAssistant;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DelegatingMember createDelegatingMember(TClassifier origin, TMember target) {
        boolean _not_1;
        boolean _tripleEquals;
        ContainerType _containingType = target.getContainingType();
        boolean bl = _tripleEquals = _containingType == origin;
        if (_tripleEquals) {
            throw new IllegalArgumentException("no point in delegating to an owned member");
        }
        DelegatingGetterDeclaration _switchResult = null;
        boolean _matched = false;
        if (target instanceof TField) {
            _matched = true;
            throw new IllegalArgumentException("delegation to fields not supported yet");
        }
        if (target instanceof TGetter) {
            _matched = true;
            _switchResult = ImFactory.eINSTANCE.createDelegatingGetterDeclaration();
        }
        if (!_matched && target instanceof TSetter) {
            _matched = true;
            _switchResult = ImFactory.eINSTANCE.createDelegatingSetterDeclaration();
        }
        if (!_matched && target instanceof TMethod) {
            _matched = true;
            _switchResult = ImFactory.eINSTANCE.createDelegatingMethodDeclaration();
        }
        DelegatingGetterDeclaration result = _switchResult;
        ((PropertyNameOwner)result).setDeclaredName(TranspilerBuilderBlocks._LiteralOrComputedPropertyName((String)target.getName()));
        ((DelegatingMember)result).setDelegationTarget(this.getSymbolTableEntryOriginal((IdentifiableElement)target, true));
        boolean _isStatic = target.isStatic();
        if (_isStatic) {
            EList _declaredModifiers = ((DelegatingMember)result).getDeclaredModifiers();
            _declaredModifiers.add((Object)N4Modifier.STATIC);
        }
        if (origin instanceof TInterface) {
            boolean _not;
            EObject _eContainer = target.eContainer();
            boolean bl2 = _not = !(_eContainer instanceof TInterface);
            if (_not) {
                throw new IllegalArgumentException("cannot delegate from an interface to member of a class");
            }
            ContainerType<?> tSuper = this.getDirectSuperTypeBequestingMember(origin, target);
            ((DelegatingMember)result).setDelegationBaseType(this.getSymbolTableEntryOriginal((IdentifiableElement)tSuper, false));
            ((DelegatingMember)result).setDelegationSuperClassSteps(0);
        } else if (origin instanceof TClass) {
            TClass tAncestor = this.getAncestorClassBequestingMember((TClass)origin, target);
            if (tAncestor != origin) {
                Type _declaredType = ((TClass)origin).getSuperClassRef().getDeclaredType();
                TClass tSuper_1 = (TClass)_declaredType;
                ((DelegatingMember)result).setDelegationBaseType(this.getSymbolTableEntryOriginal((IdentifiableElement)tSuper_1, false));
                int _distanceToAncestorClass = DelegationAssistant.getDistanceToAncestorClass((TClass)origin, tAncestor);
                int _minus = _distanceToAncestorClass - 1;
                ((DelegatingMember)result).setDelegationSuperClassSteps(_minus);
            } else {
                if (tAncestor == null) throw new IllegalStateException("cannot find target (probably not an inherited member)");
                ContainerType<?> tSuper_2 = this.getDirectSuperTypeBequestingMember(origin, target);
                ((DelegatingMember)result).setDelegationBaseType(this.getSymbolTableEntryOriginal((IdentifiableElement)tSuper_2, false));
                ((DelegatingMember)result).setDelegationSuperClassSteps(0);
            }
        } else {
            String _name = origin.eClass().getName();
            String _plus = "unsupported subtype of TClassifier: " + _name;
            throw new IllegalArgumentException(_plus);
        }
        ((DelegatingMember)result).setDelegationTargetIsAbstract(target.isAbstract());
        boolean _isAbstract = target.isAbstract();
        boolean bl3 = _not_1 = !_isAbstract;
        if (!_not_1) return (DelegatingMember)result;
        ((FunctionOrFieldAccessor)result).setBody(TranspilerBuilderBlocks._Block((Statement[])new Statement[0]));
        return (DelegatingMember)result;
    }

    public void replaceDelegatingMembersByOrdinaryMembers(N4ClassifierDeclaration classifierDecl) {
        ArrayList _newArrayList = Lists.newArrayList((Iterable)classifierDecl.getOwnedMembersRaw());
        for (N4MemberDeclaration currMember : _newArrayList) {
            if (!(currMember instanceof DelegatingMember)) continue;
            N4MemberDeclaration resolvedDelegatingMember = this.createOrdinaryMemberForDelegatingMember((DelegatingMember)currMember);
            this.replace(currMember, resolvedDelegatingMember);
        }
    }

    public N4MemberDeclaration createOrdinaryMemberForDelegatingMember(DelegatingMember delegator) {
        String targetNameStr = delegator.getDelegationTarget().getName();
        LiteralOrComputedPropertyName _xifexpression = null;
        _xifexpression = targetNameStr != null && targetNameStr.startsWith("#") ? TranspilerBuilderBlocks._LiteralOrComputedPropertyName((Expression)this.typeAssistant.getMemberNameAsSymbol(targetNameStr), (String)targetNameStr) : TranspilerBuilderBlocks._LiteralOrComputedPropertyName((String)targetNameStr);
        LiteralOrComputedPropertyName targetName = _xifexpression;
        Block body = this.createBodyForDelegatingMember(delegator);
        N4GetterDeclaration _switchResult = null;
        boolean _matched = false;
        if (delegator instanceof DelegatingGetterDeclaration) {
            _matched = true;
            _switchResult = TranspilerBuilderBlocks._N4GetterDecl((LiteralOrComputedPropertyName)targetName, (Block)body);
        }
        if (!_matched && delegator instanceof DelegatingSetterDeclaration) {
            _matched = true;
            _switchResult = TranspilerBuilderBlocks._N4SetterDecl((LiteralOrComputedPropertyName)targetName, (FormalParameter)TranspilerBuilderBlocks._Fpar((String)"value"), (Block)body);
        }
        if (!_matched && delegator instanceof DelegatingMethodDeclaration) {
            _matched = true;
            _switchResult = TranspilerBuilderBlocks._N4MethodDecl((LiteralOrComputedPropertyName)targetName, (Block)body);
        }
        return (AnnotableN4MemberDeclaration)_switchResult;
    }

    private Block createBodyForDelegatingMember(DelegatingMember delegator) {
        SymbolTableEntryOriginal baseSTE = delegator.getDelegationBaseType();
        IdentifiableElement _originalTarget = null;
        if (baseSTE != null) {
            _originalTarget = baseSTE.getOriginalTarget();
        }
        boolean baseIsInterface = _originalTarget instanceof TInterface;
        Expression _xifexpression = null;
        if (baseIsInterface) {
            Expression _xblockexpression = null;
            boolean targetIsStatic = delegator.isStatic();
            Expression objOfInterfaceOfTargetExpr = this.createAccessToInterfaceObject((SymbolTableEntry)baseSTE, targetIsStatic);
            _xifexpression = _xblockexpression = this.createAccessToMemberFunction(objOfInterfaceOfTargetExpr, !targetIsStatic, (N4MemberDeclaration)delegator);
        } else {
            Expression _xblockexpression_1 = null;
            Expression ctorOfClassOfTarget = this.createAccessToClassConstructor((SymbolTableEntry)baseSTE, delegator.getDelegationSuperClassSteps());
            _xifexpression = _xblockexpression_1 = this.createAccessToMemberFunction(ctorOfClassOfTarget, false, (N4MemberDeclaration)delegator);
        }
        Expression targetAccess = _xifexpression;
        return TranspilerBuilderBlocks._Block((Statement[])new Statement[]{TranspilerBuilderBlocks._ReturnStmnt((Expression)TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)targetAccess, (SymbolTableEntry[])new SymbolTableEntry[]{this.getSymbolTableEntryForMember((TClassifier)RuleEnvironmentExtensions.functionType((RuleEnvironment)this.getState().G), "apply", false, false, true)}), (Expression[])new Expression[]{TranspilerBuilderBlocks._ThisLiteral(), TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.steFor_arguments())}))});
    }

    private Expression createAccessToClassConstructor(SymbolTableEntry classSTE, int superClassSteps) {
        TClassifier objectType = RuleEnvironmentExtensions.objectType((RuleEnvironment)this.getState().G);
        SymbolTableEntryOriginal objectSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)objectType, true);
        ReferencingElementExpression_IM result = this.__NSSafe_IdentRef(classSTE);
        if (superClassSteps > 0) {
            SymbolTableEntryOriginal getPrototypeOfSTE = this.getSymbolTableEntryForMember(objectType, "getPrototypeOf", false, true, true);
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, superClassSteps, true);
            for (Integer n : _doubleDotLessThan) {
                result = TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)objectSTE, (SymbolTableEntry[])new SymbolTableEntry[]{getPrototypeOfSTE}), (Expression[])new Expression[]{result});
            }
        }
        return result;
    }

    private Expression createAccessToInterfaceObject(SymbolTableEntry ifcSTE, boolean targetIsStatic) {
        ReferencingElementExpression_IM result = this.__NSSafe_IdentRef(ifcSTE);
        if (!targetIsStatic) {
            result = TranspilerBuilderBlocks._PropertyAccessExpr((Expression)result, (SymbolTableEntry[])new SymbolTableEntry[]{this.steFor_$defaultMembers()});
        }
        return result;
    }

    private Expression createAccessToMemberFunction(Expression protoOrCtorExpr, boolean exprIsProto, N4MemberDeclaration member) {
        if (member instanceof N4FieldDeclaration) {
            throw new IllegalArgumentException("no member function available for fields");
        }
        if (member instanceof N4MethodDeclaration) {
            String memberName = ((N4MethodDeclaration)member).getName();
            boolean memberIsSymbol = memberName != null && memberName.startsWith("#");
            SymbolTableEntry memberSTE = this.findSymbolTableEntryForElement((NamedElement)member, true);
            Object _xifexpression = null;
            _xifexpression = !memberIsSymbol ? TranspilerBuilderBlocks._PropertyAccessExpr((Expression)protoOrCtorExpr, (SymbolTableEntry[])new SymbolTableEntry[]{memberSTE}) : TranspilerBuilderBlocks._IndexAccessExpr((Expression)protoOrCtorExpr, (Expression)this.typeAssistant.getMemberNameAsSymbol(memberName));
            return (ExpressionWithTarget)_xifexpression;
        }
        Expression accessToMemberDefinition = this.createAccessToMemberDescriptor(protoOrCtorExpr, exprIsProto, member);
        ParameterizedPropertyAccessExpression_IM result = TranspilerBuilderBlocks._PropertyAccessExpr((Expression)accessToMemberDefinition, (SymbolTableEntry[])new SymbolTableEntry[]{this.getPropertyDescriptorValueProperty(member)});
        return result;
    }

    private Expression createAccessToMemberDescriptor(Expression protoOrCtorExpr, boolean exprIsProto, N4MemberDeclaration member) {
        String memberName = member.getName();
        boolean memberIsSymbol = memberName != null && memberName.startsWith("#");
        SymbolTableEntry memberSTE = this.findSymbolTableEntryForElement((NamedElement)member, true);
        TClassifier objectType = RuleEnvironmentExtensions.objectType((RuleEnvironment)this.getState().G);
        SymbolTableEntryOriginal objectSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)objectType, true);
        SymbolTableEntryOriginal getOwnPropertyDescriptorSTE = this.getSymbolTableEntryForMember(objectType, "getOwnPropertyDescriptor", false, true, true);
        boolean isStatic = member.isStatic();
        Expression arg0 = protoOrCtorExpr;
        if (!exprIsProto && !isStatic) {
            SymbolTableEntryOriginal prototypeSTE = this.getSymbolTableEntryForMember(objectType, "prototype", false, true, true);
            arg0 = TranspilerBuilderBlocks._PropertyAccessExpr((Expression)arg0, (SymbolTableEntry[])new SymbolTableEntry[]{prototypeSTE});
        } else if (exprIsProto && isStatic) {
            SymbolTableEntryOriginal constructorSTE = this.getSymbolTableEntryForMember(objectType, "constructor", false, false, true);
            arg0 = TranspilerBuilderBlocks._PropertyAccessExpr((Expression)arg0, (SymbolTableEntry[])new SymbolTableEntry[]{constructorSTE});
        }
        Object _xifexpression = null;
        _xifexpression = !memberIsSymbol ? TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)memberSTE) : this.typeAssistant.getMemberNameAsSymbol(memberName);
        StringLiteral arg1 = _xifexpression;
        ParameterizedCallExpression result = TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)objectSTE, (SymbolTableEntry[])new SymbolTableEntry[]{getOwnPropertyDescriptorSTE}), (Expression[])new Expression[]{arg0, arg1});
        return result;
    }

    private ContainerType<?> getDirectSuperTypeBequestingMember(TClassifier classifier, TMember inheritedMember) {
        return this.getState().memberCollector.directSuperTypeBequestingMember(classifier, inheritedMember);
    }

    private TClass getAncestorClassBequestingMember(TClass classifier, TMember inheritedOrConsumedMember) {
        TClass _xblockexpression = null;
        ContainerType containingType = inheritedOrConsumedMember.getContainingType();
        TClass _xifexpression = null;
        if (containingType == classifier) {
            return classifier;
        }
        TClass _xifexpression_1 = null;
        if (containingType instanceof TInterface) {
            _xifexpression_1 = SuperInterfacesIterable.of((TClassifier)classifier).findClassImplementingInterface((TInterface)containingType);
        } else {
            TClass _xifexpression_2 = null;
            if (!(containingType instanceof TClass)) {
                String _name = containingType.eClass().getName();
                String _plus = "unsupported subtype of TClassifier: " + _name;
                throw new IllegalArgumentException(_plus);
            }
            _xifexpression_2 = (TClass)containingType;
            _xifexpression_1 = _xifexpression_2;
        }
        _xblockexpression = _xifexpression = _xifexpression_1;
        return _xblockexpression;
    }

    private static int getDistanceToAncestorClass(TClass base, TClass ancestorClass) {
        if (ancestorClass == null || ancestorClass == base) {
            return 0;
        }
        RecursionGuard guard = new RecursionGuard();
        int result = 0;
        TClass curr = base;
        while (curr != null && curr != ancestorClass) {
            boolean _tryNext = guard.tryNext((Object)curr);
            if (!_tryNext) continue;
            ++result;
            ParameterizedTypeRef _superClassRef = curr.getSuperClassRef();
            Type _declaredType = null;
            if (_superClassRef != null) {
                _declaredType = _superClassRef.getDeclaredType();
            }
            curr = (TClass)_declaredType;
        }
        int _xifexpression = 0;
        _xifexpression = curr != null ? result : 0;
        return _xifexpression;
    }

    private SymbolTableEntry getPropertyDescriptorValueProperty(N4MemberDeclaration delegator) {
        SymbolTableEntryInternal _switchResult = null;
        boolean _matched = false;
        if (delegator instanceof N4GetterDeclaration) {
            _matched = true;
            _switchResult = this.steFor_get();
        }
        if (!_matched && delegator instanceof N4SetterDeclaration) {
            _matched = true;
            _switchResult = this.steFor_set();
        }
        if (!_matched && delegator instanceof N4MethodDeclaration) {
            _matched = true;
            _switchResult = this.steFor_value();
        }
        return _switchResult;
    }
}

