/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.editor.contentassist;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ide.contentassist.antlr.N4JSParser;
import org.eclipse.n4js.ide.contentassist.antlr.internal.InternalN4JSParser;
import org.eclipse.n4js.ide.editor.contentassist.ContentAssistDataCollectors;
import org.eclipse.n4js.ide.editor.contentassist.ContentAssistTokenTypeMapper;
import org.eclipse.n4js.ide.editor.contentassist.ParamAwareEntryPointFinder;
import org.eclipse.n4js.ide.editor.contentassist.TokenSourceFactory;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Condition;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.NamedArgument;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.ide.editor.contentassist.antlr.BaseFollowElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.FollowElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.IPartialContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.LookAheadTerminal;
import org.eclipse.xtext.ide.editor.contentassist.antlr.ObservableXtextTokenStream;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.BaseInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.InfiniteRecursion;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.ParseResult;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.parser.antlr.IUnorderedGroupHelper;
import org.eclipse.xtext.xtext.ConditionEvaluator;
import org.eclipse.xtext.xtext.ParameterConfigHelper;

public class CustomN4JSParser
extends N4JSParser
implements IPartialContentAssistParser {
    @Inject
    private TokenSourceFactory tokenSourceFactory;
    @Inject
    private ContentAssistDataCollectors dataCollectors;
    @Inject
    private ParamAwareEntryPointFinder entryPointFinder;
    private BitSet mandatoryASI;
    private int eol;
    private int semi;
    private Group postfixGroup;

    @Override
    protected CustomInternalN4JSParser createParser() {
        CustomInternalN4JSParser result = new CustomInternalN4JSParser();
        result.setGrammarAccess(this.getGrammarAccess());
        return result;
    }

    protected Collection<FollowElement> getFollowElements(AbstractInternalContentAssistParser parser) {
        try {
            InternalN4JSParser casted = (InternalN4JSParser)parser;
            casted.entryRuleScript();
            return casted.getFollowElements();
        }
        catch (RecognitionException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<FollowElement> getFollowElements(IParseResult parseResult, int startOffset, int endOffset, boolean strict) {
        return this.getFollowElements((INode)parseResult.getRootNode(), startOffset, endOffset, strict);
    }

    public Collection<FollowElement> getFollowElements(IParseResult parseResult, int offset, boolean strict) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Measurement m = this.dataCollectors.dcParseContexts().getMeasurement();){
            String ruleName;
            LinkedHashSet result = Sets.newLinkedHashSet();
            ICompositeNode entryPoint = this.entryPointFinder.findEntryPoint(parseResult, offset);
            if (entryPoint == null) {
                entryPoint = parseResult.getRootNode();
                ruleName = this.getRuleNames().getAntlrRuleName(this.getEntryRule());
            } else {
                ruleName = this.getRuleName(entryPoint);
            }
            if (ruleName == null) {
                entryPoint = parseResult.getRootNode();
                ruleName = "ruleScript";
            }
            TokenSource tokenSource = this.tokenSourceFactory.toTokenSource((INode)entryPoint, entryPoint.getOffset(), offset, true);
            CustomInternalN4JSParser parser = this.collectFollowElements(tokenSource, this.getEntryGrammarElement(entryPoint), ruleName, strict, result);
            this.adjustASIAndCollectFollowElements(parser, ruleName, strict, result);
            return Lists.newArrayList((Iterable)result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getRuleName(ICompositeNode entryPoint) {
        String[][] names;
        RuleCall rc;
        AbstractRule rule;
        EObject grammarElement = entryPoint.getGrammarElement();
        if (grammarElement instanceof RuleCall && (rule = (rc = (RuleCall)grammarElement).getRule()) instanceof ParserRule && !GrammarUtil.isMultipleCardinality((AbstractElement)rule.getAlternatives()) && (names = this.getRequiredRuleNames(this.getRuleName((AbstractElement)(grammarElement = rule.getAlternatives())), Ints.asList((int[])new int[]{this.getParamConfig(entryPoint)}), (AbstractElement)grammarElement)).length > 0) {
            return names[0][0];
        }
        if (grammarElement instanceof ParserRule) {
            return this.getRuleName(((ParserRule)grammarElement).getAlternatives());
        }
        AbstractElement result = (AbstractElement)grammarElement;
        if (result instanceof Action) {
            return this.getRuleName((ICompositeNode)entryPoint.getFirstChild());
        }
        return this.getRuleName(result);
    }

    private int getParamConfig(ICompositeNode node) {
        ArrayList<RuleCall> callStack = new ArrayList<RuleCall>();
        this.recreateCallStack(node, callStack);
        Set<Parameter> params = this.getParamConfig(callStack);
        int result = ParameterConfigHelper.getParameterConfig(params);
        return result;
    }

    private Set<Parameter> getParamConfig(List<RuleCall> callStack) {
        HashSet<Object> assignedParams = new HashSet<Parameter>();
        int i = callStack.size() - 1;
        while (i >= 0) {
            RuleCall rc = callStack.get(i);
            ConditionEvaluator evaluator = new ConditionEvaluator(assignedParams);
            assignedParams = new HashSet();
            for (NamedArgument arg : rc.getArguments()) {
                Condition value = arg.getValue();
                if (!evaluator.evaluate(value)) continue;
                assignedParams.add(arg.getParameter());
            }
            --i;
        }
        return assignedParams;
    }

    void recreateCallStack(ICompositeNode node, List<RuleCall> stack) {
        EObject element = node.getGrammarElement();
        if (element instanceof RuleCall) {
            RuleCall rc = (RuleCall)element;
            if (rc.getArguments().isEmpty()) {
                return;
            }
            stack.add(rc);
            this.recreateCallStack(node.getParent(), stack);
        } else if (element instanceof Action) {
            INode firstChild = node.getFirstChild();
            while (firstChild.getGrammarElement() instanceof Action) {
                firstChild = ((ICompositeNode)firstChild).getFirstChild();
            }
            element = firstChild.getGrammarElement();
            if (element instanceof RuleCall) {
                RuleCall rc = (RuleCall)element;
                if (rc.getArguments().isEmpty()) {
                    return;
                }
                stack.add(rc);
                this.recreateCallStack(node.getParent(), stack);
            }
        }
    }

    public Collection<FollowElement> getFollowElements(INode node, int startOffset, int endOffset, boolean strict) {
        return this.getFollowElements((IParseResult)new ParseResult(null, (ICompositeNode)node, false), endOffset, strict);
    }

    private void adjustASIAndCollectFollowElements(CustomInternalN4JSParser previousParser, String ruleName, boolean strict, Set<FollowElement> result) {
        ObservableXtextTokenStream tokens = (ObservableXtextTokenStream)previousParser.getTokenStream();
        int lastTokenIndex = tokens.size() - 1;
        if (lastTokenIndex >= 0) {
            CommonToken lastToken = (CommonToken)tokens.LT(-1);
            List tokenList = tokens.getTokens();
            if (lastToken == null) {
                return;
            }
            if (this.shouldSkipASI(lastToken)) {
                if (this.maySkipASI(lastToken, tokens)) {
                    tokenList.remove(lastTokenIndex);
                    result.addAll(this.resetAndGetFollowElements(tokens, ruleName, strict));
                    this.removePostfixOperator(result);
                }
            } else if (this.shouldAddSyntheticSemicolon(previousParser, lastTokenIndex, lastToken)) {
                CommonToken token = new CommonToken(this.semi);
                tokenList.add(token);
                result.addAll(this.resetAndGetFollowElements(tokens, ruleName, strict));
                this.removePostfixOperator(result);
            }
        }
    }

    private void removePostfixOperator(Set<FollowElement> result) {
        Iterator<FollowElement> iter = result.iterator();
        while (iter.hasNext()) {
            FollowElement fe = iter.next();
            if (this.postfixGroup != fe.getGrammarElement()) continue;
            iter.remove();
        }
    }

    private boolean maySkipASI(CommonToken lastToken, ObservableXtextTokenStream tokens) {
        int countDownFrom = lastToken.getTokenIndex();
        int i = countDownFrom - 1;
        while (i >= 0) {
            Token prevToken = tokens.get(i);
            if (prevToken.getChannel() == 0) {
                return !this.mandatoryASI.get(prevToken.getType());
            }
            --i;
        }
        return true;
    }

    private boolean shouldSkipASI(CommonToken lastToken) {
        if (lastToken.getType() == this.eol) {
            return true;
        }
        return lastToken.getType() == this.semi && lastToken.getText() != null && !";".equals(lastToken.getText());
    }

    private boolean shouldAddSyntheticSemicolon(CustomInternalN4JSParser previousParser, int lastTokenIndex, CommonToken lastNonHiddenToken) {
        return lastTokenIndex != lastNonHiddenToken.getTokenIndex() && previousParser.getState().lastErrorIndex != lastNonHiddenToken.getTokenIndex();
    }

    private Collection<FollowElement> resetAndGetFollowElements(ObservableXtextTokenStream tokens, String ruleName, boolean strict) {
        CustomInternalN4JSParser parser = this.createParser();
        parser.setStrict(strict);
        tokens.reset();
        return this.doGetFollowElements(parser, tokens, ruleName);
    }

    private CustomInternalN4JSParser collectFollowElements(TokenSource tokens, AbstractElement grammarElement, String ruleName, boolean strict, Set<FollowElement> result) {
        CustomInternalN4JSParser parser = this.createParser();
        parser.setStrict(strict);
        try {
            if (grammarElement != null) {
                parser.getGrammarElements().add(grammarElement);
            }
            ObservableXtextTokenStream tokenStream = new ObservableXtextTokenStream(tokens, (ITokenDefProvider)parser);
            result.addAll(this.doGetFollowElements(parser, tokenStream, ruleName));
        }
        catch (InfiniteRecursion infinite) {
            result.addAll(parser.getFollowElements());
        }
        return parser;
    }

    private Collection<FollowElement> doGetFollowElements(AbstractInternalContentAssistParser parser, ObservableXtextTokenStream tokens, String ruleName) {
        tokens.setInitialHiddenTokens(this.getInitialHiddenTokens());
        parser.setTokenStream((TokenStream)tokens);
        IUnorderedGroupHelper helper = (IUnorderedGroupHelper)this.getUnorderedGroupHelper().get();
        parser.setUnorderedGroupHelper(helper);
        helper.initializeWith((BaseRecognizer)parser);
        tokens.setListener((ObservableXtextTokenStream.StreamListener)parser);
        Collection followElements = this.getFollowElements((BaseInternalContentAssistParser)parser, ruleName);
        return followElements;
    }

    public Collection<FollowElement> getFollowElements(String input, boolean strict) {
        throw new UnsupportedOperationException("Use getFollowElements(INode, int, int, boolean) instead");
    }

    public void setTokenSourceFactory(TokenSourceFactory tokenSourceFactory) {
        this.tokenSourceFactory = tokenSourceFactory;
    }

    public TokenSourceFactory getTokenSourceFactory() {
        return this.tokenSourceFactory;
    }

    public void setDataCollectors(ContentAssistDataCollectors dataCollectors) {
        this.dataCollectors = dataCollectors;
    }

    public ContentAssistDataCollectors getDataCollectors() {
        return this.dataCollectors;
    }

    public void setEntryPointFinder(ParamAwareEntryPointFinder entryPointFinder) {
        this.entryPointFinder = entryPointFinder;
    }

    public ParamAwareEntryPointFinder getEntryPointFinder() {
        return this.entryPointFinder;
    }

    @Inject
    public void initializeTokenTypes(ContentAssistTokenTypeMapper mapper, N4JSGrammarAccess grammarAccess) {
        BitSet bits = new BitSet();
        bits.set(mapper.getInternalTokenType((EObject)grammarAccess.getReturnStatementAccess().getReturnKeyword_1()));
        bits.set(mapper.getInternalTokenType((EObject)grammarAccess.getThrowStatementAccess().getThrowKeyword_0()));
        bits.set(mapper.getInternalTokenType((EObject)grammarAccess.getBreakStatementAccess().getBreakKeyword_1()));
        bits.set(mapper.getInternalTokenType((EObject)grammarAccess.getContinueStatementAccess().getContinueKeyword_1()));
        this.mandatoryASI = bits;
        this.eol = mapper.getInternalTokenType((EObject)this.getGrammarAccess().getEOLRule());
        this.semi = mapper.getInternalTokenType((EObject)this.getGrammarAccess().getSemiAccess().getSemicolonKeyword());
        this.postfixGroup = grammarAccess.getPostfixExpressionAccess().getGroup_1();
    }

    public Collection<FollowElement> getFollowElements(FollowElement element) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Measurement m = this.dataCollectors.dcParseFollowElements().getMeasurement();){
            if (element.getLookAhead() <= 1) {
                throw new IllegalArgumentException("lookahead may not be less than or equal to 1");
            }
            ArrayList<FollowElement> result = new ArrayList<FollowElement>();
            Collection elementsToParse = this.getElementsToParse((BaseFollowElement)element);
            for (AbstractElement elementToParse : elementsToParse) {
                elementToParse = this.unwrapSingleElementGroups(elementToParse);
                this.collectFollowElements(elementToParse, element, result);
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void collectFollowElements(AbstractElement parseMe, FollowElement baseFollowElement, Collection<FollowElement> result) {
        String[][] allRuleNames;
        String ruleName = this.getRuleName(parseMe);
        String[][] stringArray = allRuleNames = this.getRequiredRuleNames(ruleName, baseFollowElement.getParamStack(), parseMe);
        int n = allRuleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String[] ruleNames = stringArray[n2];
            int i = 0;
            while (i < ruleNames.length) {
                AbstractInternalContentAssistParser parser = this.createParser(parseMe, baseFollowElement);
                Collection elements = this.getFollowElements((BaseInternalContentAssistParser)parser, parseMe, ruleNames, i);
                result.addAll(elements);
                ++i;
            }
            ++n2;
        }
    }

    private AbstractInternalContentAssistParser createParser(AbstractElement parseMe, FollowElement baseFollowElement) {
        CustomInternalN4JSParser parser = this.createParser();
        parser.setUnorderedGroupHelper((IUnorderedGroupHelper)this.getUnorderedGroupHelper().get());
        parser.getUnorderedGroupHelper().initializeWith((BaseRecognizer)parser);
        ObservableXtextTokenStream tokens = this.toTokenStream(baseFollowElement, (ITokenDefProvider)parser);
        parser.setTokenStream((TokenStream)tokens);
        tokens.setListener((ObservableXtextTokenStream.StreamListener)parser);
        parser.getGrammarElements().addAll(baseFollowElement.getTrace());
        parser.getGrammarElements().add(parseMe);
        parser.getLocalTrace().addAll(baseFollowElement.getLocalTrace());
        parser.getLocalTrace().add(parseMe);
        parser.getParamStack().addAll(baseFollowElement.getParamStack());
        if (parseMe instanceof UnorderedGroup && baseFollowElement.getGrammarElement() == parseMe) {
            UnorderedGroup group = (UnorderedGroup)parseMe;
            IUnorderedGroupHelper helper = parser.getUnorderedGroupHelper();
            helper.enter(group);
            for (AbstractElement consumed : baseFollowElement.getHandledUnorderedGroupElements()) {
                parser.before((EObject)consumed);
                helper.select(group, group.getElements().indexOf((Object)consumed));
                helper.returnFromSelection(group);
                parser.after((EObject)consumed);
            }
            parser.setUnorderedGroupHelper(this.wrap(helper));
        }
        return parser;
    }

    private IUnorderedGroupHelper wrap(final IUnorderedGroupHelper baseHelper) {
        return new IUnorderedGroupHelper(){
            boolean first = true;

            public void initializeWith(BaseRecognizer recognizer) {
                baseHelper.initializeWith(recognizer);
            }

            public void enter(UnorderedGroup group) {
                if (!this.first) {
                    baseHelper.enter(group);
                }
                this.first = false;
            }

            public void leave(UnorderedGroup group) {
                baseHelper.leave(group);
            }

            public boolean canSelect(UnorderedGroup group, int index) {
                return baseHelper.canSelect(group, index);
            }

            public void select(UnorderedGroup group, int index) {
                baseHelper.select(group, index);
            }

            public void returnFromSelection(UnorderedGroup group) {
                baseHelper.returnFromSelection(group);
            }

            public boolean canLeave(UnorderedGroup group) {
                return baseHelper.canLeave(group);
            }

            public IUnorderedGroupHelper.UnorderedGroupState snapShot(UnorderedGroup ... groups) {
                return baseHelper.snapShot(groups);
            }
        };
    }

    private ObservableXtextTokenStream toTokenStream(FollowElement element, ITokenDefProvider tokenDefProvider) {
        final Iterator iter = element.getLookAheadTerminals().iterator();
        return new ObservableXtextTokenStream(new TokenSource(){

            public Token nextToken() {
                if (iter.hasNext()) {
                    LookAheadTerminal lookAhead = (LookAheadTerminal)iter.next();
                    return lookAhead.getToken();
                }
                return Token.EOF_TOKEN;
            }

            public String getSourceName() {
                return "LookAheadTerminalTokenSource";
            }
        }, tokenDefProvider);
    }

    protected static class CustomInternalN4JSParser
    extends InternalN4JSParser {
        public CustomInternalN4JSParser() {
            super(null);
        }

        public RecognizerSharedState getState() {
            return this.state;
        }
    }
}

