/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.n4js.smith.DataCollector;
import org.eclipse.n4js.smith.DataCollectors;
import org.eclipse.n4js.smith.DataPoint;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.smith.TimedMeasurement;

class TimedDataCollector
extends DataCollector {
    public static final boolean AVOID_EXCESSIVE_DATA_COLLECTION = true;
    private final String id;
    private final Map<String, DataCollector> children = new LinkedHashMap<String, DataCollector>();
    private static final TimedMeasurement NULL_MEASURMENT = new TimedMeasurement("NOOP", TimedDataCollector::noop);
    private boolean paused = true;
    private Measurement activeMeasurement = null;
    private final List<DataPoint> data = new LinkedList<DataPoint>();

    public TimedDataCollector(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean hasActiveMeasurement() {
        return this.activeMeasurement != null;
    }

    @Override
    public Measurement getMeasurementIfInactive(String name) {
        return this.getMeasurement(name, true);
    }

    @Override
    public Measurement getMeasurement(String name) {
        return this.getMeasurement(name, false);
    }

    private synchronized Measurement getMeasurement(String name, boolean allowReentrantInvocation) {
        if (name == null || name.isEmpty()) {
            throw new RuntimeException(String.valueOf(TimedMeasurement.class.getName()) + " needs non empty name.");
        }
        if (this.paused) {
            return NULL_MEASURMENT;
        }
        if (this.activeMeasurement != null) {
            if (!allowReentrantInvocation) {
                DataCollectors.INSTANCE.warn("reentrant invocation of #getMeasurement() in data collector " + this.id);
            }
            return NULL_MEASURMENT;
        }
        this.activeMeasurement = new TimedMeasurement(name, this::consume);
        return this.activeMeasurement;
    }

    private synchronized void consume(TimedMeasurement measurement) {
        if (measurement != this.activeMeasurement) {
            DataCollectors.INSTANCE.warn("invocation of #consume() without matching prior call to #getMeasurement() in data collector " + this.id + "#" + measurement.name);
            return;
        }
        this.activeMeasurement = null;
        String name = measurement.name;
        long elapsed = measurement.elapsed(TimeUnit.NANOSECONDS);
        for (DataPoint dp : this.data) {
            elapsed += dp.nanos.longValue();
        }
        this.data.clear();
        this.data.add(new DataPoint(name, elapsed));
    }

    @Override
    public List<DataPoint> getData() {
        return Collections.unmodifiableList(this.data);
    }

    @Override
    public Collection<DataCollector> getChildren() {
        return this.children.values();
    }

    @Override
    public DataCollector getChild(String childId) {
        return this.children.get(childId);
    }

    @Override
    public void addChild(DataCollector child) {
        String childId = child.getId();
        if (this.children.containsKey(childId)) {
            throw new RuntimeException("Already contains key " + childId + " with child " + this.children.get(childId));
        }
        if (this.children.containsValue(child)) {
            String keys = this.children.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), child)).map(Map.Entry::getKey).collect(Collectors.joining(",", "[", "]"));
            throw new RuntimeException("Already contains child " + child + " with keys " + keys);
        }
        this.children.put(childId, child);
    }

    @Override
    public Collection<String> childrenKeys() {
        return this.children.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPaused(boolean paused) {
        TimedDataCollector timedDataCollector = this;
        synchronized (timedDataCollector) {
            if (!paused && this.paused != paused) {
                this.activeMeasurement = null;
                this.paused = paused;
            }
        }
        this.children.values().forEach(child -> child.setPaused(paused));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetData() {
        TimedDataCollector timedDataCollector = this;
        synchronized (timedDataCollector) {
            this.data.clear();
        }
        this.children.values().forEach(c -> c.resetData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeData() {
        this.activeMeasurement = null;
        TimedDataCollector timedDataCollector = this;
        synchronized (timedDataCollector) {
            this.data.clear();
        }
        this.children.values().forEach(c -> c.purgeData());
    }

    private static void noop(Measurement measurement) {
    }
}

