/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.ui;

import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.customize.DefaultEntryPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.common.snippets.internal.SnippetsMessages;
import org.eclipse.wst.common.snippets.internal.editors.ISnippetEditor;
import org.eclipse.wst.common.snippets.internal.editors.VariableItemEditor;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.ui.SnippetsCustomizer;

public class SnippetTemplateEntryPage
extends DefaultEntryPage
implements ModifyListener {
    public static final Class DEFAULT_EDITOR_CLASS = VariableItemEditor.class;
    protected SnippetsCustomizer snippetsCustomizer = null;
    protected ISnippetEditor editor = null;

    public SnippetTemplateEntryPage(SnippetsCustomizer customizer) {
        this.snippetsCustomizer = customizer;
    }

    public void createControl(Composite parent, PaletteEntry entry) {
        super.createControl(parent, entry);
        this.editor = this.getEditor((SnippetPaletteItem)entry);
        if (this.editor != null) {
            this.snippetsCustomizer.activeEditors.add(this.editor);
            this.editor.addModifyListener(this);
            this.editor.setItem((SnippetPaletteItem)entry);
            this.editor.createContents((Composite)this.getControl());
            ((Composite)this.getControl()).setTabList(null);
        }
    }

    protected ISnippetEditor getEditor(SnippetPaletteItem item) {
        ISnippetEditor snippetEditor = null;
        if (item.getSourceType() == "USER" || item.getSourceType() == "WORKSPACE") {
            snippetEditor = item.getProvider() == null ? new VariableItemEditor() : item.getProvider().getSnippetEditor();
        }
        return snippetEditor;
    }

    public void modifyText(ModifyEvent e) {
        if (this.editor != null && this.editor.getItem() != null && this.editor.getItem().getLabel().trim().length() == 0) {
            this.getPageContainer().showProblem("");
        } else {
            this.getPageContainer().clearProblem();
        }
    }

    protected void handleNameChanged(String text) {
        super.handleNameChanged(text);
        if (text.length() < 1) {
            this.getPageContainer().showProblem(SnippetsMessages.NameCannotBeEmpty);
        } else {
            this.getPageContainer().clearProblem();
        }
    }
}

