/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.flowgraphs.factories.OrderedEContentProvider;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public final class ASTIterator
implements Iterator<ControlFlowElement> {
    ControlFlowElement cfe;
    ArrayList<EObject> nextElems = new ArrayList();
    ArrayList<ControlFlowElement> containerStack = new ArrayList();

    public ASTIterator(EObject cfe) {
        this.nextElems.add(cfe);
    }

    @Override
    public boolean hasNext() {
        this.searchNextCFE();
        int i = 0;
        while (i < this.containerStack.size()) {
            if (this.nextElems.get(i) != this.containerStack.get(this.containerStack.size() - 1 - i)) {
                return true;
            }
            ++i;
        }
        return this.containerStack.isEmpty() && !this.nextElems.isEmpty();
    }

    @Override
    public ControlFlowElement next() {
        return this.pop();
    }

    public ControlFlowElement container() {
        if (this.containerStack.isEmpty()) {
            return null;
        }
        return this.containerStack.get(this.containerStack.size() - 1);
    }

    private void searchNextCFE() {
        int idx = 0;
        while (this.isClosingContainer(idx)) {
            ++idx;
        }
        while (this.nextElems.size() > idx && !(this.nextElems.get(idx) instanceof ControlFlowElement)) {
            EObject firstElem = this.nextElems.remove(idx);
            List<EObject> children = OrderedEContentProvider.eContents(firstElem);
            this.nextElems.addAll(idx, children);
            while (this.isClosingContainer(idx)) {
                ++idx;
            }
        }
    }

    private boolean isClosingContainer(int idx) {
        int cntSize = this.containerStack.size();
        return cntSize > idx && this.nextElems.get(idx) == this.containerStack.get(cntSize - 1 - idx);
    }

    private ControlFlowElement pop() {
        this.searchNextCFE();
        ControlFlowElement firstElem = (ControlFlowElement)this.nextElems.remove(0);
        if (!this.containerStack.isEmpty() && firstElem == this.containerStack.get(this.containerStack.size() - 1)) {
            this.containerStack.remove(this.containerStack.size() - 1);
            return this.pop();
        }
        List<EObject> children = OrderedEContentProvider.eContents((EObject)firstElem);
        boolean isContainer = FGUtils.isCFContainer((EObject)firstElem);
        if (isContainer) {
            this.containerStack.add(firstElem);
            this.nextElems.add(0, (EObject)firstElem);
        }
        this.nextElems.addAll(0, children);
        return firstElem;
    }
}

