/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences.external;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.Semver.VersionRangeSetRequirement;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.preferences.external.InstallNpmDependencyDialog;
import org.eclipse.n4js.ui.preferences.external.NpmNameAndVersionValidatorHelper;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.StatusUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.xbase.lib.StringExtensions;

class InstallNpmDependencyButtonListener
extends SelectionAdapter {
    private final LibraryManager libManager;
    private final NpmNameAndVersionValidatorHelper validatorHelper;
    private final SemverHelper semverHelper;
    private final StatusHelper statusHelper;
    private final Runnable updateLocations;
    private final Supplier<SafeURI<?>> getSelectedNodeModulesURI;

    public InstallNpmDependencyButtonListener(Runnable updateLocations, LibraryManager libManager, NpmNameAndVersionValidatorHelper validatorHelper, SemverHelper semverHelper, StatusHelper statusHelper, Supplier<SafeURI<?>> getSelectedNodeModulesURI) {
        this.updateLocations = updateLocations;
        this.libManager = libManager;
        this.validatorHelper = validatorHelper;
        this.semverHelper = semverHelper;
        this.statusHelper = statusHelper;
        this.getSelectedNodeModulesURI = getSelectedNodeModulesURI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void widgetSelected(SelectionEvent e) {
        VersionRangeSetRequirement packageVersion;
        MultiStatus multistatus;
        String packageName;
        block8: {
            InstallNpmDependencyDialog dialog = new InstallNpmDependencyDialog(UIUtils.getShell(), this.validatorHelper.getPackageNameToInstallValidator(), this.validatorHelper.getPackageVersionValidator());
            dialog.open();
            packageName = dialog.getPackageName();
            if (StringExtensions.isNullOrEmpty((String)packageName) || dialog.getReturnCode() != 0) {
                return;
            }
            multistatus = this.statusHelper.createMultiStatus("Installing npm '" + packageName + "'.");
            String packageVersionStr = dialog.getVersionConstraint();
            packageVersion = this.semverHelper.parseVersionRangeSet(packageVersionStr);
            if (packageVersion != null) break block8;
            if (multistatus.isOK()) return;
            N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
            UIUtils.getDisplay().asyncExec(() -> {
                String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Install Failed", (String)descr, (IStatus)multistatus);
            });
            return;
        }
        try {
            File file = this.getSelectedNodeModulesURI.get().getParent().toJavaIoFile();
            new ProgressMonitorDialog(UIUtils.getShell()).run(true, true, arg_0 -> this.lambda$1(packageName, (NPMVersionRequirement)packageVersion, file, multistatus, arg_0));
        }
        catch (InterruptedException | OperationCanceledException packageVersionStr) {
            if (multistatus.isOK()) return;
            N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
            UIUtils.getDisplay().asyncExec(() -> {
                String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Install Failed", (String)descr, (IStatus)multistatus);
            });
            return;
        }
        catch (Exception exc) {
            try {
                String msg = "Error while installing npm dependency: '" + packageName + "'.";
                Throwable throwable = exc.getCause() == null ? exc : exc.getCause();
                multistatus.merge(this.statusHelper.createError(msg, throwable));
            }
            catch (Throwable throwable) {
                if (multistatus.isOK()) throw throwable;
                N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                UIUtils.getDisplay().asyncExec(() -> {
                    String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                    ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Install Failed", (String)descr, (IStatus)multistatus);
                });
                throw throwable;
            }
            if (multistatus.isOK()) return;
            N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
            UIUtils.getDisplay().asyncExec(() -> {
                String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Install Failed", (String)descr, (IStatus)multistatus);
            });
            return;
        }
        if (multistatus.isOK()) return;
        N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
        UIUtils.getDisplay().asyncExec(() -> {
            String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
            ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Install Failed", (String)descr, (IStatus)multistatus);
        });
    }

    private /* synthetic */ void lambda$1(String string, NPMVersionRequirement nPMVersionRequirement, File file, MultiStatus multiStatus, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Map<N4JSProjectName, NPMVersionRequirement> singletonMap = Collections.singletonMap(new N4JSProjectName(string), nPMVersionRequirement);
        try {
            FileURI projectRootURI = new FileURI(file);
            IStatus status = this.libManager.installNPMs(singletonMap, false, projectRootURI, monitor);
            multiStatus.merge(status);
        }
        finally {
            this.updateLocations.run();
        }
    }
}

