/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.classes;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.wizard.classes.N4JSClassWizardModel;
import org.eclipse.n4js.ui.wizard.classifiers.N4JSNewClassifierWizardGenerator;
import org.eclipse.n4js.ui.wizard.generator.ImportRequirement;
import org.eclipse.n4js.ui.wizard.generator.N4JSImportRequirementResolver;
import org.eclipse.n4js.ui.wizard.generator.WizardGeneratorHelper;
import org.eclipse.n4js.ui.wizard.model.ClassifierReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class N4JSNewClassWizardGenerator
extends N4JSNewClassifierWizardGenerator<N4JSClassWizardModel> {
    @Inject
    @Extension
    private WizardGeneratorHelper generatorUtils;

    @Override
    protected String generateClassifierCode(N4JSClassWizardModel model, Map<URI, String> aliasBindings) {
        int _length;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isFinalAnnotated = model.isFinalAnnotated();
        if (_isFinalAnnotated) {
            _builder.append("@Final");
        }
        _builder.newLineIfNotEmpty();
        boolean _isN4jsAnnotated = model.isN4jsAnnotated();
        if (_isN4jsAnnotated) {
            _builder.append("@N4JS");
        }
        _builder.newLineIfNotEmpty();
        boolean _isInternal = model.isInternal();
        if (_isInternal) {
            _builder.append("@Internal ");
        }
        String _addSpace = this.generatorUtils.addSpace(this.generatorUtils.exportStatement(model.getAccessModifier()));
        _builder.append(_addSpace);
        boolean _isDefinitionFile = model.isDefinitionFile();
        if (_isDefinitionFile) {
            _builder.append("external ");
        }
        String _addSpace_1 = this.generatorUtils.addSpace(model.getAccessModifier().toCodeRepresentation());
        _builder.append(_addSpace_1);
        _builder.append("class ");
        String _name = model.getName();
        _builder.append(_name);
        boolean _isComplete = model.getSuperClass().isComplete();
        if (_isComplete) {
            _builder.append(" extends ");
            String _realOrAliasName = this.generatorUtils.realOrAliasName(model.getSuperClass(), aliasBindings);
            _builder.append(_realOrAliasName);
        }
        boolean bl = _greaterThan = (_length = ((Object[])Conversions.unwrapArray(model.getInterfaces(), Object.class)).length) > 0;
        if (_greaterThan) {
            _builder.append(" implements ");
        }
        List<ClassifierReference> _interfaces = model.getInterfaces();
        boolean _hasElements = false;
        for (ClassifierReference iface : _interfaces) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _realOrAliasName_1 = this.generatorUtils.realOrAliasName(iface, aliasBindings);
            _builder.append(_realOrAliasName_1);
        }
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    @Override
    protected List<IN4JSProject> getReferencedProjects(N4JSClassWizardModel model) {
        Functions.Function1 _function = it -> this.generatorUtils.projectOfUri(it.uri);
        List _map = ListExtensions.map(model.getInterfaces(), (Functions.Function1)_function);
        ArrayList<IN4JSProject> referencedProjects = new ArrayList<IN4JSProject>(_map);
        boolean _isComplete = model.getSuperClass().isComplete();
        if (_isComplete) {
            referencedProjects.add(this.generatorUtils.projectOfUri(model.getSuperClass().uri));
        }
        return referencedProjects;
    }

    @Override
    protected List<ImportRequirement> getImportRequirements(N4JSClassWizardModel model) {
        boolean _isEmpty;
        boolean _not;
        ArrayList<ImportRequirement> _xblockexpression = null;
        ArrayList<ImportRequirement> demandedImports = new ArrayList<ImportRequirement>();
        boolean _isComplete = model.getSuperClass().isComplete();
        if (_isComplete) {
            demandedImports.add(N4JSImportRequirementResolver.classifierReferenceToImportRequirement(model.getSuperClass()));
        }
        boolean bl = _not = !(_isEmpty = model.getInterfaces().isEmpty());
        if (_not) {
            demandedImports.addAll(N4JSImportRequirementResolver.classifierReferencesToImportRequirements(model.getInterfaces()));
        }
        _xblockexpression = demandedImports;
        return _xblockexpression;
    }
}

