/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server.commands;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.n4js.external.LibraryChange;
import org.eclipse.n4js.external.NpmCLI;
import org.eclipse.n4js.ide.imports.ImportDescriptor;
import org.eclipse.n4js.ide.imports.ImportHelper;
import org.eclipse.n4js.ide.imports.ImportOrganizer;
import org.eclipse.n4js.ide.imports.ReferenceResolution;
import org.eclipse.n4js.ide.server.codeActions.N4JSCodeActionService;
import org.eclipse.n4js.ide.xtext.server.ExecuteCommandParamsDescriber;
import org.eclipse.n4js.ide.xtext.server.XDocument;
import org.eclipse.n4js.ide.xtext.server.XLanguageServerImpl;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.Semver.SemverToStringable;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.semver.SemverUtils;
import org.eclipse.n4js.semver.model.SemverSerializer;
import org.eclipse.n4js.smith.CollectedDataAccess;
import org.eclipse.n4js.smith.DataCollectorUtils;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;
import org.eclipse.xtext.ide.server.commands.IExecutableCommandService;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;

public class N4JSCommandService
implements IExecutableCommandService,
ExecuteCommandParamsDescriber {
    public static final String N4JS_REBUILD = "n4js.rebuild";
    public static final String N4JS_ORGANIZE_IMPORTS = "n4js.organizeImports";
    public static final String COMPOSITE_FIX_FILE = "n4js.composite.fix.file";
    public static final String COMPOSITE_FIX_PROJECT = "n4js.composite.fix.project";
    public static final String ENABLE_PERFORMANCE_COLLECTOR = "n4js.performance.collector.enable";
    public static final String DISABLE_PERFORMANCE_COLLECTOR = "n4js.performance.collector.disable";
    public static final String SHOW_PERFORMANCE_DATA = "n4js.performance.collector.show";
    public static final String RESET_PERFORMANCE_DATA = "n4js.performance.collector.reset";
    @Inject
    private XLanguageServerImpl lspServer;
    @Inject
    private XWorkspaceManager workspaceManager;
    @Inject
    private UriExtensions uriExtensions;
    @Inject
    private N4JSCodeActionService codeActionService;
    @Inject
    private NpmCLI npmCli;
    @Inject
    private SemverHelper semverHelper;
    @Inject
    private ImportHelper importHelper;
    @Inject
    private ImportOrganizer importOrganizer;
    private Map<String, CommandHandler> handlers;
    private Map<String, Type[]> argumentTypes;

    public List<String> initialize() {
        Method[] methods = this.getClass().getMethods();
        HashMap<String, CommandHandler> localHandlers = new HashMap<String, CommandHandler>();
        HashMap<String, Type[]> localArgumentTypes = new HashMap<String, Type[]>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            ExecutableCommandHandler annotation = method.getAnnotation(ExecutableCommandHandler.class);
            if (annotation != null) {
                List<Type> parameterTypes = Arrays.asList(method.getGenericParameterTypes());
                Type[] args = (Type[])parameterTypes.subList(0, parameterTypes.size() - 2).toArray(Type[]::new);
                localArgumentTypes.put(annotation.value(), args);
                localHandlers.put(annotation.value(), new CommandHandler(method));
            }
            ++n2;
        }
        this.handlers = localHandlers;
        this.argumentTypes = localArgumentTypes;
        return Lists.newArrayList(localHandlers.keySet());
    }

    @Override
    public Map<String, Type[]> argumentTypes() {
        return (Map)Preconditions.checkNotNull(this.argumentTypes);
    }

    public Object execute(ExecuteCommandParams params, ILanguageServerAccess access, CancelIndicator cancelIndicator) {
        return this.handlers.get(params.getCommand()).execute(params, access, cancelIndicator);
    }

    @ExecutableCommandHandler(value="n4js.rebuild")
    public Void rebuild(ILanguageServerAccess access, CancelIndicator cancelIndicator) {
        this.lspServer.clean();
        this.lspServer.reinitWorkspace();
        return null;
    }

    @ExecutableCommandHandler(value="n4js.performance.collector.enable")
    public Void enablePerformanceDataCollector(ILanguageServerAccess access, CancelIndicator cancelIndicator) {
        CollectedDataAccess.setPaused((boolean)false);
        access.getLanguageClient().logMessage(new MessageParams(MessageType.Log, "Enabled performance data collectors"));
        return null;
    }

    @ExecutableCommandHandler(value="n4js.performance.collector.disable")
    public Void disablePerformanceDataCollector(ILanguageServerAccess access, CancelIndicator cancelIndicator) {
        CollectedDataAccess.setPaused((boolean)true);
        access.getLanguageClient().logMessage(new MessageParams(MessageType.Log, "Disabled performance data collectors"));
        return null;
    }

    @ExecutableCommandHandler(value="n4js.performance.collector.show")
    public Void showPerformanceDataCollector(ILanguageServerAccess access, CancelIndicator cancelIndicator) {
        access.getLanguageClient().logMessage(new MessageParams(MessageType.Log, DataCollectorUtils.allDataToString((String)"  ")));
        return null;
    }

    @ExecutableCommandHandler(value="n4js.performance.collector.reset")
    public Void resetPerformanceDataCollector(ILanguageServerAccess access, CancelIndicator cancelIndicator) {
        access.getLanguageClient().logMessage(new MessageParams(MessageType.Log, DataCollectorUtils.allDataToString((String)"  ")));
        access.getLanguageClient().logMessage(new MessageParams(MessageType.Log, "Reset collected performance data"));
        CollectedDataAccess.resetAllData();
        return null;
    }

    @ExecutableCommandHandler(value="n4js.composite.fix.file")
    public Void fixAllInFile(String title, String code, String fixId, CodeActionParams codeActionParams, ILanguageServerAccess access, CancelIndicator cancelIndicator) {
        ICodeActionService2.Options options = this.lspServer.toOptions(codeActionParams, cancelIndicator);
        WorkspaceEdit edit = this.codeActionService.applyToFile(code, fixId, options);
        access.getLanguageClient().applyEdit(new ApplyWorkspaceEditParams(edit, title));
        return null;
    }

    @ExecutableCommandHandler(value="n4js.composite.fix.project")
    public Void fixAllInProject(String title, String code, String fixId, CodeActionParams codeActionParams, ILanguageServerAccess access, CancelIndicator cancelIndicator) {
        ICodeActionService2.Options options = this.lspServer.toOptions(codeActionParams, cancelIndicator);
        WorkspaceEdit edit = this.codeActionService.applyToProject(code, fixId, options);
        access.getLanguageClient().applyEdit(new ApplyWorkspaceEditParams(edit, title));
        return null;
    }

    @ExecutableCommandHandler(value="json.install.npm")
    public Void installNpm(String packageName, String version, String fileUri, ILanguageServerAccess access, CancelIndicator cancelIndicator) {
        this.lspServer.getRequestManager().runWrite("InstallNpm", () -> {
            NPMVersionRequirement versionRequirement = this.semverHelper.parse(version);
            if (versionRequirement == null) {
                versionRequirement = SemverUtils.createEmptyVersionRequirement();
            }
            String normalizedVersion = SemverSerializer.serialize((SemverToStringable)versionRequirement);
            N4JSProjectName projectName = new N4JSProjectName(packageName);
            LibraryChange change = new LibraryChange(LibraryChange.LibraryChangeType.Install, null, projectName, normalizedVersion);
            MultiStatus multiStatus = new MultiStatus("json", 1, null, null);
            FileURI targetProject = (FileURI)new FileURI(URI.createURI((String)fileUri)).getParent();
            this.npmCli.batchInstall((IProgressMonitor)new NullProgressMonitor(), multiStatus, Arrays.asList(change), targetProject);
            return multiStatus;
        }, (ci, ms) -> {
            MessageParams messageParams = new MessageParams();
            switch (ms.getSeverity()) {
                case 1: {
                    messageParams.setType(MessageType.Info);
                    break;
                }
                case 2: {
                    messageParams.setType(MessageType.Warning);
                    break;
                }
                case 4: {
                    messageParams.setType(MessageType.Error);
                    break;
                }
                default: {
                    return null;
                }
            }
            StringWriter sw = new StringWriter();
            PrintWriter printWriter = new PrintWriter(sw);
            IStatus[] iStatusArray = ms.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                if (child.getSeverity() == ms.getSeverity()) {
                    printWriter.println(child.getMessage());
                }
                ++n2;
            }
            printWriter.flush();
            messageParams.setMessage(sw.toString());
            access.getLanguageClient().showMessage(messageParams);
            return null;
        }).whenComplete((a, b) -> {
            CompletableFuture<Void> completableFuture = this.lspServer.reinitWorkspace();
        });
        return null;
    }

    @ExecutableCommandHandler(value="n4js.organizeImports")
    public Void organizeImports(String uriString, ILanguageServerAccess access, CancelIndicator cancelIndicator) {
        URI uri = this.uriExtensions.toUri(uriString);
        XtextResource resource = this.workspaceManager.getResource(uri);
        if (!(resource instanceof N4JSResource)) {
            return null;
        }
        Script script = ((N4JSResource)resource).getScript();
        XDocument document = this.workspaceManager.getDocument(resource);
        ArrayList<ImportDescriptor> importsToBeAdded = new ArrayList<ImportDescriptor>();
        List<ReferenceResolution> resolutions = this.importHelper.findResolutionsForAllUnresolvedReferences(script, cancelIndicator);
        for (ReferenceResolution resolution : resolutions) {
            if (resolution.importToBeAdded == null) continue;
            importsToBeAdded.add(resolution.importToBeAdded);
        }
        List<TextEdit> edits = this.importOrganizer.organizeImports(document, script, importsToBeAdded, cancelIndicator);
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonMap(uriString, edits));
        ApplyWorkspaceEditParams params = new ApplyWorkspaceEditParams(workspaceEdit, "Organize Imports");
        access.getLanguageClient().applyEdit(params);
        return null;
    }

    private class CommandHandler {
        private final Method method;

        private CommandHandler(Method method) {
            this.method = method;
        }

        private Object execute(ExecuteCommandParams params, ILanguageServerAccess access, CancelIndicator cancelIndicator) {
            ArrayList<Object> actualArguments = new ArrayList<Object>();
            actualArguments.addAll(params.getArguments());
            actualArguments.add(access);
            actualArguments.add(cancelIndicator);
            try {
                return this.method.invoke((Object)N4JSCommandService.this, actualArguments.toArray());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface ExecutableCommandHandler {
        public String value();
    }
}

