/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.n4js.utils.Diff;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;

public abstract class DiffBuilder<F, T> {
    @VisibleForTesting
    protected final List<T> oldItems;
    @VisibleForTesting
    protected final List<T> oldAllItems;
    @VisibleForTesting
    protected final List<T> addedItems;
    @VisibleForTesting
    protected final List<T> deletedItems;
    @VisibleForTesting
    protected final BiMap<T, T> editedItems;
    private final F input;

    public DiffBuilder(F input) {
        this.input = input;
        this.oldItems = (List)Conversions.doWrapArray(this.getOldItemsFunction().apply(this.input));
        this.oldAllItems = (List)Conversions.doWrapArray(this.getAllOldItemsFunction().apply(this.input));
        boolean _containsAll = this.oldAllItems.containsAll(this.oldItems);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Not all old items is not a subset of all old items. Old items: ");
        _builder.append(this.oldItems);
        _builder.append(". All old items: ");
        _builder.append(this.oldAllItems);
        _builder.append(".");
        Preconditions.checkState((boolean)_containsAll, (Object)_builder);
        this.addedItems = CollectionLiterals.newArrayList();
        this.deletedItems = CollectionLiterals.newArrayList();
        this.editedItems = HashBiMap.create();
    }

    public DiffBuilder<F, T> add(T item) {
        if (!this.oldAllItems.contains(item) && !this.addedItems.contains(item)) {
            this.addedItems.add(item);
        }
        this.deletedItems.remove(item);
        return this;
    }

    public DiffBuilder<F, T> delete(T item) {
        int index = this.addedItems.indexOf(item);
        if (index >= 0) {
            this.addedItems.remove(index);
        } else {
            Object originalItem = this.editedItems.inverse().remove(item);
            this.deletedItems.add(originalItem);
        }
        return this;
    }

    public DiffBuilder<F, T> edit(T oldState, T newState) {
        int index = this.addedItems.indexOf(oldState);
        if (index >= 0) {
            this.addedItems.remove(index);
            this.addedItems.add(index, newState);
        } else {
            Object originalState = this.editedItems.inverse().get(oldState);
            if (originalState != null) {
                this.editedItems.put(originalState, newState);
            } else {
                this.editedItems.put(oldState, newState);
            }
        }
        return this;
    }

    public Diff<T> build(T[] newItems, T[] newAllItems) {
        return new Diff<Object>((T[])((Object[])Conversions.unwrapArray(this.oldItems, Object.class)), (T[])((Object[])Conversions.unwrapArray(this.oldAllItems, Object.class)), (T[])((Object[])Conversions.unwrapArray(this.addedItems, Object.class)), (T[])((Object[])Conversions.unwrapArray(this.deletedItems, Object.class)), (Map<Object, Object>)this.editedItems, newItems, newAllItems);
    }

    protected F getInput() {
        return this.input;
    }

    protected abstract Function<F, T[]> getOldItemsFunction();

    protected abstract Function<F, T[]> getAllOldItemsFunction();
}

