/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public abstract class Strings {
    public static final String toString(Iterable<? extends Object> iterable) {
        return Strings.toString(Object::toString, iterable);
    }

    public static final <A, T extends Exception> String toString(FunctionWithException<A, String, T> accessor, Iterable<A> iterable) throws T {
        return "[" + Strings.join(", ", accessor, iterable) + "]";
    }

    public static final String join(String delimiter, Iterable<? extends Object> iterable) {
        return Strings.join(delimiter, Object::toString, iterable);
    }

    public static final String join(String delimiter, Object ... objects) {
        return Strings.join(delimiter, Object::toString, objects);
    }

    @SafeVarargs
    public static final <A, T extends Exception> String join(String delimiter, FunctionWithException<A, String, T> accessor, A ... objects) throws T {
        return Strings.join(delimiter, accessor, Arrays.asList(objects));
    }

    public static final <A, T extends Exception> String join(String delimiter, FunctionWithException<A, String, T> accessor, Iterable<A> iterable) throws T {
        if (iterable == null || delimiter == null || accessor == null) {
            return "";
        }
        String str = "";
        Iterator<A> it = iterable.iterator();
        while (it.hasNext()) {
            A t = it.next();
            str = String.valueOf(str) + (t == null ? "" : accessor.apply(t));
            if (!it.hasNext()) continue;
            str = String.valueOf(str) + delimiter;
        }
        return str;
    }

    public static final <K, V> String toString(Map<K, V> map) {
        return Strings.toString(map, Object::toString);
    }

    public static final <K, V, T extends Exception> String toString(Map<K, V> map, FunctionWithException<V, String, T> valueAccessor) throws T {
        return Strings.toString(map, Object::toString, valueAccessor);
    }

    public static final <K, V, T extends Exception> String toString(Map<K, V> map, FunctionWithException<K, String, T> keyAccessor, FunctionWithException<V, String, T> valueAccessor) throws T {
        return Strings.toString(", ", map, keyAccessor, valueAccessor);
    }

    public static final <K, V, T extends Exception> String toString(String delimiter, Map<K, V> map, FunctionWithException<K, String, T> keyAccessor, FunctionWithException<V, String, T> valueAccessor) throws T {
        if (map == null || delimiter == null || keyAccessor == null || valueAccessor == null) {
            return "";
        }
        String str = "";
        Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, V> e = it.next();
            str = String.valueOf(str) + keyAccessor.apply(e.getKey()) + " -> " + valueAccessor.apply(e.getValue());
            if (!it.hasNext()) continue;
            str = String.valueOf(str) + delimiter;
        }
        return str;
    }

    public static final String fromLines(String ... lines) {
        return String.valueOf(Joiner.on((String)System.lineSeparator()).join((Object[])lines)) + System.lineSeparator();
    }

    public static interface FunctionWithException<A, R, T extends Exception> {
        public R apply(A var1) throws T;
    }
}

