/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.n4js.jsdoc2spec.adoc.FileSystem;
import org.eclipse.xtext.xbase.lib.Pair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class Html2ADocConverter {
    private static final Map<String, String> htmlElementsToADoc = new HashMap<String, String>();
    private static final Map<String, String> entitiesToADoc = new HashMap<String, String>();
    private static final char ENTITY_START = '&';
    private static final char TAG_START = '<';
    private static final char TAG_END = '>';
    private static final char QUOTE = '\"';
    private static final char TAG_END_MARK = '/';
    private static final String VISIT_REGION = "\u00ab";
    private static DocumentBuilder XMLBUILDER = Html2ADocConverter.initBuilder();
    private static String XMLPROLOG = "<?xml version=\"1.0\"?>";

    static {
        htmlElementsToADoc.put("tex", VISIT_REGION);
        htmlElementsToADoc.put("/tex", "--");
        htmlElementsToADoc.put("p", String.valueOf(FileSystem.NL) + FileSystem.NL);
        htmlElementsToADoc.put("/p", String.valueOf(FileSystem.NL) + FileSystem.NL);
        htmlElementsToADoc.put("br", String.valueOf(FileSystem.NL) + FileSystem.NL);
        htmlElementsToADoc.put("/br", String.valueOf(FileSystem.NL) + FileSystem.NL);
        htmlElementsToADoc.put("ol", String.valueOf(FileSystem.NL) + FileSystem.NL);
        htmlElementsToADoc.put("/ol", "");
        htmlElementsToADoc.put("ul", String.valueOf(FileSystem.NL) + FileSystem.NL);
        htmlElementsToADoc.put("/ul", "");
        htmlElementsToADoc.put("li", "* ");
        htmlElementsToADoc.put("/li", "");
        htmlElementsToADoc.put("dl", String.valueOf(FileSystem.NL) + "...." + FileSystem.NL);
        htmlElementsToADoc.put("/dl", String.valueOf(FileSystem.NL) + "...." + FileSystem.NL);
        htmlElementsToADoc.put("dt", "* ");
        htmlElementsToADoc.put("/dt", "");
        htmlElementsToADoc.put("dd", "");
        htmlElementsToADoc.put("/dd", "");
        htmlElementsToADoc.put("em", VISIT_REGION);
        htmlElementsToADoc.put("/em", "##");
        htmlElementsToADoc.put("b", VISIT_REGION);
        htmlElementsToADoc.put("/b", "**");
        htmlElementsToADoc.put("i", VISIT_REGION);
        htmlElementsToADoc.put("/i", "__");
        htmlElementsToADoc.put("pre", VISIT_REGION);
        htmlElementsToADoc.put("/pre", "++");
        htmlElementsToADoc.put("code", VISIT_REGION);
        htmlElementsToADoc.put("/code", "--``");
        htmlElementsToADoc.put("cite", VISIT_REGION);
        htmlElementsToADoc.put("/cite", "");
        htmlElementsToADoc.put("quote", VISIT_REGION);
        htmlElementsToADoc.put("/quote", "__");
        entitiesToADoc.put("&lt;", "<");
        entitiesToADoc.put("&gt;", ">");
        entitiesToADoc.put("&quot;", "\"");
        entitiesToADoc.put("&amp;", "&");
    }

    private static DocumentBuilder initBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException exc) {
            throw new RuntimeException(exc);
        }
    }

    public String escADocInLabel(String s) {
        String newS = s.replaceAll("[^\\\\]]", "\\\\]");
        return newS;
    }

    public String passThenMonospace(CharSequence cs) {
        return this.monospace(this.pass(cs));
    }

    public String monospace(CharSequence cs) {
        return "``" + cs + "``";
    }

    public String pass(CharSequence cs) {
        if (cs == null) {
            return null;
        }
        return this.pass(cs.toString());
    }

    private String pass(String s) {
        return "++" + s + "++";
    }

    public CharSequence transformHTML(CharSequence html) {
        StringBuilder strb = new StringBuilder();
        this.transformHTML(html, 0, strb, new LinkedList<String>(), "");
        return strb;
    }

    private int transformHTML(CharSequence html, int startRegionIdx, StringBuilder strb, List<String> tagStack, String myTagRegion) {
        int length = html.length();
        int i = startRegionIdx;
        while (i < length) {
            char c = html.charAt(i);
            switch (c) {
                case '&': {
                    i = this.replaceEntities(html, strb, i, c);
                    break;
                }
                case '<': {
                    boolean isClosingMyRegion;
                    boolean isCloseTag = false;
                    int tagStart = i;
                    while (i + 1 < length && Character.isWhitespace(html.charAt(i + 1))) {
                        ++i;
                    }
                    if (i + 1 < length && html.charAt(i + 1) == '/') {
                        isCloseTag = true;
                        ++i;
                    }
                    Pair<Element, Integer> elementWithOffset = Html2ADocConverter.parseHTMLElement(html, i);
                    int tagEnd = (Integer)elementWithOffset.getValue();
                    i = tagEnd - 1;
                    Element element = (Element)elementWithOffset.getKey();
                    String adocString = null;
                    String elementName = null;
                    if (element != null) {
                        String tagName = elementName = element.getNodeName();
                        if (isCloseTag) {
                            tagName = "/" + tagName;
                        }
                        adocString = htmlElementsToADoc.get(tagName);
                    }
                    if (isCloseTag && elementName != null && (isClosingMyRegion = myTagRegion.equals(elementName))) {
                        return i;
                    }
                    if (adocString == null) {
                        strb.append(html.subSequence(tagStart, tagEnd));
                        break;
                    }
                    if (adocString == VISIT_REGION) {
                        String[] tags = this.getADocTags(element, html, tagEnd);
                        strb.append(tags[0]);
                        tagStack.add(0, this.getADocTagName(tags[0]));
                        i = this.transformHTML(html, tagEnd, strb, tagStack, elementName);
                        tagStack.remove(0);
                        strb.append(tags[1]);
                        break;
                    }
                    strb.append(adocString);
                    break;
                }
                default: {
                    strb.append(c);
                }
            }
            ++i;
        }
        return i;
    }

    private String getADocTagName(String openTag) {
        String adocTagName = openTag.replace("\\[(\\w*),.*\\]", "$1");
        if (adocTagName == null || adocTagName.length() == 0) {
            adocTagName = openTag;
        }
        return adocTagName;
    }

    private String[] getADocTags(Element element, CharSequence html, int regionStart) {
        char charRegionStart = html.charAt(regionStart);
        boolean lastIsNewline = charRegionStart == '\n';
        switch (element.getTagName()) {
            case "quote": {
                boolean hasAuthor;
                String author = element.getAttribute("author");
                boolean bl = hasAuthor = author != null && author.length() > 0;
                if (lastIsNewline) {
                    if (hasAuthor) {
                        return new String[]{"\n[verse," + this.escADocInLabel(author) + "]" + FileSystem.NL + "--", String.valueOf(FileSystem.NL) + "--" + FileSystem.NL};
                    }
                    return new String[]{"\n[verse]" + FileSystem.NL + "--", String.valueOf(FileSystem.NL) + "--" + FileSystem.NL};
                }
                if (hasAuthor) {
                    return new String[]{"__", "__ [" + this.escADocInLabel(author) + "]"};
                }
                return new String[]{"__", "__"};
            }
            case "cite": {
                boolean hasTitle;
                String title = element.getAttribute("title");
                boolean bl = hasTitle = title != null && title.length() > 0;
                if (hasTitle) {
                    return new String[]{"cite:[", "(" + this.escADocInLabel(title) + ")]"};
                }
                return new String[]{"cite:[", "]"};
            }
            case "code": {
                boolean hasClass;
                String clazz = element.getAttribute("class");
                boolean bl = hasClass = clazz != null && clazz.length() > 0;
                if (lastIsNewline) {
                    if (hasClass) {
                        return new String[]{"\n[source," + clazz + "]" + FileSystem.NL + "--", String.valueOf(FileSystem.NL) + "--" + FileSystem.NL};
                    }
                    return new String[]{"\n[source,n4js]" + FileSystem.NL + "--", String.valueOf(FileSystem.NL) + "--" + FileSystem.NL};
                }
                return new String[]{"``++", "++``"};
            }
            case "tex": {
                return new String[]{"", ""};
            }
            case "pre": {
                boolean hasClass;
                String clazz = element.getAttribute("class");
                boolean bl = hasClass = clazz != null && clazz.length() > 0;
                if (lastIsNewline) {
                    if (hasClass) {
                        return new String[]{"\n[source," + clazz + "]" + FileSystem.NL + "--", String.valueOf(FileSystem.NL) + "--" + FileSystem.NL};
                    }
                    return new String[]{"\n[source]" + FileSystem.NL + "--", String.valueOf(FileSystem.NL) + "--" + FileSystem.NL};
                }
                return new String[]{"++", "++"};
            }
            case "em": {
                return new String[]{"##", "##"};
            }
            case "b": {
                return new String[]{"**", "**"};
            }
            case "i": {
                return new String[]{"__", "__"};
            }
        }
        return null;
    }

    private int replaceEntities(CharSequence html, StringBuilder s, int i, char c) {
        int offset = i;
        String entity = Html2ADocConverter.find(html, entitiesToADoc.keySet(), offset);
        if (entity != null) {
            i += entity.length() - 1;
            s.append(entitiesToADoc.get(entity));
        } else {
            s.append(c);
        }
        return i;
    }

    private static Pair<Element, Integer> parseHTMLElement(CharSequence html, int offset) {
        int maxLength = html.length();
        int pos = offset + 1;
        boolean inString = false;
        while (pos < maxLength && Character.isWhitespace(html.charAt(pos))) {
            ++pos;
        }
        int tagNameStart = pos;
        while (pos < maxLength && Character.isAlphabetic(html.charAt(pos))) {
            ++pos;
        }
        CharSequence tagName = html.subSequence(tagNameStart, pos);
        if (!htmlElementsToADoc.containsKey(tagName)) {
            return Pair.of(null, (Object)pos);
        }
        int c = 32;
        while (pos < maxLength && (c != 62 || inString)) {
            c = html.charAt(pos);
            if (c == 34) {
                inString = !inString;
            }
            ++pos;
        }
        int endOffset = pos--;
        if (c == 62) {
            // empty if block
        }
        if (pos - offset < 1) {
            return Pair.of(null, (Object)endOffset);
        }
        String tagContent = html.subSequence(offset + 1, pos).toString();
        String strTagWithAttributes = "<" + tagContent + (tagContent.endsWith("/") ? ">" : "/>");
        String xmlFragment = String.valueOf(XMLPROLOG) + strTagWithAttributes;
        try {
            Document doc = XMLBUILDER.parse(new InputSource(new ByteArrayInputStream(xmlFragment.getBytes("utf-8"))));
            Element element = doc.getDocumentElement();
            return Pair.of((Object)element, (Object)endOffset);
        }
        catch (Exception exception) {
            return Pair.of(null, (Object)endOffset);
        }
    }

    private static String find(CharSequence html, Iterable<String> searchStrings, int offset) {
        int length = html.length();
        for (String s : searchStrings) {
            int k = s.length();
            if (k + offset > length) continue;
            while (--k >= 0 && Character.toLowerCase(html.charAt(offset + k)) == s.charAt(k)) {
            }
            if (k >= 0) continue;
            return s;
        }
        return null;
    }
}

