/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.IllegalBinaryStateException;
import org.eclipse.n4js.binaries.nodejs.NpmBinary;
import org.eclipse.n4js.binaries.nodejs.YarnBinary;
import org.eclipse.n4js.external.ExternalIndexSynchronizer;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.ExternalProject;
import org.eclipse.n4js.external.LibraryChange;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.external.NpmCLI;
import org.eclipse.n4js.external.NpmLogger;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.PlatformResourceURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.Semver.SemverToStringable;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.semver.SemverUtils;
import org.eclipse.n4js.semver.model.SemverSerializer;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.smith.N4JSDataCollectors;
import org.eclipse.n4js.utils.NodeModulesDiscoveryHelper;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.StatusUtils;

@Singleton
public class LibraryManager {
    private static final Logger LOGGER = Logger.getLogger(LibraryManager.class);
    private static final NPMVersionRequirement NO_VERSION_REQUIREMENT = SemverUtils.createEmptyVersionRequirement();
    @Inject
    private ExternalLibraryWorkspace externalLibraryWorkspace;
    @Inject
    private StatusHelper statusHelper;
    @Inject
    private Provider<NpmBinary> npmBinaryProvider;
    @Inject
    private Provider<YarnBinary> yarnBinaryProvider;
    @Inject
    private NpmLogger logger;
    @Inject
    private NpmCLI npmCli;
    @Inject
    private ExternalIndexSynchronizer indexSynchronizer;
    @Inject
    private SemverHelper semverHelper;
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private ExternalLibraryPreferenceStore extLibPreferenceStore;
    @Inject
    private NodeModulesDiscoveryHelper nodeModulesDiscoveryHelper;

    public void synchronizeNpms(IProgressMonitor monitor) {
        this.indexSynchronizer.synchronizeNpms(monitor);
    }

    public IStatus deleteAllNodeModulesFolders(IProgressMonitor monitor) {
        MultiStatus multistatus = this.statusHelper.createMultiStatus("Delete all node_modules folders");
        for (SafeURI safeURI : this.extLibPreferenceStore.getNodeModulesLocations()) {
            if (safeURI.exists()) {
                safeURI.delete(ioe -> multistatus.merge(this.statusHelper.createError("Exception during deletion of the npm folder.", (Throwable)ioe)));
            }
            if (!safeURI.exists()) continue;
            multistatus.merge(this.statusHelper.createError("Could not verify deletion of " + safeURI.getAbsolutePath()));
        }
        this.externalLibraryWorkspace.updateState();
        this.indexSynchronizer.synchronizeNpms(monitor);
        return multistatus;
    }

    public IStatus runNpmYarnInstall(PlatformResourceURI target, IProgressMonitor monitor) {
        IN4JSProject project = (IN4JSProject)this.n4jsCore.findProject(target.toURI()).orNull();
        File projectFolder = project.getLocation().toJavaIoFile();
        boolean usingYarn = this.npmCli.isYarnUsed(projectFolder);
        String msg = "Running '" + (usingYarn ? "yarn" : "npm") + " install' on " + project.getProjectName();
        MultiStatus status = this.statusHelper.createMultiStatus(msg);
        this.logger.logInfo(msg);
        IStatus binaryStatus = this.checkBinary(usingYarn);
        if (!binaryStatus.isOK()) {
            status.merge(binaryStatus);
            return status;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        SubMonitor subMonitor1 = subMonitor.split(1);
        subMonitor1.setTaskName("Building installed packages...");
        NodeModulesDiscoveryHelper.NodeModulesFolder nmf = this.nodeModulesDiscoveryHelper.getNodeModulesFolder(projectFolder.toPath());
        File nmfFile = nmf.isYarnWorkspace() ? nmf.workspaceNodeModulesFolder : nmf.localNodeModulesFolder;
        File folderInWhichToExecute = nmfFile.getParentFile();
        this.npmCli.runNpmYarnInstall(folderInWhichToExecute);
        SubMonitor subMonitor2 = subMonitor.split(1);
        subMonitor2.setTaskName("Registering packages...");
        this.indexSynchronizer.reindexAllExternalProjects((IProgressMonitor)subMonitor2);
        return status;
    }

    public IStatus runNpmYarnInstallOnAllProjects(IProgressMonitor monitor) {
        IStatus iStatus;
        IStatus iStatus2;
        String msg = "Running 'npm/yarn install' on all projects";
        MultiStatus status = this.statusHelper.createMultiStatus(msg);
        this.logger.logInfo(msg);
        Iterable<? extends IN4JSProject> allProjects = this.n4jsCore.findAllProjects();
        LinkedHashSet<File> yarnWorkspaceRoots = new LinkedHashSet<File>();
        ArrayList<IN4JSProject> projectsOutsideAnyYarnWorkspace = new ArrayList<IN4JSProject>();
        for (IN4JSProject iN4JSProject : allProjects) {
            if (!iN4JSProject.exists()) continue;
            Path projectPath = iN4JSProject.getLocation().toFileSystemPath();
            NodeModulesDiscoveryHelper.NodeModulesFolder nodeModulesFolder = this.nodeModulesDiscoveryHelper.getNodeModulesFolder(projectPath);
            if (nodeModulesFolder.isYarnWorkspace()) {
                yarnWorkspaceRoots.add(nodeModulesFolder.workspaceNodeModulesFolder.getParentFile());
                continue;
            }
            projectsOutsideAnyYarnWorkspace.add(iN4JSProject);
        }
        if (!yarnWorkspaceRoots.isEmpty() && !(iStatus2 = this.checkBinary(true)).isOK()) {
            status.merge(iStatus2);
        }
        if (!projectsOutsideAnyYarnWorkspace.isEmpty() && !(iStatus = this.checkBinary(false)).isOK()) {
            status.merge(iStatus);
        }
        if (!status.isOK()) {
            return status;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + yarnWorkspaceRoots.size() + projectsOutsideAnyYarnWorkspace.size()));
        for (File yarnWorkspaceRoot : yarnWorkspaceRoots) {
            msg = "Running 'yarn install' on yarn workspace root " + yarnWorkspaceRoot;
            SubMonitor subMonitorInstall = subMonitor.split(1);
            subMonitorInstall.setTaskName(msg);
            this.logger.logInfo(msg);
            IStatus currStatus = this.npmCli.runNpmYarnInstall(yarnWorkspaceRoot);
            status.merge(currStatus);
        }
        for (IN4JSProject project : projectsOutsideAnyYarnWorkspace) {
            File projectFolder = project.getLocation().toJavaIoFile();
            boolean usingYarn = this.npmCli.isYarnUsed(projectFolder);
            msg = "Running '" + (usingYarn ? "yarn" : "npm") + " install' on " + project.getProjectName();
            SubMonitor subMonitorInstall = subMonitor.split(1);
            subMonitorInstall.setTaskName(msg);
            this.logger.logInfo(msg);
            IStatus currStatus = this.npmCli.runNpmYarnInstall(projectFolder);
            status.merge(currStatus);
        }
        SubMonitor subMonitorRegisterNpms = subMonitor.split(1);
        subMonitorRegisterNpms.setTaskName("Registering packages...");
        this.indexSynchronizer.reindexAllExternalProjects((IProgressMonitor)subMonitorRegisterNpms);
        return status;
    }

    public IStatus installNPM(N4JSProjectName packageName, FileURI target, IProgressMonitor monitor) {
        return this.installNPM(packageName, NO_VERSION_REQUIREMENT, target, monitor);
    }

    public IStatus installNPM(N4JSProjectName packageName, String packageVersionStr, FileURI target, IProgressMonitor monitor) {
        NPMVersionRequirement packageVersion = this.semverHelper.parse(packageVersionStr);
        if (packageVersion == null) {
            throw new IllegalArgumentException("unable to parse version requirement: " + packageVersionStr);
        }
        return this.installNPM(packageName, packageVersion, target, monitor);
    }

    public IStatus installNPM(N4JSProjectName packageName, NPMVersionRequirement packageVersion, FileURI target, IProgressMonitor monitor) {
        return this.installNPMs(Collections.singletonMap(packageName, packageVersion), false, target, monitor);
    }

    public IStatus installNPMs(Collection<N4JSProjectName> unversionedPackages, FileURI target, IProgressMonitor monitor) {
        Map<N4JSProjectName, NPMVersionRequirement> versionedPackages = unversionedPackages.stream().collect(Collectors.toMap(name -> name, name -> NO_VERSION_REQUIREMENT));
        return this.installNPMs(versionedPackages, false, target, monitor);
    }

    public IStatus installNPMs(Map<N4JSProjectName, NPMVersionRequirement> versionedNPMs, boolean forceReloadAll, FileURI target, IProgressMonitor monitor) {
        return this.runWithWorkspaceLock(() -> this.installNPMsInternal(versionedNPMs, forceReloadAll, target, monitor));
    }

    /*
     * Exception decompiling
     */
    private IStatus installNPMsInternal(Map<N4JSProjectName, NPMVersionRequirement> versionedNPMs, boolean forceReloadAll, FileURI target, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getMessage(Map<N4JSProjectName, NPMVersionRequirement> versionedNPMs) {
        String msg = "Installing NPM(s): ";
        Iterator<Map.Entry<N4JSProjectName, NPMVersionRequirement>> entryIter = versionedNPMs.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry<N4JSProjectName, NPMVersionRequirement> entry = entryIter.next();
            msg = String.valueOf(msg) + entry.getKey();
            NPMVersionRequirement versionRequirement = entry.getValue();
            if (versionRequirement != null && !SemverUtils.isEmptyVersionRequirement((NPMVersionRequirement)versionRequirement)) {
                msg = String.valueOf(msg) + "@" + versionRequirement;
            }
            if (!entryIter.hasNext()) continue;
            msg = String.valueOf(msg) + ", ";
        }
        return msg;
    }

    private List<LibraryChange> installNPMs(IProgressMonitor monitor, MultiStatus status, Map<N4JSProjectName, NPMVersionRequirement> installRequested, FileURI target) {
        LinkedList<LibraryChange> actualChanges = new LinkedList<LibraryChange>();
        Throwable throwable = null;
        Object var7_8 = null;
        try (Measurement m = N4JSDataCollectors.dcNpmInstall.getMeasurement("batchInstall");){
            LinkedList<LibraryChange> requestedChanges = new LinkedList<LibraryChange>();
            for (Map.Entry<N4JSProjectName, NPMVersionRequirement> reqestedNpm : installRequested.entrySet()) {
                N4JSProjectName name = reqestedNpm.getKey();
                NPMVersionRequirement requestedVersion = reqestedNpm.getValue();
                String requestedVersionStr = SemverSerializer.serialize((SemverToStringable)requestedVersion);
                requestedChanges.add(new LibraryChange(LibraryChange.LibraryChangeType.Install, null, name, requestedVersionStr));
            }
            actualChanges.addAll(this.npmCli.batchInstall(monitor, status, requestedChanges, target));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return actualChanges;
    }

    public IStatus uninstallNPM(N4JSProjectName npmName, IProgressMonitor monitor) {
        List<N4JSExternalProject> npmProjects = this.externalLibraryWorkspace.getProjectsForName(npmName);
        MultiStatus multiStatus = this.statusHelper.createMultiStatus("Uninstall all npms with the name: " + npmName);
        for (N4JSExternalProject npm : npmProjects) {
            IStatus status = this.uninstallNPM(npm.getSafeLocation(), monitor);
            multiStatus.merge(status);
        }
        return multiStatus;
    }

    /*
     * Exception decompiling
     */
    public IStatus uninstallNPM(FileURI packageURI, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private FileURI getParentOfMatchingLocation(FileURI uri, Predicate<? super String> predicate) {
        while (uri != null && !predicate.test(uri.getName())) {
            uri = (FileURI)uri.getParent();
        }
        if (uri != null) {
            return (FileURI)uri.getParent();
        }
        return null;
    }

    public IStatus registerAllExternalProjects(IProgressMonitor monitor) {
        return this.runWithWorkspaceLock(() -> this.registerAllExternalProjectsInternal(monitor));
    }

    private IStatus registerAllExternalProjectsInternal(IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)monitor, (Object)"monitor");
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            MultiStatus refreshStatus = this.statusHelper.createMultiStatus("Refreshing npm type definitions.");
            this.indexSynchronizer.reindexAllExternalProjects((IProgressMonitor)subMonitor.split(1));
            MultiStatus multiStatus = refreshStatus;
            return multiStatus;
        }
        finally {
            subMonitor.done();
        }
    }

    public IStatus registerUnregisteredNpms(IProgressMonitor monitor) {
        return this.runWithWorkspaceLock(() -> this.registerUnregisteredNpmsInternal(monitor));
    }

    private IStatus registerUnregisteredNpmsInternal(IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)monitor, (Object)"monitor");
        MultiStatus refreshStatus = this.statusHelper.createMultiStatus("Register not registered NPM(s).");
        LinkedList<N4JSExternalProject> unregisteredProjects = new LinkedList<N4JSExternalProject>();
        for (N4JSExternalProject p : this.externalLibraryWorkspace.getProjects()) {
            if (this.indexSynchronizer.isInIndex(p)) continue;
            unregisteredProjects.add(p);
        }
        this.indexSynchronizer.synchronizeNpms(monitor);
        Set<String> packageNames = this.getAllNpmProjectsMapping().keySet();
        if (packageNames.isEmpty()) {
            return this.statusHelper.OK();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            this.indexSynchronizer.reindexAllExternalProjects((IProgressMonitor)subMonitor.split(1));
            MultiStatus multiStatus = refreshStatus;
            return multiStatus;
        }
        finally {
            subMonitor.done();
        }
    }

    private IStatus checkBinary(boolean usingYarn) {
        Binary binary = (Binary)(usingYarn ? this.yarnBinaryProvider : this.npmBinaryProvider).get();
        IStatus binaryStatus = binary.validate();
        if (!binaryStatus.isOK()) {
            return this.statusHelper.createError(String.valueOf(binary.getLabel()) + " binary invalid: " + StatusUtils.getErrorMessage(binaryStatus, false), (Throwable)((Object)new IllegalBinaryStateException(binary, binaryStatus)));
        }
        return this.statusHelper.OK();
    }

    private Map<String, URI> getAllNpmProjectsMapping() {
        HashMap mappings = Maps.newHashMap();
        for (IProject iProject : this.externalLibraryWorkspace.getProjects()) {
            if (!iProject.isAccessible() || !(iProject instanceof ExternalProject)) continue;
            URI location = ((ExternalProject)iProject).getExternalResource().toURI();
            mappings.put(iProject.getName(), location);
        }
        return ImmutableMap.copyOf((Map)mappings);
    }

    private IStatus runWithWorkspaceLock(Supplier<IStatus> operation) {
        if (Platform.isRunning()) {
            IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
            try {
                Job.getJobManager().beginRule((ISchedulingRule)rule, null);
                IStatus iStatus = operation.get();
                return iStatus;
            }
            catch (OperationCanceledException e) {
                LOGGER.info((Object)"User cancelled operation.");
                IStatus iStatus = this.statusHelper.createCancel("User cancelled operation.");
                return iStatus;
            }
            finally {
                Job.getJobManager().endRule((ISchedulingRule)rule);
            }
        }
        return operation.get();
    }

    private static /* synthetic */ boolean lambda$4(String name) {
        return "node_modules".equals(name);
    }
}

