/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import java.util.Comparator;
import java.util.List;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class XDocument
extends Document {
    private final int version;
    private final String contents;
    private final boolean printSourceOnError;
    private final boolean isDirty;
    private static final Comparator<TextEdit> textEditComparator = Comparator.comparing(edit -> edit.getRange().getStart().getLine()).thenComparing(edit -> edit.getRange().getStart().getCharacter()).reversed();

    public XDocument(int version, String contents) {
        this(version, contents, true, false);
    }

    public XDocument(int version, String contents, boolean printSourceOnError, boolean isDirty) {
        super(Integer.valueOf(version), contents, true);
        this.version = version;
        this.contents = contents;
        this.printSourceOnError = printSourceOnError;
        this.isDirty = isDirty;
    }

    public int getOffSet(Position position) throws IndexOutOfBoundsException {
        int l = this.contents.length();
        char NL = '\n';
        int line = 0;
        int column = 0;
        int i = 0;
        while (i < l) {
            char ch = this.contents.charAt(i);
            if (position.getLine() == line && position.getCharacter() == column) {
                return i;
            }
            if (ch == NL) {
                ++line;
                column = 0;
            } else {
                ++column;
            }
            ++i;
        }
        if (position.getLine() == line && position.getCharacter() == column) {
            return l;
        }
        throw new IndexOutOfBoundsException(String.valueOf(position.toString()) + (this.printSourceOnError ? "" : " text was : " + this.contents));
    }

    public Position getPosition(int offset) throws IndexOutOfBoundsException {
        int l = this.contents.length();
        if (offset < 0 || offset > l) {
            throw new IndexOutOfBoundsException(String.valueOf(offset) + (this.printSourceOnError ? "" : " text was : " + this.contents));
        }
        char NL = '\n';
        int line = 0;
        int column = 0;
        int i = 0;
        while (i < l) {
            char ch = this.contents.charAt(i);
            if (i == offset) {
                return new Position(line, column);
            }
            if (ch == NL) {
                ++line;
                column = 0;
            } else {
                ++column;
            }
            ++i;
        }
        return new Position(line, column);
    }

    public String getLineContent(int lineNumber) throws IndexOutOfBoundsException {
        if (lineNumber < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(lineNumber) + (this.printSourceOnError ? "" : " text was : " + this.contents));
        }
        char NL = '\n';
        int l = this.contents.length();
        StringBuilder lineContent = new StringBuilder();
        int line = 0;
        int i = 0;
        while (i < l) {
            if (line > lineNumber) {
                return lineContent.toString();
            }
            char ch = this.contents.charAt(i);
            if (line == lineNumber && ch != NL) {
                lineContent.append(ch);
            }
            if (ch == NL) {
                ++line;
            }
            ++i;
        }
        if (line < lineNumber) {
            throw new IndexOutOfBoundsException(String.valueOf(lineNumber) + (this.printSourceOnError ? "" : " text was : " + this.contents));
        }
        return lineContent.toString();
    }

    public int getLineCount() {
        return this.getPosition(this.contents.length()).getLine() + 1;
    }

    public String getSubstring(Range range) {
        int start = this.getOffSet(range.getStart());
        int end = this.getOffSet(range.getEnd());
        return this.contents.substring(start, end);
    }

    public XDocument applyTextDocumentChanges(Iterable<? extends TextDocumentContentChangeEvent> changes) {
        XDocument currentDocument = this;
        int newVersion = currentDocument.version + 1;
        for (TextDocumentContentChangeEvent textDocumentContentChangeEvent : changes) {
            String newContent;
            Range range = textDocumentContentChangeEvent.getRange();
            if (range == null) {
                newContent = textDocumentContentChangeEvent.getText();
            } else {
                int start = currentDocument.getOffSet(range.getStart());
                int end = currentDocument.getOffSet(range.getEnd());
                String oldContents = currentDocument.contents;
                newContent = String.valueOf(oldContents.substring(0, start)) + textDocumentContentChangeEvent.getText() + oldContents.substring(end);
            }
            currentDocument = new XDocument(newVersion, newContent, this.printSourceOnError, true);
        }
        return currentDocument;
    }

    public XDocument applyChanges(Iterable<? extends TextEdit> changes) {
        List changesSorted = IterableExtensions.sortWith(changes, textEditComparator);
        String newContent = this.contents;
        for (TextEdit change : changesSorted) {
            if (change.getRange() == null) {
                newContent = change.getNewText();
                continue;
            }
            int start = this.getOffSet(change.getRange().getStart());
            int end = this.getOffSet(change.getRange().getEnd());
            newContent = String.valueOf(newContent.substring(0, start)) + change.getNewText() + newContent.substring(end);
        }
        XDocument document = new XDocument(this.version + 1, newContent, true, true);
        return document;
    }

    public String getContents() {
        return this.contents;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isPrintSourceOnError() {
        return this.printSourceOnError;
    }

    public XDocument save() {
        return new XDocument(this.version, this.contents, this.printSourceOnError, false);
    }
}

