/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4EnumLiteral;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4JSFactory;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TransformationDependency;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.es.assistants.ReflectionAssistant;
import org.eclipse.n4js.transpiler.es.transform.ClassDeclarationTransformation;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ImFactory;
import org.eclipse.n4js.transpiler.im.ParameterizedTypeRef_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryIMOnly;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@TransformationDependency.RequiresAfter(value={ClassDeclarationTransformation.class})
public class EnumDeclarationTransformation
extends Transformation {
    @Inject
    private ReflectionAssistant reflectionAssistant;
    @Inject
    private TypeAssistant typeAssistant;
    private SymbolTableEntry n4EnumSTE;

    public void assertPreConditions() {
        Functions.Function1 _function = it -> {
            boolean _isTopLevel = this.typeAssistant.isTopLevel((TypeDefiningElement)it);
            return !_isTopLevel;
        };
        this.assertFalse("only top-level enums are supported, for now", IteratorExtensions.exists((Iterator)Iterators.filter((Iterator)this.getState().im.eAllContents(), N4EnumDeclaration.class), (Functions.Function1)_function));
    }

    public void assertPostConditions() {
        Functions.Function1 _function = it -> it instanceof N4EnumDeclaration;
        this.assertFalse("there should not be any N4EnumDeclarations in the intermediate model", IteratorExtensions.exists((Iterator)this.getState().im.eAllContents(), (Functions.Function1)_function));
    }

    public void analyze() {
        this.n4EnumSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)RuleEnvironmentExtensions.n4EnumType((RuleEnvironment)this.getState().G), true);
        if (this.n4EnumSTE == null) {
            throw new IllegalStateException("could not find required members of built-in types");
        }
    }

    public void transform() {
        Consumer<N4EnumDeclaration> _function = it -> this.transformEnumDecl((N4EnumDeclaration)it);
        this.collectNodes((EObject)this.getState().im, N4EnumDeclaration.class, false).forEach(_function);
    }

    private void transformEnumDecl(N4EnumDeclaration enumDecl) {
        boolean _isStringBased = this.isStringBased(enumDecl);
        if (_isStringBased) {
            EObject root = TranspilerUtils.orContainingExportDeclaration((EObject)enumDecl);
            this.remove(root);
            return;
        }
        N4ClassDeclaration classDecl = N4JSFactory.eINSTANCE.createN4ClassDeclaration();
        classDecl.setName(enumDecl.getName());
        SymbolTableEntryIMOnly classSTE = this.createSymbolTableEntryIMOnly((NamedElement)classDecl);
        Functions.Function1 _function = it -> this.convertLiteralToField((N4EnumLiteral)it, (SymbolTableEntry)classSTE);
        List fieldsForLiterals = ListExtensions.map((List)enumDecl.getLiterals(), (Functions.Function1)_function);
        EList _declaredModifiers = classDecl.getDeclaredModifiers();
        EList _declaredModifiers_1 = enumDecl.getDeclaredModifiers();
        Iterables.addAll((Collection)_declaredModifiers, (Iterable)_declaredModifiers_1);
        ParameterizedTypeRef_IM _createParameterizedTypeRef_IM = ImFactory.eINSTANCE.createParameterizedTypeRef_IM();
        Procedures.Procedure1 _function_1 = it -> it.setDeclaredType_IM(this.n4EnumSTE);
        ParameterizedTypeRef_IM _doubleArrow = (ParameterizedTypeRef_IM)ObjectExtensions.operator_doubleArrow((Object)_createParameterizedTypeRef_IM, (Procedures.Procedure1)_function_1);
        classDecl.setSuperClassRef((ParameterizedTypeRef)_doubleArrow);
        EList _ownedMembersRaw = classDecl.getOwnedMembersRaw();
        N4MethodDeclaration _createEnumConstructor = this.createEnumConstructor();
        _ownedMembersRaw.add((Object)_createEnumConstructor);
        EList _ownedMembersRaw_1 = classDecl.getOwnedMembersRaw();
        Iterables.addAll((Collection)_ownedMembersRaw_1, (Iterable)fieldsForLiterals);
        EList _ownedMembersRaw_2 = classDecl.getOwnedMembersRaw();
        Functions.Function1 _function_2 = it -> TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)classSTE, (SymbolTableEntry[])new SymbolTableEntry[]{this.findSymbolTableEntryForElement((NamedElement)it, true)});
        N4FieldDeclaration __N4FieldDecl = TranspilerBuilderBlocks._N4FieldDecl((boolean)true, (String)"literals", (Expression)TranspilerBuilderBlocks._ArrLit((Expression[])((Expression[])Conversions.unwrapArray((Object)ListExtensions.map((List)fieldsForLiterals, (Functions.Function1)_function_2), Expression.class))));
        _ownedMembersRaw_2.add((Object)__N4FieldDecl);
        this.reflectionAssistant.addN4TypeGetter((N4TypeDeclaration)enumDecl, (N4ClassifierDeclaration)classDecl);
        this.getState().tracer.copyTrace((EObject)enumDecl, new EObject[]{classDecl});
        this.replace(enumDecl, classDecl);
    }

    private N4MethodDeclaration createEnumConstructor() {
        FormalParameter nameFpar = TranspilerBuilderBlocks._Fpar((String)"name");
        FormalParameter valueFpar = TranspilerBuilderBlocks._Fpar((String)"value");
        SymbolTableEntryIMOnly nameSTE = this.createSymbolTableEntryIMOnly((NamedElement)nameFpar);
        SymbolTableEntryIMOnly valueSTE = this.createSymbolTableEntryIMOnly((NamedElement)valueFpar);
        ExpressionStatement __ExprStmnt = TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._SuperLiteral(), (Expression[])new Expression[]{TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)nameSTE), TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)valueSTE)}));
        return TranspilerBuilderBlocks._N4MethodDecl((String)"constructor", (FormalParameter[])new FormalParameter[]{nameFpar, valueFpar}, (Statement[])new Statement[]{__ExprStmnt});
    }

    private N4FieldDeclaration convertLiteralToField(N4EnumLiteral literal, SymbolTableEntry classSTE) {
        boolean _tripleNotEquals;
        IdentifierRef_IM __IdentRef = TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)classSTE);
        StringLiteral __StringLiteral = TranspilerBuilderBlocks._StringLiteral((String)literal.getName());
        StringLiteral _xifexpression = null;
        String _value = literal.getValue();
        boolean bl = _tripleNotEquals = _value != null;
        if (_tripleNotEquals) {
            _xifexpression = TranspilerBuilderBlocks._StringLiteral((String)literal.getValue());
        }
        return TranspilerBuilderBlocks._N4FieldDecl((boolean)true, (String)literal.getName(), (Expression)TranspilerBuilderBlocks._NewExpr((Expression)__IdentRef, (Expression[])new Expression[]{__StringLiteral, _xifexpression}));
    }

    private boolean isStringBased(N4EnumDeclaration enumDecl) {
        return AnnotationDefinition.STRING_BASED.hasAnnotation((AnnotableElement)enumDecl);
    }
}

