/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.setup;

import com.google.common.base.Joiner;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.state.XpectStateAnnotation;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xtext.resource.XtextResource;

@XpectStateAnnotation
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@XpectImport(value={ThisModelFactory.class})
public @interface ThisModel {

    @XpectSetupFactory
    public static class ThisModelFactory {
        private final XtextResource resource;

        public ThisModelFactory(@ThisResource XtextResource resource) {
            this.resource = resource;
        }

        @Creates(value=ThisModel.class)
        public EObject createThisModel() {
            EList contents = this.resource.getContents();
            if (contents.isEmpty()) {
                StringBuilder error = new StringBuilder();
                error.append("Resource has no contents.\n");
                error.append("URI: " + this.resource.getURI() + "\n");
                if (!this.resource.getErrors().isEmpty()) {
                    error.append("Errors:\n");
                    Joiner.on((String)"\n").appendTo(error, (Iterable)this.resource.getErrors());
                }
                throw new IllegalStateException(error.toString());
            }
            return (EObject)contents.get(0);
        }
    }
}

