/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4JS;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PropertyNameKind implements Enumerator
{
    IDENTIFIER(0, "identifier", "identifier"),
    STRING(0, "string", "string"),
    NUMBER(0, "number", "number"),
    COMPUTED(0, "computed", "computed");

    public static final int IDENTIFIER_VALUE = 0;
    public static final int STRING_VALUE = 0;
    public static final int NUMBER_VALUE = 0;
    public static final int COMPUTED_VALUE = 0;
    private static final PropertyNameKind[] VALUES_ARRAY;
    public static final List<PropertyNameKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PropertyNameKind[]{IDENTIFIER, STRING, NUMBER, COMPUTED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PropertyNameKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PropertyNameKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PropertyNameKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PropertyNameKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PropertyNameKind get(int value) {
        switch (value) {
            case 0: {
                return IDENTIFIER;
            }
        }
        return null;
    }

    private PropertyNameKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

