/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.parser;

import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.eclipse.n4js.parser.JSTokenList;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.parser.antlr.Lexer;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;

public class LazyTokenStream
extends XtextTokenStream {
    private int myLookAhead;
    private int indexOfLookAhead;
    private int markerCount = 0;

    public void consume() {
        if (this.markerCount > 0) {
            this.basicConsume();
        } else {
            this.basicConsume();
            --this.myLookAhead;
        }
    }

    void basicConsume() {
        if (this.p < this.tokens.size()) {
            ++this.p;
            this.p = this.skipOffTokenChannels(this.p);
        }
    }

    public int LA(int i) {
        Token lookaheadToken = this.LT(i);
        if (this.markerCount > 0) {
            if (Token.EOF_TOKEN == lookaheadToken) {
                if (this.indexOfLookAhead != this.size()) {
                    this.indexOfLookAhead = this.size();
                    ++this.myLookAhead;
                }
            } else {
                int laTokenIndex = lookaheadToken.getTokenIndex();
                if (this.indexOfLookAhead < laTokenIndex) {
                    this.indexOfLookAhead = laTokenIndex;
                    ++this.myLookAhead;
                }
            }
        } else {
            this.myLookAhead = Math.max(i, this.myLookAhead);
        }
        return lookaheadToken.getType();
    }

    public int mark() {
        int result = this.basicMark();
        if (this.markerCount == 0 && this.indexOfLookAhead < this.p) {
            this.indexOfLookAhead = this.p;
        }
        ++this.markerCount;
        return result;
    }

    int basicMark() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        this.lastMarker = this.index();
        return this.lastMarker;
    }

    public void seek(int index) {
        this.basicSeek(index);
    }

    public void rewind(int marker) {
        --this.markerCount;
        this.basicSeek(marker);
    }

    void basicSeek(int index) {
        this.p = index;
    }

    protected int getFirstMarker() {
        throw new UnsupportedOperationException();
    }

    public int getCurrentLookAhead() {
        return this.myLookAhead;
    }

    public void initCurrentLookAhead(int currentLookAhead) {
        this.myLookAhead = currentLookAhead;
    }

    public LazyTokenStream(TokenSource tokenSource, ITokenDefProvider tokenDefProvider) {
        super(tokenSource, tokenDefProvider);
        this.tokens = new JSTokenList();
    }

    public String toString() {
        return this.tokenSource.toString();
    }

    protected void fillBuffer() {
        int oldP = this.p;
        int index = this.tokens.size();
        Token t = this.tokenSource.nextToken();
        while (t != null && t.getType() != -1) {
            Integer channelI;
            int type = t.getType();
            if (type == 99 || type == 73 || type == 112) {
                t.setTokenIndex(index);
                this.tokens.add(t);
                ++index;
                break;
            }
            boolean discard = false;
            if (this.channelOverrideMap != null && (channelI = (Integer)this.channelOverrideMap.get(type)) != null) {
                t.setChannel(channelI.intValue());
            }
            if (this.discardSet != null && this.discardSet.contains(type)) {
                discard = true;
            } else if (this.discardOffChannelTokens && t.getChannel() != this.channel) {
                discard = true;
            }
            if (!discard) {
                t.setTokenIndex(index);
                this.tokens.add(t);
                ++index;
            }
            t = this.tokenSource.nextToken();
        }
        this.p = oldP == -1 ? 0 : oldP;
        this.p = this.skipOffTokenChannels(this.p);
    }

    public void fillBuffer(int lookAhead) {
        if (this.p + lookAhead - 1 >= this.tokens.size()) {
            this.fillBuffer();
        }
    }

    public Token LT(int k) {
        this.fillBuffer(k);
        return super.LT(k);
    }

    public String toString(int start, int stop) {
        if (start < 0 || stop < 0) {
            return null;
        }
        CommonToken startToken = (CommonToken)this.tokens.get(start);
        CommonToken stopToken = (CommonToken)this.tokens.get(stop);
        CharStream charStream = ((Lexer)this.tokenSource).getCharStream();
        String result = charStream.toString().substring(startToken.getStartIndex(), stopToken.getStopIndex());
        return result;
    }
}

