/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.common.collect.ForwardingMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.resource.N4JSEObjectDescription;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.resource.UserDataMapper;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TConstableElement;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeAccessModifier;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.util.IAcceptor;

@Singleton
public class N4JSResourceDescriptionStrategy
extends DefaultResourceDescriptionStrategy {
    public static final String MAIN_MODULE_KEY = "MAIN_MODULE";
    private static final boolean MAIN_MODULE_DEFAULT = false;
    private static final String TYPE_ACCESS_MODIFIER_KEY = "TYPE_ACCESS_MODIFIER";
    private static final TypeAccessModifier TYPE_ACCESS_MODIFIER_DEFAULT = TypeAccessModifier.PUBLIC;
    private static final String CONST_KEY = "CONST";
    private static final boolean CONST_DEFAULT = false;
    private static final String FINAL_KEY = "FINAL";
    private static final boolean FINAL_DEFAULT = false;
    private static final String ABSTRACT_KEY = "ABSTRACT";
    private static final boolean ABSTRACT_DEFAULT = false;
    private static final String TEST_CLASS_KEY = "TEST_CLASS";
    private static final boolean TEST_CLASS_DEFAULT = false;
    private static final String POLYFILL_KEY = "POLYFILL";
    private static final boolean POLYFILL_DEFAULT = false;
    private static final String EXPORTED_CLASS_KEY = "EXPORTED_CLASS";
    private static final boolean EXPORTED_CLASS_DEFAULT = false;
    private static final String STATIC_POLYFILL_KEY = "STATIC_POLYFILL";
    private static final boolean STATIC_POLYFILL_DEFAULT = false;
    private static final String EXPORT_DEFAULT_KEY = "EXPORTED_DEFAULT";
    private static final boolean EXPORT_DEFAULT_DEFAULT = false;
    private static final String VERSION = "VERSION";
    private static final int VERSION_DEFAULT = 0;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;

    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        if (this.getQualifiedNameProvider() == null) {
            return false;
        }
        if (eObject instanceof TModule) {
            TModule module = (TModule)eObject;
            this.internalCreateEObjectDescriptionForRoot(module, acceptor);
            for (Type type : module.getTopLevelTypes()) {
                this.internalCreateEObjectDescription(type, acceptor);
            }
            for (TVariable variable : module.getVariables()) {
                this.internalCreateEObjectDescription(variable, acceptor);
            }
        }
        return false;
    }

    public static boolean getMainModule(IEObjectDescription description) {
        String userData = description.getUserData(MAIN_MODULE_KEY);
        if (userData == null) {
            return false;
        }
        return Boolean.parseBoolean(userData);
    }

    public static boolean getFinal(IEObjectDescription description) {
        String userData = description.getUserData(FINAL_KEY);
        if (userData == null) {
            return false;
        }
        return Boolean.parseBoolean(userData);
    }

    public static boolean getAbstract(IEObjectDescription description) {
        String userData = description.getUserData(ABSTRACT_KEY);
        if (userData == null) {
            return false;
        }
        return Boolean.parseBoolean(userData);
    }

    public static boolean getTestClass(IEObjectDescription description) {
        String userData = description.getUserData(TEST_CLASS_KEY);
        if (userData == null) {
            return false;
        }
        return Boolean.parseBoolean(userData);
    }

    public static boolean getExported(IEObjectDescription description) {
        String userData = description.getUserData(EXPORTED_CLASS_KEY);
        if (userData == null) {
            return false;
        }
        return Boolean.parseBoolean(userData);
    }

    public static boolean getPolyfill(IEObjectDescription description) {
        String userData = description.getUserData(POLYFILL_KEY);
        if (userData == null) {
            return false;
        }
        return Boolean.parseBoolean(userData);
    }

    public static boolean getStaticPolyfill(IEObjectDescription description) {
        String userData = description.getUserData(STATIC_POLYFILL_KEY);
        if (userData == null) {
            return false;
        }
        return Boolean.parseBoolean(userData);
    }

    public static boolean getExportDefault(IEObjectDescription description) {
        String userData = description.getUserData(EXPORT_DEFAULT_KEY);
        if (userData == null) {
            return false;
        }
        return Boolean.parseBoolean(userData);
    }

    public static TypeAccessModifier getTypeAccessModifier(IEObjectDescription description) {
        try {
            String userData = description.getUserData(TYPE_ACCESS_MODIFIER_KEY);
            if (userData == null) {
                return TYPE_ACCESS_MODIFIER_DEFAULT;
            }
            return TypeAccessModifier.get((int)Integer.parseInt(userData));
        }
        catch (NumberFormatException e) {
            return TYPE_ACCESS_MODIFIER_DEFAULT;
        }
    }

    public static boolean getConst(IEObjectDescription description) {
        String value = description.getUserData(CONST_KEY);
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public static int getVersion(IEObjectDescription description) {
        String userData;
        block3: {
            try {
                userData = description.getUserData(VERSION);
                if (userData != null) break block3;
                return 0;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return Integer.parseInt(userData);
    }

    private void internalCreateEObjectDescriptionForRoot(TModule module, IAcceptor<IEObjectDescription> acceptor) {
        Map<String, String> userData = this.createModuleUserData(module);
        QualifiedName qualifiedName = this.qualifiedNameProvider.getFullyQualifiedName((EObject)module);
        EObjectDescription eod = new EObjectDescription(qualifiedName, (EObject)module, userData);
        acceptor.accept((Object)eod);
    }

    private Map<String, String> createModuleUserData(final TModule module) {
        if (module.isPreLinkingPhase()) {
            return UserDataMapper.createTimestampUserData(module);
        }
        return new ForwardingMap<String, String>(){
            private Map<String, String> delegate;

            protected Map<String, String> delegate() {
                if (this.delegate == null) {
                    try {
                        this.delegate = UserDataMapper.createUserData(module);
                        N4JSResource resource = (N4JSResource)module.eResource();
                        UserDataMapper.writeDependenciesToUserData(resource, this.delegate);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                return this.delegate;
            }
        };
    }

    private void internalCreateEObjectDescription(Type type, IAcceptor<IEObjectDescription> acceptor) {
        QualifiedName qualifiedName;
        String typeName;
        String exportedName = type.getExportedName();
        String string = typeName = exportedName != null ? exportedName : type.getName();
        if (typeName != null && typeName.length() != 0 && (qualifiedName = this.qualifiedNameProvider.getFullyQualifiedName((EObject)type)) != null) {
            HashMap<String, String> userData = new HashMap<String, String>();
            this.addAccessModifierUserData(userData, type.getTypeAccessModifier());
            this.addVersionableVersion(userData, type);
            if (type instanceof TClass) {
                TClass tClass = (TClass)type;
                this.addClassUserData(userData, tClass);
                if ("default".equals(tClass.getExportedName())) {
                    userData.put(EXPORT_DEFAULT_KEY, Boolean.toString(true));
                }
            } else if ("default".equals(type.getExportedName())) {
                userData.put(EXPORT_DEFAULT_KEY, Boolean.toString(true));
            }
            IEObjectDescription eod = N4JSEObjectDescription.create(qualifiedName, (EObject)type, userData);
            acceptor.accept((Object)eod);
        }
    }

    private void addAccessModifierUserData(Map<String, String> userData, TypeAccessModifier typeAccessModifier) {
        if (TYPE_ACCESS_MODIFIER_DEFAULT != typeAccessModifier) {
            userData.put(TYPE_ACCESS_MODIFIER_KEY, String.valueOf(typeAccessModifier.getValue()));
        }
    }

    private void addConstUserData(Map<String, String> userData, TConstableElement element) {
        boolean isConst = element.isConst();
        if (isConst) {
            userData.put(CONST_KEY, Boolean.toString(isConst));
        }
    }

    private void addVersionableVersion(Map<String, String> userData, Type type) {
        int version = type.getVersion();
        if (version != 0) {
            userData.put(VERSION, String.valueOf(version));
        }
    }

    private void internalCreateEObjectDescription(TVariable variable, IAcceptor<IEObjectDescription> acceptor) {
        QualifiedName qualifiedName = this.qualifiedNameProvider.getFullyQualifiedName((EObject)variable);
        if (qualifiedName != null) {
            HashMap<String, String> userData = new HashMap<String, String>();
            this.addAccessModifierUserData(userData, variable.getTypeAccessModifier());
            this.addConstUserData(userData, (TConstableElement)variable);
            IEObjectDescription eod = EObjectDescription.create((QualifiedName)qualifiedName, (EObject)variable, userData);
            acceptor.accept((Object)eod);
        }
    }

    private void addClassUserData(Map<String, String> userData, TClass tClass) {
        if (tClass.isExported()) {
            userData.put(EXPORTED_CLASS_KEY, Boolean.toString(tClass.isExported()));
        }
        if (tClass.isAbstract()) {
            userData.put(ABSTRACT_KEY, Boolean.toString(tClass.isAbstract()));
        }
        if (tClass.isFinal()) {
            userData.put(FINAL_KEY, Boolean.toString(tClass.isFinal()));
        }
        if (tClass.isPolyfill()) {
            userData.put(POLYFILL_KEY, Boolean.toString(tClass.isPolyfill()));
        }
        if (tClass.isStaticPolyfill()) {
            userData.put(STATIC_POLYFILL_KEY, Boolean.toString(tClass.isStaticPolyfill()));
        }
        boolean hasTestMethod = false;
        for (TMember member : tClass.getOwnedMembers()) {
            if (!(member instanceof TMethod) || !AnnotationDefinition.TEST_METHOD.hasAnnotation((TAnnotableElement)member)) continue;
            hasTestMethod = true;
            break;
        }
        if (hasTestMethod) {
            userData.put(TEST_CLASS_KEY, Boolean.toString(hasTestMethod));
        }
    }
}

