/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.editor.contentassist;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.n4js.ide.editor.contentassist.ContentAssistDataCollectors;
import org.eclipse.n4js.ide.editor.contentassist.ImportsAwareReferenceProposalCreator;
import org.eclipse.n4js.n4JS.JSXElement;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.ts.scoping.N4TSQualifiedNameProvider;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;

public class N4JSIdeContentProposalProvider
extends IdeContentProposalProvider {
    @Inject
    private N4JSGrammarAccess n4jsGrammarAccess;
    @Inject
    private ImportsAwareReferenceProposalCreator importsAwareReferenceProposalCreator;
    @Inject
    private ContentAssistDataCollectors dataCollectors;

    public void createProposals(Collection<ContentAssistContext> contexts, IIdeContentProposalAcceptor acceptor) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Measurement m = this.dataCollectors.dcCreateProposalsInner().getMeasurement();){
            super.createProposals(contexts, acceptor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void _createProposals(CrossReference crossReference, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        String featureName;
        if (context.getCurrentModel() == null || context.getCurrentModel().eIsProxy()) {
            return;
        }
        ParserRule containingParserRule = GrammarUtil.containingParserRule((EObject)crossReference);
        if (containingParserRule != this.n4jsGrammarAccess.getTypeReferenceRule() && (featureName = GrammarUtil.containingAssignment((EObject)crossReference).getFeature()).equals(TypeRefsPackage.eINSTANCE.getParameterizedTypeRef_DeclaredType().getName())) {
            this.lookupCrossReference(TypeRefsPackage.eINSTANCE.getParameterizedTypeRef_DeclaredType(), context, acceptor, new N4JSCandidateFilter());
        }
        if (!GrammarUtil.isDatatypeRule((ParserRule)containingParserRule)) {
            EReference ref = containingParserRule.isWildcard() ? GrammarUtil.getReference((CrossReference)crossReference, (EClass)context.getCurrentModel().eClass()) : GrammarUtil.getReference((CrossReference)crossReference);
            if (ref == null && containingParserRule == this.n4jsGrammarAccess.getTypeReferenceRule()) {
                String featureName2 = GrammarUtil.containingAssignment((EObject)crossReference).getFeature();
                if (featureName2.equals(TypeRefsPackage.Literals.PARAMETERIZED_TYPE_REF__DECLARED_TYPE.getName())) {
                    ref = TypeRefsPackage.Literals.PARAMETERIZED_TYPE_REF__DECLARED_TYPE;
                } else if (featureName2.equals(TypeRefsPackage.Literals.PARAMETERIZED_TYPE_REF__AST_NAMESPACE.getName())) {
                    ref = TypeRefsPackage.eINSTANCE.getParameterizedTypeRef_AstNamespace();
                }
            }
            if (ref != null) {
                this.lookupCrossReference(ref, context, acceptor, new N4JSCandidateFilter());
            }
        }
    }

    protected void _createProposals(Keyword keyword, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        EObject currentModel = context.getCurrentModel();
        EObject previousModel = context.getPreviousModel();
        if (currentModel instanceof ParameterizedPropertyAccessExpression || previousModel instanceof ParameterizedPropertyAccessExpression) {
            return;
        }
        if (currentModel instanceof JSXElement || previousModel instanceof JSXElement) {
            return;
        }
        if (!Character.isAlphabetic(keyword.getValue().charAt(0))) {
            return;
        }
        if (keyword.getValue().length() < 5) {
            return;
        }
        super._createProposals(keyword, context, acceptor);
    }

    protected void _createProposals(Assignment assignment, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        AbstractElement terminal = assignment.getTerminal();
        if (terminal instanceof CrossReference) {
            this.createProposals(terminal, context, acceptor);
        }
    }

    protected void lookupCrossReference(EReference reference, ContentAssistContext context, IIdeContentProposalAcceptor acceptor, Predicate<IEObjectDescription> filter) {
        if (reference.getEReferenceType().isSuperTypeOf(TypesPackage.Literals.TYPE) || TypesPackage.Literals.TYPE.isSuperTypeOf(reference.getEReferenceType())) {
            EObject model = context.getCurrentModel();
            this.importsAwareReferenceProposalCreator.lookupCrossReference(model, reference, context, acceptor, filter);
        }
    }

    public static class N4JSCandidateFilter
    implements Predicate<IEObjectDescription> {
        public boolean apply(IEObjectDescription candidate) {
            QualifiedName qualifiedName = candidate.getQualifiedName();
            IEObjectDescription eObjectDescription = candidate;
            boolean valid = true;
            valid &= !IEObjectDescriptionWithError.isErrorDescription((IEObjectDescription)eObjectDescription);
            valid &= !N4TSQualifiedNameProvider.GLOBAL_NAMESPACE_SEGMENT.equals(qualifiedName.getFirstSegment());
            valid &= !N4TSQualifiedNameProvider.isModulePolyfill((QualifiedName)qualifiedName);
            return valid &= !N4TSQualifiedNameProvider.isPolyfill((QualifiedName)qualifiedName);
        }
    }
}

