/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server.codeActions.util;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.ide.server.codeActions.util.ChangeProvider;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.ModifiableElement;
import org.eclipse.n4js.n4JS.ModifierUtils;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSFeatureUtils;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.utils.nodemodel.NodeModelAccess;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SemanticChangeProvider {
    static final String INTERNAL_ANNOTATION = AnnotationDefinition.INTERNAL.name;
    @Inject
    private NodeModelAccess nodeModelAccess;
    @Inject
    private N4JSElementKeywordProvider elementKeywordProvider;

    TextEdit setAccessModifiers(Document document, ModifiableElement element, N4Modifier modifier) {
        return this.setAccessModifiers(document, element, modifier, false);
    }

    TextEdit setAccessModifier(Document document, TypeDefiningElement element, N4Modifier modifier, boolean export) {
        if (!element.getDefinedType().isExported() && export) {
            return this.setAccessModifiers(document, (ModifiableElement)element, modifier, true);
        }
        if (element instanceof ModifiableElement) {
            return this.setAccessModifiers(document, (ModifiableElement)element, modifier, false);
        }
        return null;
    }

    private TextEdit setAccessModifiers(Document document, ModifiableElement element, N4Modifier modifier, boolean export) {
        ArrayList<N4Modifier> nonAccessModifier = new ArrayList<N4Modifier>();
        for (N4Modifier mod : element.getDeclaredModifiers()) {
            if (ModifierUtils.isAccessModifier((N4Modifier)mod)) continue;
            nonAccessModifier.add(mod);
        }
        nonAccessModifier.add(modifier);
        String exportPrefix = "";
        if (export) {
            exportPrefix = "export";
            if (nonAccessModifier.size() > 0) {
                exportPrefix = String.valueOf(exportPrefix) + " ";
            }
        }
        return this.setModifiers(document, (EObject)element, String.valueOf(exportPrefix) + this.sortedModifierString(nonAccessModifier));
    }

    TextEdit addCustomModifier(Document document, ModifiableElement element, String modifier) {
        ArrayList<N4Modifier> modifiers = new ArrayList<N4Modifier>((Collection<N4Modifier>)element.getDeclaredModifiers());
        String exportPrefix = modifier;
        if (modifiers.size() > 0) {
            exportPrefix = String.valueOf(exportPrefix) + " ";
        }
        return this.setModifiers(document, (EObject)element, String.valueOf(exportPrefix) + this.sortedModifierString(modifiers));
    }

    TextEdit setModifiers(Document document, EObject element, String modifiers) {
        int startOffset;
        EList declaredModifiers = element instanceof ModifiableElement ? ((ModifiableElement)element).getDeclaredModifiers() : Collections.emptyList();
        String extra_whitespace = "";
        int delete_extra_whitespace = 0;
        int endOffset = startOffset = this.modifierOffset(element);
        if (declaredModifiers.size() > 0) {
            ILeafNode endNode = ModifierUtils.getNodeForModifier((ModifiableElement)((ModifiableElement)element), (int)(declaredModifiers.size() - 1));
            endOffset = endNode.getOffset() + endNode.getLength();
        } else if (modifiers.length() > 0) {
            extra_whitespace = " ";
        }
        if (modifiers.length() == 0) {
            delete_extra_whitespace = 1;
        }
        int modifierLength = endOffset - startOffset + delete_extra_whitespace;
        return ChangeProvider.replace(document, startOffset, modifierLength, String.valueOf(modifiers) + extra_whitespace);
    }

    TextEdit setModifiers(Document document, ModifiableElement element, List<N4Modifier> modifiers) {
        return this.setModifiers(document, (EObject)element, this.sortedModifierString(modifiers));
    }

    TextEdit addModifier(Document document, ModifiableElement element, N4Modifier modifier) {
        ArrayList<N4Modifier> modifiers = new ArrayList<N4Modifier>((Collection<N4Modifier>)element.getDeclaredModifiers());
        modifiers.add(modifier);
        return this.setModifiers(document, (EObject)element, this.sortedModifierString(modifiers));
    }

    TextEdit removeModifier(Document document, ModifiableElement element, N4Modifier modifier) {
        ArrayList<N4Modifier> modifiers = new ArrayList<N4Modifier>();
        for (N4Modifier mod : element.getDeclaredModifiers()) {
            if (!Objects.equal((Object)mod.name(), (Object)modifier.name())) continue;
            modifiers.add(mod);
        }
        return this.setModifiers(document, (EObject)element, this.sortedModifierString(modifiers));
    }

    TextEdit addAnnotation(Document document, AnnotableElement element, String annotation) {
        if (annotation.equals(INTERNAL_ANNOTATION)) {
            return this.addInternalAnnotation(document, element);
        }
        if (this.getAnnotationWithName(element, annotation) != null) {
            return null;
        }
        ICompositeNode elementNode = NodeModelUtils.findActualNodeFor((EObject)element);
        return ChangeProvider.insertLinesAbove(document, elementNode.getOffset(), true, "@" + annotation);
    }

    private TextEdit addInternalAnnotation(Document document, AnnotableElement element) {
        if (this.getAnnotationWithName(element, INTERNAL_ANNOTATION) != null) {
            return null;
        }
        if (element instanceof ModifiableElement) {
            int offset = this.internalAnnotationOffset((ModifiableElement)element);
            return ChangeProvider.replace(document, offset, 0, "@" + INTERNAL_ANNOTATION + " ");
        }
        return null;
    }

    private int internalAnnotationOffset(ModifiableElement element) {
        if (!(element instanceof AnnotableElement)) {
            throw new IllegalArgumentException("Can't compute @Internal offset for non-annotable element");
        }
        EObject containerExportDeclaration = element.eContainer();
        if (containerExportDeclaration instanceof ExportDeclaration) {
            ILeafNode node = this.nodeModelAccess.nodeForKeyword(containerExportDeclaration, "export");
            if (node != null) {
                return node.getOffset();
            }
            throw new NullPointerException("Failed to retrieve node for export keyword");
        }
        return this.modifierOffset((EObject)element);
    }

    private Annotation getAnnotationWithName(AnnotableElement element, String annotationName) {
        for (Annotation anno : element.getAnnotations()) {
            if (!Objects.equal((Object)anno.getName(), (Object)annotationName)) continue;
            return anno;
        }
        return null;
    }

    private INode astNodeForKeyword(EObject element, String keyword) {
        return this.nodeModelAccess.nodeForKeyword(element, keyword);
    }

    private int modifierOffset(EObject element) {
        int offset = -1;
        if (element instanceof ModifiableElement && ((ModifiableElement)element).getDeclaredModifiers().size() > 0) {
            offset = ModifierUtils.getNodeForModifier((ModifiableElement)((ModifiableElement)element), (int)0).getOffset();
        } else {
            if (element instanceof N4GetterDeclaration) {
                offset = this.astNodeForKeyword(element, "get").getOffset();
            }
            if (element instanceof N4SetterDeclaration) {
                offset = this.astNodeForKeyword(element, "set").getOffset();
            }
            if (element instanceof FunctionDeclaration || element instanceof N4ClassDeclaration || element instanceof N4InterfaceDeclaration || element instanceof N4EnumDeclaration) {
                offset = this.astNodeForKeyword(element, this.elementKeywordProvider.keyword((Object)element)).getOffset();
            }
            if (element instanceof ExportedVariableStatement) {
                INode exportKeyword = this.astNodeForKeyword(element.eContainer(), "export");
                offset = exportKeyword.getOffset() + exportKeyword.getLength() + 1;
            }
            if (element instanceof N4MethodDeclaration) {
                INode node;
                EObject semElem;
                List nodes = null;
                nodes = NodeModelUtils.findNodesForFeature((EObject)element, (EStructuralFeature)N4JSPackage.Literals.GENERIC_DECLARATION__TYPE_VARS);
                if (nodes.isEmpty()) {
                    nodes = NodeModelUtils.findNodesForFeature((EObject)element, (EStructuralFeature)N4JSPackage.Literals.TYPED_ELEMENT__BOGUS_TYPE_REF);
                }
                if (nodes.isEmpty()) {
                    nodes = NodeModelUtils.findNodesForFeature((EObject)element, (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DEFINITION__GENERATOR);
                }
                if (nodes.isEmpty()) {
                    nodes = NodeModelUtils.findNodesForFeature((EObject)element, (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DEFINITION__DECLARED_ASYNC);
                }
                if (nodes.isEmpty()) {
                    nodes = NodeModelUtils.findNodesForFeature((EObject)element, (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME);
                }
                offset = nodes != null && !nodes.isEmpty() ? ((semElem = (node = (INode)nodes.get(0)).getSemanticElement()) instanceof TypeVariable ? node.getOffset() - 1 : node.getOffset()) : -1;
            }
            if (element instanceof NamedElement) {
                EStructuralFeature attr = N4JSFeatureUtils.attributeOfNameFeature((NamedElement)((NamedElement)element));
                List nodes = NodeModelUtils.findNodesForFeature((EObject)element, (EStructuralFeature)attr);
                if (nodes != null && !nodes.isEmpty()) {
                    ((INode)nodes.get(0)).getOffset();
                } else {
                    offset = -1;
                }
            }
        }
        if (offset == -1) {
            throw new IllegalArgumentException("Couldn't determine element modifier offset");
        }
        return offset;
    }

    TextEdit removeAnnotation(Document document, AnnotableElement element, String annotation) {
        ExportDeclaration expDecl;
        AnnotableElement annotatedElement = element;
        EList sourceList = null;
        Annotation targetAnnotation = null;
        targetAnnotation = this.getAnnotationWithName(annotatedElement, annotation);
        if (targetAnnotation != null) {
            sourceList = annotatedElement.getAnnotations();
        } else if (element.eContainer() instanceof ExportDeclaration && (targetAnnotation = this.getAnnotationWithName((AnnotableElement)(expDecl = (ExportDeclaration)element.eContainer()), annotation)) != null) {
            sourceList = expDecl.getAnnotations();
        }
        if (sourceList == null || targetAnnotation == null) {
            return null;
        }
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)targetAnnotation);
        int offset = node.getOffset();
        int length = node.getLength();
        if (targetAnnotation == IterableExtensions.head((Iterable)sourceList)) {
            ICompositeNode containerNode = NodeModelUtils.findActualNodeFor((EObject)targetAnnotation.eContainer());
            offset = containerNode.getOffset();
            length = node.getOffset() + node.getLength() - containerNode.getOffset();
        }
        if (element instanceof ModifiableElement) {
            ModifiableElement mElement = (ModifiableElement)element;
            Position offsetPosition = document.getPosition(offset);
            Position mOffsetPosition = document.getPosition(this.modifierOffset((EObject)mElement));
            if (offsetPosition.getLine() == mOffsetPosition.getLine()) {
                String contents = document.getContents();
                char trailingChar = contents.charAt(offset + length);
                char leadingChar = contents.charAt(offset - 1);
                if (Character.isWhitespace(leadingChar) && Character.isWhitespace(trailingChar)) {
                    ++length;
                }
            }
        }
        return ChangeProvider.removeText(document, offset, length, true);
    }

    public String sortedModifierString(List<N4Modifier> modifierList) {
        return IterableExtensions.join((Iterable)ModifierUtils.getSortedModifiers(modifierList), (CharSequence)" ");
    }
}

