/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonUtils {
    public static String getDeepAsString(JsonElement jsonElement, String ... propertyNames) {
        JsonElement result = JsonUtils.getDeep(jsonElement, propertyNames);
        if (result != null && result.isJsonPrimitive()) {
            return ((JsonPrimitive)result).getAsString();
        }
        return null;
    }

    public static JsonElement getDeep(JsonElement jsonElement, String ... propertyNames) {
        JsonElement curr = jsonElement;
        int i = 0;
        while (curr != null && i < propertyNames.length) {
            if (!curr.isJsonObject()) {
                return null;
            }
            curr = curr.getAsJsonObject().get(propertyNames[i++]);
        }
        return curr;
    }

    public static boolean changeProperties(JsonObject jsonObject, Set<String> propertyNames, JsonElement newValue) {
        HashSet existingPropertyNames = Sets.newHashSet(propertyNames);
        existingPropertyNames.retainAll(jsonObject.keySet());
        if (existingPropertyNames.isEmpty()) {
            return false;
        }
        for (String propertyName : existingPropertyNames) {
            jsonObject.add(propertyName, newValue);
        }
        return true;
    }

    public static JsonElement loadJson(Path path) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader in = Files.newBufferedReader(path);){
            JsonParser parser = new JsonParser();
            return parser.parse((Reader)in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void saveJson(Path path, JsonElement jsonElement) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter out = Files.newBufferedWriter(path, StandardOpenOption.TRUNCATE_EXISTING);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson(jsonElement, (Appendable)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void setVersionOfDependenciesInAllPackageJsonFiles(Path rootFolder, Set<String> namesOfDependencies, JsonElement versionToSet) throws FileNotFoundException, IOException {
        List packageJsonFiles = Files.walk(rootFolder, FileVisitOption.FOLLOW_LINKS).filter(p -> "package.json".equals(p.getFileName().toString())).collect(Collectors.toList());
        for (Path packageJsonFile : packageJsonFiles) {
            JsonUtils.setVersionOfDependenciesInPackageJsonFile(packageJsonFile, namesOfDependencies, versionToSet);
        }
    }

    public static void setVersionOfDependenciesInPackageJsonFile(Path packageJsonFile, Set<String> namesOfDependencies, JsonElement versionToSet) throws FileNotFoundException, IOException {
        JsonElement devDeps;
        if (namesOfDependencies.isEmpty()) {
            return;
        }
        JsonElement root = JsonUtils.loadJson(packageJsonFile);
        boolean changed = false;
        JsonElement deps = JsonUtils.getDeep(root, "dependencies");
        if (deps != null && deps.isJsonObject()) {
            changed |= JsonUtils.changeProperties((JsonObject)deps, namesOfDependencies, versionToSet);
        }
        if ((devDeps = JsonUtils.getDeep(root, "devDependencies")) != null && devDeps.isJsonObject()) {
            changed |= JsonUtils.changeProperties((JsonObject)devDeps, namesOfDependencies, versionToSet);
        }
        if (changed) {
            JsonUtils.saveJson(packageJsonFile, root);
        }
    }
}

