/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.n4js.smith.CollectedDataAccess;
import org.eclipse.n4js.smith.DataSeries;
import org.eclipse.n4js.smith.SimpleTimeFormat;
import org.eclipse.n4js.utils.IndentLevel;

public class DataCollectorUtils {
    public static String allDataToString(String indent) {
        ArrayList<String> rootKeys = new ArrayList<String>(CollectedDataAccess.getCollectorsKeys());
        Collections.sort(rootKeys);
        StringBuilder sb = new StringBuilder();
        for (String key : rootKeys) {
            if (sb.length() > 0) {
                sb.append(System.lineSeparator());
                sb.append(System.lineSeparator());
            }
            sb.append(DataCollectorUtils.dataToString(key, indent));
        }
        return sb.toString();
    }

    public static String dataToString(String key, String indent) {
        DataSeries dataSeries = CollectedDataAccess.getDataSeries(key);
        return DataCollectorUtils.dataToString(dataSeries, indent);
    }

    public static String dataToString(DataSeries series, String indent) {
        StringJoiner sj = new StringJoiner("\n");
        IndentLevel indentLevel = new IndentLevel(indent);
        sj.add(String.valueOf(indentLevel.get()) + SimpleTimeFormat.convert(series.sum) + " - " + series.name);
        DataCollectorUtils.collectData(series, sj, indentLevel);
        return sj.toString();
    }

    private static void collectData(DataSeries parentSeries, StringJoiner sj, IndentLevel indentLevel) {
        if (parentSeries.hasNoChildren()) {
            return;
        }
        indentLevel.increase();
        List siblings = parentSeries.getChildren().collect(Collectors.toList());
        Collections.sort(siblings, (s1, s2) -> Long.compare(s2.sum, s1.sum));
        long total = 0L;
        for (DataSeries series : siblings) {
            sj.add(String.valueOf(indentLevel.get()) + SimpleTimeFormat.convert(series.sum) + " - " + series.name);
            DataCollectorUtils.collectData(series, sj, indentLevel);
            total += series.sum.longValue();
        }
        long missing = parentSeries.sum - total;
        sj.add(String.valueOf(indentLevel.get()) + "NOT INCLUDED: " + SimpleTimeFormat.convert(missing));
        indentLevel.decrease();
    }
}

