/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.ide.symbol;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONBooleanLiteral;
import org.eclipse.n4js.json.JSON.JSONNullLiteral;
import org.eclipse.n4js.json.JSON.JSONNumericLiteral;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.JSON.util.JSONSwitch;
import org.eclipse.xtext.ide.server.symbol.DocumentSymbolMapper;

public class JSONDocumentSymbolNameProvider
extends DocumentSymbolMapper.DocumentSymbolNameProvider {
    private final JSONSwitch<String> impl = new Impl();

    public String getName(EObject object) {
        return (String)this.impl.doSwitch(object);
    }

    private static class Impl
    extends JSONSwitch<String> {
        private Impl() {
        }

        public String caseNameValuePair(NameValuePair object) {
            String valueAsString;
            JSONValue value = object.getValue();
            if (value != null && !value.isContainer() && (valueAsString = (String)this.doSwitch((EObject)value)) != null) {
                return String.format("%s : %s", object.getName(), valueAsString);
            }
            return object.getName();
        }

        public String caseJSONObject(JSONObject object) {
            return "<object>";
        }

        public String caseJSONArray(JSONArray object) {
            return "<array>";
        }

        public String caseJSONNumericLiteral(JSONNumericLiteral object) {
            return object.getValue().toString();
        }

        public String caseJSONStringLiteral(JSONStringLiteral object) {
            return String.format("\"%s\"", object.getValue());
        }

        public String caseJSONBooleanLiteral(JSONBooleanLiteral object) {
            return Boolean.toString(object.isBooleanValue());
        }

        public String caseJSONNullLiteral(JSONNullLiteral object) {
            return "null";
        }
    }
}

