/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.filechecker;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.eclipse.n4js.filechecker.FullReport;
import org.eclipse.n4js.filechecker.Report;
import org.eclipse.n4js.filechecker.ReportUtils;

public class CRHStatsPrinter {
    static final List<String> CANNOT_HAVE_CRH = Arrays.asList("png", "bmp", "gif", "jpeg", "class", "classpath", "properties", "prefs", "MF", "project", "_project", "graffle", "gitignore", "jar", "npmignore", "ico", "zip", "graffle", "pdf", "csv", "target", "licence", "license", "setup", "dict", "json", "launch", "svg", "xtextbin", "xml_gen", "replacement", "bib", "ecore", "genmodel", "gitattributes", "html_TEMPLATE", "icns", "ignored", "index", "map", "mappings", "placeholder", "product", "see", "sublime-project", "xpm", "exsd", "xlsx", "dummy", "xdoc", "xcf", "ext", "cspex", "api_filters", "b3aggr", "key");

    static boolean canHaveCRH(String extension) {
        return !CANNOT_HAVE_CRH.contains(extension);
    }

    static boolean cannotHaveCRH(String extension) {
        return CANNOT_HAVE_CRH.contains(extension);
    }

    public static void println(FullReport fullReport) {
        Collection<Report> reportsNoCRH = fullReport.getReportsNoCRH();
        Multimap<String, Report> hist = ReportUtils.getHistogram(reportsNoCRH, report -> report.getFileExtension());
        TreeMap<String, Collection<Report>> sortedHist = ReportUtils.sortByListSize(hist);
        System.out.println("Total number of files without copyright header in N4JS repository: " + reportsNoCRH.size());
        CRHStatsPrinter.printResultLine(sortedHist, CRHStatsPrinter::cannotHaveCRH, "-- Number of files that canNOT have a copyright header: ");
        CRHStatsPrinter.printResultLine(sortedHist, CRHStatsPrinter::canHaveCRH, "-- Number of files that can have a copyright header: ");
        Set interestingExt = sortedHist.keySet();
        interestingExt.removeAll(CANNOT_HAVE_CRH);
        for (String ext : interestingExt) {
            System.out.println("-------------------------------------------------------------------------------------");
            System.out.println("." + ext + " files with missing copyright header are (ignored excluded):");
            Collection<Report> notIgnored = ReportUtils.filterNotIgnoredReports(hist.get((Object)ext));
            for (Report report2 : notIgnored) {
                System.out.println("   " + report2.path.toString());
            }
        }
        System.out.println("=====================================================================================");
    }

    private static void printResultLine(Map<String, Collection<Report>> sortedHist, Function<String, Boolean> canDo, String text) {
        int sumCannotHaveCRH = 0;
        for (String ext : sortedHist.keySet()) {
            if (!canDo.apply(ext).booleanValue()) continue;
            sumCannotHaveCRH += sortedHist.get(ext).size();
        }
        System.out.println(String.valueOf(text) + sumCannotHaveCRH);
        int sumAll = 0;
        int sumIgnored = 0;
        for (String ext : sortedHist.keySet()) {
            if (!canDo.apply(ext).booleanValue()) continue;
            Collection<Report> extReports = sortedHist.get(ext);
            int extCount = extReports.size();
            int ignoredCount = ReportUtils.filterIgnoredReports(extReports).size();
            String line = String.format("   %-23s: %5s", ext, extCount);
            if (ignoredCount > 0) {
                line = String.valueOf(line) + String.format(", among them %5s ignored", ignoredCount);
            }
            System.out.println(line);
            sumAll += extCount;
            sumIgnored += ignoredCount;
        }
        System.out.println("   -----------------------------------------------------------------");
        String line = String.format("   %-23s: %5s, among them %5s ignored", "Sum", sumAll, sumIgnored);
        System.out.println(line);
        System.out.println();
    }
}

