/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.organize.imports;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.ui.changes.ChangeProvider;
import org.eclipse.n4js.ui.changes.IChange;
import org.eclipse.n4js.ui.organize.imports.XtextResourceUtils;
import org.eclipse.n4js.utils.nodemodel.NodeModelUtilsN4;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class ImportsRemovalChangesComputer {
    public static List<IChange> getImportDeletionChanges(XtextResource resource, IXtextDocument document) throws BadLocationException {
        ArrayList changes = CollectionLiterals.newArrayList();
        EList elements = XtextResourceUtils.getScript(resource).getScriptElements();
        for (ScriptElement el : elements) {
            if (!(el instanceof ImportDeclaration)) continue;
            ICompositeNode nodeToRemove = NodeModelUtils.findActualNodeFor((EObject)el);
            changes.add(ImportsRemovalChangesComputer.removeNodeButKeepComments(document, (INode)nodeToRemove));
        }
        return changes;
    }

    private static IChange removeNodeButKeepComments(IXtextDocument doc, INode importNode) throws BadLocationException {
        if (importNode == null) {
            return IChange.IDENTITY;
        }
        int offset = importNode.getOffset();
        int length = NodeModelUtilsN4.getNodeLengthWithASISupport((INode)importNode);
        return ChangeProvider.removeText(doc, offset, length, true);
    }
}

