/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.editor.contentassist;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ide.contentassist.antlr.lexer.InternalN4JSLexer;
import org.eclipse.n4js.ide.editor.contentassist.ContentAssistTokenTypeMapper;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.util.Strings;

public class NodeModelTokenSource
implements TokenSource {
    private Iterator<ILeafNode> leafNodes;
    private Token next;
    private final ContentAssistTokenTypeMapper tokenTypeMapper;
    private final Keyword semicolon;
    private final Keyword rightCurlyInBlock;
    private final Keyword rightCurlyInArrowExpression;
    private final int startOffset;
    private final int endOffset;
    private final RuleCall scriptElementCall;
    private final RuleCall memberDeclarationCall;
    private final RuleCall statementsCall;
    private final RuleCall propertyAssignmentCall1;
    private final RuleCall propertyAssignmentCall2;

    NodeModelTokenSource(INode node, ContentAssistTokenTypeMapper tokenTypeMapper, N4JSGrammarAccess grammarAccess, boolean filter) {
        this(node, 0, Integer.MAX_VALUE, tokenTypeMapper, grammarAccess, filter);
    }

    NodeModelTokenSource(INode node, int startOffset, int endOffset, ContentAssistTokenTypeMapper tokenTypeMapper, N4JSGrammarAccess grammarAccess, boolean filter) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.tokenTypeMapper = tokenTypeMapper;
        this.leafNodes = this.getLeafIterator((TreeIterator<AbstractNode>)((AbstractNode)node).basicIterator(), filter);
        this.rightCurlyInBlock = grammarAccess.getBlockAccess().getRightCurlyBracketKeyword_2();
        this.rightCurlyInArrowExpression = grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2();
        this.semicolon = grammarAccess.getSemiAccess().getSemicolonKeyword();
        this.scriptElementCall = grammarAccess.getScriptAccess().getScriptElementsScriptElementParserRuleCall_1_1_0();
        this.memberDeclarationCall = grammarAccess.getMembersAccess().getOwnedMembersRawN4MemberDeclarationParserRuleCall_1_0();
        this.statementsCall = grammarAccess.getBlockAccess().getStatementsStatementParserRuleCall_1_0();
        this.propertyAssignmentCall1 = grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsPropertyAssignmentParserRuleCall_2_0_0();
        this.propertyAssignmentCall2 = grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsPropertyAssignmentParserRuleCall_2_1_1_0();
    }

    private Iterator<ILeafNode> getLeafIterator(TreeIterator<AbstractNode> iterator, boolean filter) {
        return Iterators.filter(filter ? this.filterIterator(iterator) : iterator, ILeafNode.class);
    }

    private Iterator<INode> filterIterator(final TreeIterator<AbstractNode> iterator) {
        return new AbstractIterator<INode>(){

            protected INode computeNext() {
                if (iterator.hasNext()) {
                    ICompositeNode casted;
                    INode result = (INode)iterator.next();
                    if (result instanceof ICompositeNode && (casted = (ICompositeNode)result).getTotalEndOffset() < NodeModelTokenSource.this.endOffset - 1 && casted.hasChildren() && casted.getLookAhead() == 1) {
                        AbstractElement grammarElement = (AbstractElement)casted.getGrammarElement();
                        if (grammarElement == NodeModelTokenSource.this.scriptElementCall || grammarElement == NodeModelTokenSource.this.memberDeclarationCall) {
                            INode sibling = casted.getNextSibling();
                            while (sibling instanceof ILeafNode) {
                                ILeafNode siblingLeaf = (ILeafNode)sibling;
                                if (!siblingLeaf.isHidden()) break;
                                if (siblingLeaf.getTotalEndOffset() >= NodeModelTokenSource.this.endOffset) {
                                    return result;
                                }
                                sibling = siblingLeaf.getNextSibling();
                            }
                            iterator.prune();
                        } else if (grammarElement == NodeModelTokenSource.this.statementsCall) {
                            ICompositeNode parent = casted.getParent();
                            if (parent.getLookAhead() > 1) {
                                ILeafNode firstLeaf = (ILeafNode)Iterables.get((Iterable)casted.getLeafNodes(), (int)0);
                                int remainingLA = parent.getLookAhead();
                                Iterator parentLeafs = parent.getLeafNodes().iterator();
                                while (parentLeafs.hasNext() && remainingLA > 0) {
                                    ILeafNode leafNode = (ILeafNode)parentLeafs.next();
                                    if (leafNode != firstLeaf) {
                                        if (leafNode.isHidden() || --remainingLA != 0) continue;
                                        iterator.prune();
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else if (grammarElement == NodeModelTokenSource.this.propertyAssignmentCall1 || grammarElement == NodeModelTokenSource.this.propertyAssignmentCall2) {
                            iterator.prune();
                            for (ILeafNode leaf : casted.getLeafNodes()) {
                                if (leaf.isHidden()) continue;
                                return leaf;
                            }
                        }
                    }
                    return result;
                }
                return (INode)this.endOfData();
            }
        };
    }

    public Token nextToken() {
        if (this.next != null) {
            Token result = this.next;
            this.next = null;
            return result;
        }
        if (!this.leafNodes.hasNext()) {
            return Token.EOF_TOKEN;
        }
        ILeafNode leaf = this.leafNodes.next();
        if (leaf.getTotalOffset() >= this.endOffset) {
            this.leafNodes = Collections.emptyIterator();
            return Token.EOF_TOKEN;
        }
        if (leaf.getTotalEndOffset() <= this.startOffset) {
            return this.nextToken();
        }
        if (leaf.getTotalEndOffset() > this.endOffset) {
            return this.toPrefixToken(leaf);
        }
        SyntaxErrorMessage syntaxErrorMessage = leaf.getSyntaxErrorMessage();
        if (syntaxErrorMessage != null && "InternalSemicolonInjectingParser.ASI".equals(syntaxErrorMessage.getIssueCode())) {
            return this.toASIToken(leaf);
        }
        if (leaf.isHidden()) {
            return this.processHiddenToken(leaf);
        }
        int tokenType = this.tokenTypeMapper.getInternalTokenType(leaf);
        return new CommonToken(tokenType, leaf.getText());
    }

    private Token processHiddenToken(ILeafNode leaf) {
        Token result = this.nextToken();
        if (result == Token.EOF_TOKEN && Strings.countLineBreaks((CharSequence)leaf.getText()) > 0) {
            this.next = result;
            CommonToken hidden = new CommonToken(this.tokenTypeMapper.getInternalTokenType(leaf), leaf.getText());
            hidden.setChannel(99);
            return hidden;
        }
        return result;
    }

    private Token toASIToken(ILeafNode leaf) {
        if (leaf.isHidden()) {
            return this.newSemicolonToken(leaf);
        }
        if (!this.leafNodes.hasNext()) {
            int semicolonTokenType;
            int tokenType = this.tokenTypeMapper.getInternalTokenType(leaf);
            if (tokenType == (semicolonTokenType = this.tokenTypeMapper.getInternalTokenType((EObject)this.semicolon))) {
                return new CommonToken(semicolonTokenType, leaf.getText());
            }
            if (leaf.getTotalEndOffset() == this.endOffset) {
                this.leafNodes = Collections.emptyIterator();
                return new CommonToken(tokenType, leaf.getText());
            }
            this.next = new CommonToken(semicolonTokenType, leaf.getText());
            return new CommonToken(tokenType, leaf.getText());
        }
        if (leaf.getGrammarElement() == this.rightCurlyInBlock || leaf.getGrammarElement() == this.rightCurlyInArrowExpression) {
            int tokenType = this.tokenTypeMapper.getInternalTokenType(leaf);
            this.next = new CommonToken(tokenType);
            return new CommonToken(this.tokenTypeMapper.getInternalTokenType((EObject)this.semicolon), leaf.getText());
        }
        return this.newSemicolonToken(leaf);
    }

    private Token newSemicolonToken(ILeafNode leaf) {
        int tokenType = this.tokenTypeMapper.getInternalTokenType((EObject)this.semicolon);
        return new CommonToken(tokenType, leaf.getText());
    }

    private Token toPrefixToken(ILeafNode leaf) {
        InternalN4JSLexer lexer = new InternalN4JSLexer();
        String text = leaf.getText();
        String prefix = text.substring(0, this.endOffset - leaf.getTotalOffset());
        ANTLRStringStream stream = new ANTLRStringStream(prefix);
        lexer.setCharStream((CharStream)stream);
        Token nextToken = lexer.nextToken();
        return new CommonToken(nextToken.getType(), nextToken.getText());
    }

    public String getSourceName() {
        return "NodeModelTokenSource";
    }
}

