/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ide.xtext.server.IOrderInfo;
import org.eclipse.n4js.ide.xtext.server.ParallelBuildManager;
import org.eclipse.n4js.ide.xtext.server.ProjectBuildOrderInfo;
import org.eclipse.n4js.ide.xtext.server.XProjectManager;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;
import org.eclipse.n4js.ide.xtext.server.build.XBuildResult;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class XBuildManager {
    private static final Logger LOG = LogManager.getLogger(XBuildManager.class);
    public static final String CYCLIC_PROJECT_DEPENDENCIES = String.valueOf(XBuildManager.class.getName()) + ".cyclicProjectDependencies";
    @Inject
    private XWorkspaceManager workspaceManager;
    @Inject
    private ProjectBuildOrderInfo.Provider projectBuildOrderInfoProvider;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    private final LinkedHashSet<URI> dirtyFiles = new LinkedHashSet();
    private final LinkedHashSet<URI> deletedFiles = new LinkedHashSet();
    private final LinkedHashSet<URI> dirtyFilesAwaitingGeneration = new LinkedHashSet();
    private final LinkedHashSet<URI> deletedFilesAwaitingGeneration = new LinkedHashSet();
    private List<IResourceDescription.Delta> allBuildDeltas = new ArrayList<IResourceDescription.Delta>();

    public List<IResourceDescription.Delta> doInitialBuild(List<ProjectDescription> projects, CancelIndicator indicator) {
        ProjectBuildOrderInfo projectBuildOrderInfo = this.projectBuildOrderInfoProvider.get();
        IOrderInfo.IOrderIterator pboIterator = projectBuildOrderInfo.getIterator(projects);
        this.printBuildOrder();
        ArrayList<IResourceDescription.Delta> result = new ArrayList<IResourceDescription.Delta>();
        while (((ProjectBuildOrderInfo.ProjectBuildOrderIterator)pboIterator).hasNext()) {
            ProjectDescription description = ((ProjectBuildOrderInfo.ProjectBuildOrderIterator)pboIterator).next();
            String projectName = description.getName();
            XProjectManager projectManager = this.workspaceManager.getProjectManager(projectName);
            XBuildResult partialresult = projectManager.doInitialBuild(indicator);
            result.addAll(partialresult.getAffectedResources());
        }
        return result;
    }

    @Deprecated
    public List<IResourceDescription.Delta> doInitialBuild2(List<ProjectDescription> projects, final CancelIndicator indicator) {
        List<IResourceDescription.Delta> result = Collections.synchronizedList(new ArrayList());
        class BuildInitialProjectJob
        extends ParallelBuildManager.ParallelJob<String> {
            XProjectManager projectManager;
            List<IResourceDescription.Delta> result;

            BuildInitialProjectJob(XProjectManager projectManager, List<IResourceDescription.Delta> result) {
                this.projectManager = projectManager;
                this.result = result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runJob() {
                XBuildResult partialresult = this.projectManager.doInitialBuild(indicator);
                List<IResourceDescription.Delta> list = this.result;
                synchronized (list) {
                    this.result.addAll(partialresult.getAffectedResources());
                }
            }

            @Override
            public String getID() {
                return this.projectManager.getProjectConfig().getName();
            }

            @Override
            public Collection<String> getDependencyIDs() {
                return this.projectManager.getProjectDescription().getDependencies();
            }
        }
        ArrayList<BuildInitialProjectJob> jobs = new ArrayList<BuildInitialProjectJob>();
        for (ProjectDescription description : projects) {
            String projectName = description.getName();
            XProjectManager projectManager = this.workspaceManager.getProjectManager(projectName);
            BuildInitialProjectJob bpj = new BuildInitialProjectJob(projectManager, result);
            jobs.add(bpj);
        }
        ParallelBuildManager parallelBuildManager = new ParallelBuildManager(jobs);
        parallelBuildManager.run();
        return result;
    }

    public void doClean(CancelIndicator cancelIndicator) {
        this.dirtyFilesAwaitingGeneration.clear();
        this.deletedFilesAwaitingGeneration.clear();
        for (XProjectManager projectManager : this.workspaceManager.getProjectManagers()) {
            projectManager.doClean(cancelIndicator);
        }
    }

    public XBuildable getIncrementalDirtyBuildable(List<URI> dirtyFiles, List<URI> deletedFiles) {
        return this.doGetIncrementalBuildable(dirtyFiles, deletedFiles, false);
    }

    public XBuildable getIncrementalGenerateBuildable(List<URI> dirtyFiles, List<URI> deletedFiles) {
        return this.doGetIncrementalBuildable(dirtyFiles, deletedFiles, true);
    }

    private XBuildable doGetIncrementalBuildable(List<URI> dirtyFiles, List<URI> deletedFiles, boolean doGenerate) {
        this.queue(this.dirtyFiles, deletedFiles, dirtyFiles);
        this.queue(this.deletedFiles, dirtyFiles, deletedFiles);
        return cancelIndicator -> this.doIncrementalBuild(doGenerate, cancelIndicator);
    }

    protected List<IResourceDescription.Delta> doIncrementalBuild(boolean doGenerate, CancelIndicator cancelIndicator) {
        try {
            LinkedHashSet<URI> dirtyFilesToBuild = new LinkedHashSet<URI>(this.dirtyFiles);
            LinkedHashSet<URI> deletedFilesToBuild = new LinkedHashSet<URI>(this.deletedFiles);
            if (doGenerate) {
                dirtyFilesToBuild.addAll(this.dirtyFilesAwaitingGeneration);
                deletedFilesToBuild.addAll(this.deletedFilesAwaitingGeneration);
            }
            Map<ProjectDescription, Set<URI>> project2dirty = this.computeProjectToUriMap(dirtyFilesToBuild);
            Map<ProjectDescription, Set<URI>> project2deleted = this.computeProjectToUriMap(deletedFilesToBuild);
            Sets.SetView changedPDs = Sets.union(project2dirty.keySet(), project2deleted.keySet());
            ProjectBuildOrderInfo projectBuildOrderInfo = this.projectBuildOrderInfoProvider.get();
            IOrderInfo.IOrderIterator pboIterator = projectBuildOrderInfo.getIterator((Collection)changedPDs);
            while (((ProjectBuildOrderInfo.ProjectBuildOrderIterator)pboIterator).hasNext()) {
                ProjectDescription descr = ((ProjectBuildOrderInfo.ProjectBuildOrderIterator)pboIterator).next();
                XProjectManager projectManager = this.workspaceManager.getProjectManager(descr.getName());
                Set<URI> projectDirty = project2dirty.getOrDefault(descr, Collections.emptySet());
                Set<URI> projectDeleted = project2deleted.getOrDefault(descr, Collections.emptySet());
                XBuildResult projectResult = projectManager.doIncrementalBuild(projectDirty, projectDeleted, this.allBuildDeltas, doGenerate, cancelIndicator);
                List<IResourceDescription.Delta> newlyBuiltDeltas = projectResult.getAffectedResources();
                this.recordBuildProgress(newlyBuiltDeltas, doGenerate);
                ((ProjectBuildOrderInfo.ProjectBuildOrderIterator)pboIterator).visitAffected((List)newlyBuiltDeltas);
            }
            List<IResourceDescription.Delta> result = this.allBuildDeltas;
            this.allBuildDeltas = new ArrayList<IResourceDescription.Delta>();
            return result;
        }
        catch (CancellationException ce) {
            throw ce;
        }
        catch (Throwable th) {
            this.operationCanceledManager.propagateIfCancelException(th);
            this.dirtyFiles.clear();
            this.deletedFiles.clear();
            this.dirtyFilesAwaitingGeneration.clear();
            this.deletedFilesAwaitingGeneration.clear();
            throw th;
        }
    }

    protected void queue(Set<URI> files, Collection<URI> toRemove, Collection<URI> toAdd) {
        files.removeAll(toRemove);
        files.addAll(toAdd);
    }

    private Map<ProjectDescription, Set<URI>> computeProjectToUriMap(Collection<URI> uris) {
        HashMap<ProjectDescription, Set<URI>> project2uris = new HashMap<ProjectDescription, Set<URI>>();
        for (URI uri : uris) {
            XProjectManager projectManager = this.workspaceManager.getProjectManager(uri);
            ProjectDescription projectDescription = projectManager.getProjectDescription();
            if (!project2uris.containsKey(projectDescription)) {
                project2uris.put(projectDescription, new HashSet());
            }
            ((Set)project2uris.get(projectDescription)).add(uri);
        }
        return project2uris;
    }

    protected void recordBuildProgress(List<IResourceDescription.Delta> newlyBuiltDeltas, boolean didGenerate) {
        for (IResourceDescription.Delta delta : newlyBuiltDeltas) {
            URI uri = delta.getUri();
            this.dirtyFiles.remove(uri);
            this.deletedFiles.remove(uri);
            if (didGenerate) {
                this.dirtyFilesAwaitingGeneration.remove(uri);
                this.deletedFilesAwaitingGeneration.remove(uri);
                continue;
            }
            if (delta.getNew() != null) {
                this.deletedFilesAwaitingGeneration.remove(uri);
                this.dirtyFilesAwaitingGeneration.add(uri);
                continue;
            }
            this.dirtyFilesAwaitingGeneration.remove(uri);
            this.deletedFilesAwaitingGeneration.add(uri);
        }
        this.mergeWithUnreportedDeltas(newlyBuiltDeltas);
    }

    protected void mergeWithUnreportedDeltas(List<IResourceDescription.Delta> newDeltas) {
        if (this.allBuildDeltas.isEmpty()) {
            this.allBuildDeltas.addAll(newDeltas);
        } else {
            Map unreportedByUri = IterableExtensions.toMap(this.allBuildDeltas, IResourceDescription.Delta::getUri);
            for (IResourceDescription.Delta newDelta : newDeltas) {
                IResourceDescription.Delta unreportedDelta = (IResourceDescription.Delta)unreportedByUri.get(newDelta.getUri());
                if (unreportedDelta == null) {
                    this.allBuildDeltas.add(newDelta);
                    continue;
                }
                this.allBuildDeltas.remove(unreportedDelta);
                IResourceDescription _old = unreportedDelta.getOld();
                IResourceDescription _new = newDelta.getNew();
                this.allBuildDeltas.add((IResourceDescription.Delta)new DefaultResourceDescriptionDelta(_old, _new));
            }
        }
    }

    protected void printBuildOrder() {
        if (LOG.isInfoEnabled()) {
            ProjectBuildOrderInfo projectBuildOrderInfo = this.projectBuildOrderInfoProvider.get();
            ProjectBuildOrderInfo.ProjectBuildOrderIterator visitAll = projectBuildOrderInfo.getIterator().visitAll();
            String output = "Project build order:\n  " + IteratorExtensions.join((Iterator)visitAll, (CharSequence)"\n  ", ProjectDescription::getName);
            LOG.info((Object)output);
        }
    }

    public static interface XBuildable {
        public static final XBuildable NO_BUILD = cancelIndicator -> Collections.emptyList();

        public List<IResourceDescription.Delta> build(CancelIndicator var1);
    }

    protected static class XProjectBuildData {
        private final List<URI> dirtyFiles;
        private final List<URI> deletedFiles;

        public XProjectBuildData(List<URI> dirtyFiles, List<URI> deletedFiles) {
            this.dirtyFiles = dirtyFiles;
            this.deletedFiles = deletedFiles;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + (this.dirtyFiles == null ? 0 : this.dirtyFiles.hashCode());
            return prime * result + (this.deletedFiles == null ? 0 : this.deletedFiles.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XProjectBuildData other = (XProjectBuildData)obj;
            if (this.dirtyFiles == null ? other.dirtyFiles != null : !this.dirtyFiles.equals(other.dirtyFiles)) {
                return false;
            }
            return !(this.deletedFiles == null ? other.deletedFiles != null : !this.deletedFiles.equals(other.deletedFiles));
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("dirtyFiles", this.dirtyFiles);
            b.add("deletedFiles", this.deletedFiles);
            return b.toString();
        }

        public List<URI> getDirtyFiles() {
            return this.dirtyFiles;
        }

        public List<URI> getDeletedFiles() {
            return this.deletedFiles;
        }
    }
}

