/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.generator;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.generator.CompilerDescriptor;
import org.eclipse.n4js.generator.CompilerProperties;
import org.eclipse.n4js.generator.GeneratorException;
import org.eclipse.n4js.generator.GeneratorExceptionHandler;
import org.eclipse.n4js.generator.GeneratorOption;
import org.eclipse.n4js.generator.IGeneratorMarkerSupport;
import org.eclipse.n4js.generator.ISubGenerator;
import org.eclipse.n4js.generator.N4JSPreferenceAccess;
import org.eclipse.n4js.generator.UnresolvedProxyInSubGeneratorException;
import org.eclipse.n4js.internal.RaceDetectionHelper;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.resource.N4JSCache;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.utils.Log;
import org.eclipse.n4js.utils.ResourceNameComputer;
import org.eclipse.n4js.utils.StaticPolyfillHelper;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.n4js.validation.helper.FolderContainmentHelper;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.UriExtensions;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Log
public abstract class AbstractSubGenerator
implements ISubGenerator,
IGenerator2 {
    @Accessors
    private CompilerDescriptor compilerDescriptor = null;
    @Inject
    protected StaticPolyfillHelper staticPolyfillHelper;
    @Inject
    protected IN4JSCore n4jsCore;
    @Inject
    protected ResourceNameComputer resourceNameComputer;
    @Inject
    protected IResourceValidator resVal;
    @Inject
    protected N4JSCache cache;
    @Inject
    protected IGeneratorMarkerSupport genMarkerSupport;
    @Inject
    protected OperationCanceledManager operationCanceledManager;
    @Inject
    protected GeneratorExceptionHandler exceptionHandler;
    @Inject
    protected N4JSPreferenceAccess preferenceAccess;
    @Inject
    private FolderContainmentHelper containmentHelper;
    @Inject
    private UriExtensions uriExtensions;
    private static final Logger logger = Logger.getLogger(AbstractSubGenerator.class);

    @Override
    public CompilerDescriptor getCompilerDescriptor() {
        if (this.compilerDescriptor == null) {
            this.compilerDescriptor = this.getDefaultDescriptor();
        }
        return this.compilerDescriptor;
    }

    public void doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        this.doGenerate(input, (IFileSystemAccess)fsa);
    }

    public void beforeGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
    }

    public void afterGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
    }

    public void doGenerate(Resource input, IFileSystemAccess fsa) {
        try {
            this.genMarkerSupport.deleteMarker(input);
            this.updateOutputPath(fsa, this.getCompilerID(), input);
            this.internalDoGenerate(input, GeneratorOption.DEFAULT_OPTIONS, fsa);
        }
        catch (Throwable _t) {
            if (_t instanceof UnresolvedProxyInSubGeneratorException) {
                UnresolvedProxyInSubGeneratorException e = (UnresolvedProxyInSubGeneratorException)_t;
                this.genMarkerSupport.createMarker(input, e.getMessage(), IGeneratorMarkerSupport.Severity.ERROR);
            }
            if (_t instanceof Exception) {
                boolean _tripleEquals;
                Exception e_1 = (Exception)_t;
                this.operationCanceledManager.propagateIfCancelException((Throwable)e_1);
                String _elvis = null;
                String _xifexpression = null;
                if (input instanceof N4JSResource) {
                    TModule _module = ((N4JSResource)input).getModule();
                    String _moduleSpecifier = null;
                    if (_module != null) {
                        _moduleSpecifier = _module.getModuleSpecifier();
                    }
                    _xifexpression = _moduleSpecifier;
                }
                if (_xifexpression != null) {
                    _elvis = _xifexpression;
                } else {
                    URI _uRI = input.getURI();
                    String _string = null;
                    if (_uRI != null) {
                        _string = _uRI.toString();
                    }
                    _elvis = _string;
                }
                String target = _elvis;
                String msgMarker = "Severe error occurred while transpiling module " + target + ". Check error log for details about the failure.";
                this.genMarkerSupport.createMarker(input, msgMarker, IGeneratorMarkerSupport.Severity.ERROR);
                if (e_1 instanceof GeneratorException) {
                    throw (GeneratorException)e_1;
                }
                String _xifexpression_1 = null;
                String _message = e_1.getMessage();
                boolean bl = _tripleEquals = _message == null;
                if (_tripleEquals) {
                    String _name = e_1.getClass().getName();
                    _xifexpression_1 = "type=" + _name;
                } else {
                    String _message_1 = e_1.getMessage();
                    _xifexpression_1 = "message=" + _message_1;
                }
                String msg = _xifexpression_1;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Severe error occurred in transpiler=");
                String _compilerID = this.getCompilerID();
                _builder.append(_compilerID);
                _builder.append(" ");
                _builder.append(msg);
                _builder.append(".");
                this.exceptionHandler.handleError(_builder.toString(), e_1);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    @Override
    public boolean shouldBeCompiled(Resource input, CancelIndicator monitor) {
        boolean result;
        boolean autobuildEnabled = this.isActive(input);
        String _lowerCase = input.getURI().fileExtension().toLowerCase();
        boolean isXPECTMode = Objects.equal((Object)"xt", (Object)_lowerCase);
        URI inputUri = input.getURI();
        boolean bl = result = autobuildEnabled && this.isGenerateProjectType(inputUri) && this.hasOutput(inputUri) && this.isOutputNotInSourceContainer(inputUri) && this.isOutsideOfOutputFolder(inputUri) && this.isSource(inputUri) && (this.isNoValidate(inputUri) || this.isExternal(inputUri) || EMFPlugin.IS_ECLIPSE_RUNNING && !isXPECTMode || this.hasNoErrors(input, monitor)) && !this.isStaticPolyfillingModule(input) && this.hasNoPolyfillErrors(input, monitor);
        if (!result) {
            RaceDetectionHelper.log("Skip generation of artifacts from %s", (Object)input.getURI());
        }
        return result;
    }

    private boolean hasOutput(URI n4jsSourceURI) {
        String _outputPath = this.n4jsCore.getOutputPath(n4jsSourceURI);
        return _outputPath != null;
    }

    private boolean isSource(URI n4jsSourceURI) {
        return this.n4jsCore.findN4JSSourceContainer(n4jsSourceURI).isPresent();
    }

    private boolean isNoValidate(URI n4jsSourceURI) {
        return this.n4jsCore.isNoValidate(n4jsSourceURI);
    }

    private boolean isExternal(URI n4jsSourceURI) {
        Optional<? extends IN4JSSourceContainer> sourceContainerOpt = this.n4jsCore.findN4JSSourceContainer(n4jsSourceURI);
        boolean _isPresent = sourceContainerOpt.isPresent();
        if (_isPresent) {
            IN4JSSourceContainer sourceContainer = (IN4JSSourceContainer)sourceContainerOpt.get();
            return sourceContainer.isExternal();
        }
        return false;
    }

    private boolean hasNoPolyfillErrors(Resource input, CancelIndicator monitor) {
        N4JSResource resSPoly = this.staticPolyfillHelper.getStaticPolyfillResource(input);
        if (resSPoly == null) {
            return true;
        }
        return this.hasNoErrors((Resource)resSPoly, monitor);
    }

    private boolean hasNoErrors(Resource input, CancelIndicator monitor) {
        List issues = this.resVal.validate(input, CheckMode.ALL, monitor);
        if (issues == null) {
            this.warnDueToCancelation(input, null);
            return false;
        }
        Functions.Function1 _function = it -> {
            Severity _severity = it.getSeverity();
            return Objects.equal((Object)_severity, (Object)Severity.ERROR);
        };
        Iterable errors = IterableExtensions.filter((Iterable)issues, (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)errors);
        if (_isEmpty) {
            return true;
        }
        boolean _isDebugEnabled = logger.isDebugEnabled();
        if (_isDebugEnabled) {
            Consumer<Issue> _function_1 = it -> {
                URI _uRI = input.getURI();
                String _plus = _uRI + "  ";
                String _message = it.getMessage();
                String _plus_1 = String.valueOf(_plus) + _message;
                String _plus_2 = String.valueOf(_plus_1) + "  ";
                Severity _severity = it.getSeverity();
                String _plus_3 = String.valueOf(_plus_2) + _severity;
                String _plus_4 = String.valueOf(_plus_3) + " @L_";
                Integer _lineNumber = it.getLineNumber();
                String _plus_5 = String.valueOf(_plus_4) + _lineNumber;
                String _plus_6 = String.valueOf(_plus_5) + " ";
                logger.debug((Object)_plus_6);
            };
            errors.forEach(_function_1);
        }
        return false;
    }

    private void warnDueToCancelation(Resource input, Throwable exc) {
        URI _uRI = input.getURI();
        String _plus = "User canceled the validation of " + _uRI;
        String msg = String.valueOf(_plus) + ". Will not compile.";
        if (exc == null) {
            logger.warn((Object)msg);
        } else {
            logger.warn((Object)msg, exc);
        }
    }

    public boolean isGenerateProjectType(URI n4jsSourceURI) {
        ProjectType projectType;
        IN4JSProject project = (IN4JSProject)this.n4jsCore.findProject(n4jsSourceURI).orNull();
        return project == null || !Objects.equal((Object)(projectType = project.getProjectType()), (Object)ProjectType.VALIDATION) && !Objects.equal((Object)projectType, (Object)ProjectType.DEFINITION) && !Objects.equal((Object)projectType, (Object)ProjectType.PLAINJS);
    }

    public boolean isOutsideOfOutputFolder(URI n4jsSourceURI) {
        boolean _isContainedInOutputFolder = this.containmentHelper.isContainedInOutputFolder(n4jsSourceURI);
        return !_isContainedInOutputFolder;
    }

    public boolean isOutputNotInSourceContainer(URI n4jsSourceURI) {
        Optional<? extends IN4JSProject> project = this.n4jsCore.findProject(n4jsSourceURI);
        boolean _isPresent = project.isPresent();
        if (_isPresent) {
            boolean _isOutputContainedInSourceContainer = this.containmentHelper.isOutputContainedInSourceContainer((IN4JSProject)project.get());
            return !_isOutputContainedInSourceContainer;
        }
        return false;
    }

    protected abstract void internalDoGenerate(Resource var1, GeneratorOption[] var2, IFileSystemAccess var3);

    public String getTargetFileName(Resource n4jsSourceFile, String compiledFileExtension) {
        return this.resourceNameComputer.generateFileDescriptor(n4jsSourceFile, compiledFileExtension);
    }

    public Script rootElement(Resource resource) {
        return (Script)IterableExtensions.head((Iterable)Iterables.filter((Iterable)resource.getContents(), Script.class));
    }

    public String getCompiledFileExtension(Resource input) {
        return this.preferenceAccess.getPreference(input, this.getCompilerID(), CompilerProperties.COMPILED_FILE_EXTENSION, this.getDefaultDescriptor());
    }

    public String getCompiledFileSourceMapExtension(Resource input) {
        return this.preferenceAccess.getPreference(input, this.getCompilerID(), CompilerProperties.COMPILED_FILE_SOURCEMAP_EXTENSION, this.getDefaultDescriptor());
    }

    public void updateOutputPath(IFileSystemAccess fsa, String compilerID, Resource input) {
        OutputConfiguration conf;
        String _elvis = null;
        String _outputPath = this.n4jsCore.getOutputPath(input.getURI());
        _elvis = _outputPath != null ? _outputPath : "src-gen";
        String outputPath = _elvis;
        if (fsa instanceof AbstractFileSystemAccess && (conf = (OutputConfiguration)((AbstractFileSystemAccess)fsa).getOutputConfigurations().get(compilerID)) != null) {
            conf.setOutputDirectory(outputPath);
        }
    }

    public Path calculateNavigationFromOutputToSourcePath(IFileSystemAccess fsa, String compilerID, N4JSResource input) {
        Optional<? extends IN4JSProject> projectctContainer = this.n4jsCore.findProject(input.getURI());
        IN4JSProject project = (IN4JSProject)projectctContainer.get();
        Path projectPath = project.getLocation().toFileSystemPath();
        URI projectLocURI = ((SafeURI)project.getLocation().withTrailingPathDelimiter()).toURI();
        String outputPath = project.getOutputPath();
        Path outputRelativeLocation = this.getOutputRelativeLocation(input);
        URI inputURI = this.uriExtensions.withEmptyAuthority(input.getURI());
        URI completetSourceURI = inputURI.trimSegments(1).deresolve(projectLocURI);
        String completetSource = URIUtils.toFile((URI)completetSourceURI).toString();
        if (completetSource == null && project.getLocation().toURI() == input.getURI().trimSegments(1)) {
            completetSource = projectPath.toFile().getAbsolutePath();
        }
        Path fullOutpath = projectPath.resolve(outputPath).normalize().resolve(outputRelativeLocation).normalize();
        Path fullSourcePath = projectPath.resolve(completetSource).normalize();
        Path rel = fullOutpath.relativize(fullSourcePath);
        return rel;
    }

    private Path getOutputRelativeLocation(N4JSResource input) {
        boolean _lessThan;
        URI uri = this.uriExtensions.withEmptyAuthority(input.getURI());
        Path localOutputFilePath = Paths.get(this.resourceNameComputer.generateFileDescriptor(uri, ".XX"), new String[0]);
        int _nameCount = localOutputFilePath.getNameCount();
        boolean bl = _lessThan = _nameCount < 2;
        if (_lessThan) {
            return Paths.get("", new String[0]);
        }
        int _nameCount_1 = localOutputFilePath.getNameCount();
        int _minus = _nameCount_1 - 1;
        return localOutputFilePath.subpath(0, _minus);
    }

    public static final String calculateProjectBasedOutputDirectory(IN4JSProject project, boolean includeProjectName) {
        String _xifexpression = null;
        if (includeProjectName) {
            N4JSProjectName _projectName = project.getProjectName();
            String _plus = _projectName + "/";
            String _outputPath = project.getOutputPath();
            _xifexpression = String.valueOf(_plus) + _outputPath;
        } else {
            _xifexpression = project.getOutputPath();
        }
        return _xifexpression;
    }

    public abstract String getCompilerID();

    protected abstract CompilerDescriptor getDefaultDescriptor();

    public boolean isActive(Resource input) {
        return Boolean.valueOf(this.preferenceAccess.getPreference(input, this.getCompilerID(), CompilerProperties.IS_ACTIVE, this.getDefaultDescriptor()));
    }

    public boolean isNotStaticallyPolyfilled(Resource resource) {
        boolean _hasStaticPolyfill;
        TModule tmodule;
        boolean _isStaticPolyfillAware;
        return !(resource instanceof N4JSResource) || !(_isStaticPolyfillAware = (tmodule = N4JSResource.getModule(resource)).isStaticPolyfillAware()) || !(_hasStaticPolyfill = this.staticPolyfillHelper.hasStaticPolyfill(resource));
    }

    public boolean isStaticPolyfillingModule(Resource resource) {
        TModule tmodule = N4JSResource.getModule(resource);
        if (tmodule != null) {
            return tmodule.isStaticPolyfillModule();
        }
        return false;
    }

    @Override
    public boolean isApplicableTo(Resource input) {
        return this.shouldBeCompiled(input, null);
    }

    @Override
    public void setCompilerDescriptor(CompilerDescriptor compilerDescriptor) {
        this.compilerDescriptor = compilerDescriptor;
    }
}

