/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.dataflow.symbols;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Expression;

public abstract class Symbol {
    private Object cachedKey;
    public final Set<ControlFlowElement> definingContainers = new HashSet<ControlFlowElement>();

    public abstract String getName();

    public abstract ControlFlowElement getASTLocation();

    public boolean is(Expression expression) {
        return false;
    }

    public boolean is(Symbol alias) {
        return this.equals(alias);
    }

    public boolean isZeroLiteral() {
        return false;
    }

    public boolean isNullLiteral() {
        return false;
    }

    public boolean isUndefinedLiteral() {
        return false;
    }

    public boolean isVariableSymbol() {
        return !this.isUndefinedLiteral() && !this.isNullLiteral() && !this.isZeroLiteral();
    }

    public boolean isStrucuralAlias(Symbol symbol) {
        return false;
    }

    public EObject getDeclaration() {
        return null;
    }

    public Expression getContext() {
        return null;
    }

    public Symbol getContextSymbol() {
        return null;
    }

    protected Object createSymbolKey() {
        EObject key = this.getDeclaration();
        if (key == null) {
            key = this.getASTLocation();
        }
        return key;
    }

    public void addDefinitionCFE(ControlFlowElement defCFE) {
        ControlFlowElement cfContainer = FGUtils.getCFContainer(defCFE);
        this.definingContainers.add(cfContainer);
    }

    public final Object getSymbolKey() {
        if (this.cachedKey == null) {
            this.cachedKey = this.createSymbolKey();
        }
        return this.cachedKey;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Symbol)) {
            return false;
        }
        Symbol s = (Symbol)obj;
        return this.getSymbolKey().equals(s.getSymbolKey());
    }

    public int hashCode() {
        return this.getSymbolKey().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

